/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collections;
import java.util.HashSet;
import org.jdom.Element;
import se.expertsystem.intellij.PostProcessCompiler;
import se.expertsystem.intellij.ToggledProjectComponent;
import se.expertsystem.intellij.WrappingCompiler;

public abstract class PostProcessProjectComponent
implements ToggledProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)PostProcessProjectComponent.class.getName());
    protected Project project;
    protected boolean isActivated = false;
    protected PostProcessCompiler postCompiler;

    public Project getProject() {
        return this.project;
    }

    private void wrapCompiler() {
        Compiler[] compilers = this.getCompilerManager().getCompilers(TranslatingCompiler.class);
        for (int i = 0; i < compilers.length; ++i) {
            Compiler compiler = compilers[i];
            if (compiler.getClass().getName().equals(WrappingCompiler.class.getName())) {
                LOG.debug("Wrapping java compiler added by other plugin than " + this.getComponentName());
                break;
            }
            if (!"Java Compiler".equals(compiler.getDescription())) continue;
            WrappingCompiler wrappingCompiler = new WrappingCompiler((TranslatingCompiler)compiler);
            this.getCompilerManager().removeCompiler((Compiler)wrappingCompiler.getRealCompiler());
            this.getCompilerManager().addTranslatingCompiler((TranslatingCompiler)wrappingCompiler, new HashSet<LanguageFileType>(Collections.singleton(StdFileTypes.JAVA)), Collections.singleton(StdFileTypes.CLASS));
            LOG.debug("Java compiler wrapped by " + this.getComponentName());
        }
    }

    private CompilerManager getCompilerManager() {
        return CompilerManager.getInstance((Project)this.project);
    }

    @Override
    public void toggle() {
        this.changeTo(!this.isActivated);
    }

    @Override
    public void changeTo(boolean activated) {
        if (activated != this.isActivated) {
            if (activated) {
                this.wrapCompiler();
                this.getCompilerManager().addCompiler((Compiler)this.postCompiler);
                LOG.debug("Added compiler " + this.postCompiler);
            } else {
                this.getCompilerManager().removeCompiler((Compiler)this.postCompiler);
                LOG.debug("Removed compiler " + this.postCompiler);
            }
            this.isActivated = activated;
        }
    }

    protected void configLoaded(boolean activated) {
        this.changeTo(activated);
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    public void readExternal(Element element) throws InvalidDataException {
        boolean config = JDOMExternalizer.readBoolean((Element)element, (String)"isActivated");
        this.configLoaded(config);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizer.write((Element)element, (String)"isActivated", (boolean)this.isActivated);
    }
}

