/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.compiler.ClassInstrumentingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import se.expertsystem.intellij.CrossClassLoaderKey;
import se.expertsystem.intellij.ModuleTaggedProcessingItem;
import se.expertsystem.intellij.PluginUtils;
import se.expertsystem.intellij.PostCompileProcessingItem;
import se.expertsystem.intellij.RecentlyCompiledSink;

public abstract class PostProcessCompiler
implements ClassInstrumentingCompiler {
    private static Logger LOG = Logger.getInstance((String)PostProcessCompiler.class.getName());
    public static final Key<List<RecentlyCompiledSink.CompiledItem>> COMPILED_CLASSES = new CrossClassLoaderKey<List<RecentlyCompiledSink.CompiledItem>>("Compiled classes queued for post-process");

    public static List<RecentlyCompiledSink.CompiledItem> getRecentlyCompiled(CompileContext compileContext) {
        ArrayList list = (ArrayList)compileContext.getUserData(COMPILED_CLASSES);
        if (list == null) {
            list = new ArrayList();
            compileContext.putUserData(COMPILED_CLASSES, list);
        }
        return list;
    }

    protected List getQueuedProcessingItems(final CompileContext compileContext) {
        final ArrayList items = new ArrayList();
        try {
            ActionRunner.runInsideReadAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                public void run() {
                    for (RecentlyCompiledSink.CompiledItem outputItem : PostProcessCompiler.getRecentlyCompiled(compileContext)) {
                        String packageName = PluginUtils.resolvePackageName(outputItem.getOutputRoot(), outputItem.getOutputPath());
                        VirtualFile vf = VfsUtil.findFileByURL((URL)VfsUtil.convertToURL((String)VfsUtil.pathToUrl((String)outputItem.getOutputPath())));
                        items.add(new PostCompileProcessingItem(vf, packageName, outputItem.getSourceFile()));
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return items;
    }

    protected List getModuleTaggedProcessingItems(final CompileContext compileContext) {
        final ArrayList items = new ArrayList();
        try {
            ActionRunner.runInsideReadAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                public void run() {
                    HashMap<VirtualFile, Module> pathModules = new HashMap<VirtualFile, Module>();
                    CompileScope compileScope = compileContext.getCompileScope();
                    Module[] modules = compileScope.getAffectedModules();
                    for (int i = 0; i < modules.length; ++i) {
                        VirtualFile testOutput;
                        Module module = modules[i];
                        VirtualFile output = compileContext.getModuleOutputDirectory(module);
                        if (output != null) {
                            pathModules.put(output, module);
                            LOG.debug(output.getPath() + " points to " + module.getName());
                        }
                        if ((testOutput = compileContext.getModuleOutputDirectoryForTests(module)) == null) continue;
                        pathModules.put(testOutput, module);
                        LOG.debug(testOutput.getPath() + " points to " + module.getName());
                    }
                    for (RecentlyCompiledSink.CompiledItem outputItem : PostProcessCompiler.getRecentlyCompiled(compileContext)) {
                        if (outputItem.getOutputPath() == null) {
                            compileContext.addMessage(CompilerMessageCategory.WARNING, "AspectJ: Skipping " + outputItem.getSourceFile(), null, -1, -1);
                            continue;
                        }
                        String packageName = PluginUtils.resolvePackageName(outputItem.getOutputRoot(), outputItem.getOutputPath());
                        String classFileName = outputItem.getOutputPath();
                        Module module = null;
                        for (Map.Entry moduleEntry : pathModules.entrySet()) {
                            VirtualFile modulePath = (VirtualFile)moduleEntry.getKey();
                            if (modulePath == null || !classFileName.startsWith(modulePath.getPath())) continue;
                            module = (Module)moduleEntry.getValue();
                        }
                        if (module == null) {
                            LOG.info("No module found for: " + classFileName);
                        }
                        VirtualFile vf = VfsUtil.findFileByURL((URL)VfsUtil.convertToURL((String)VfsUtil.pathToUrl((String)classFileName)));
                        items.add(new ModuleTaggedProcessingItem(vf, packageName, outputItem.getSourceFile(), module));
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return items;
    }

    public final boolean validateConfiguration() {
        return true;
    }

    public final boolean validateConfiguration(CompileScope compileScope) {
        return true;
    }

    public ValidityState createValidityState(DataInputStream is) throws IOException {
        return new TimestampValidityState(is.readLong());
    }

    public ValidityState createValidityState(DataInput di) throws IOException {
        return new TimestampValidityState(di.readLong());
    }

    protected static Map sortItemsPerModule(FileProcessingCompiler.ProcessingItem[] processingItems) {
        LinkedHashMap<Module, ArrayList<ModuleTaggedProcessingItem>> filesPerModule = new LinkedHashMap<Module, ArrayList<ModuleTaggedProcessingItem>>();
        for (int i = 0; i < processingItems.length; ++i) {
            ModuleTaggedProcessingItem processingItem = (ModuleTaggedProcessingItem)processingItems[i];
            Module module = processingItem.getModule();
            ArrayList<ModuleTaggedProcessingItem> fileInThisModule = (ArrayList<ModuleTaggedProcessingItem>)filesPerModule.get(module);
            if (fileInThisModule == null) {
                fileInThisModule = new ArrayList<ModuleTaggedProcessingItem>();
                filesPerModule.put(module, fileInThisModule);
            }
            fileInThisModule.add(processingItem);
        }
        return filesPerModule;
    }
}

