/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PluginUtils {
    private static final Logger LOG = Logger.getInstance((String)PluginUtils.class.getName());
    private static final Class[] NO_PARAMETERS = new Class[0];
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile("(java|openjdk)\\s+version\\s+\"(\\d+)\\.(\\d+)");

    public static List getProjectClasspath(Project project, boolean includeJdk) throws IOException {
        ArrayList output = new ArrayList();
        Module[] modules = PluginUtils.getProjectModules(project);
        for (int i = 0; i < modules.length; ++i) {
            output.addAll(PluginUtils.getModuleClasspath(modules[i], includeJdk));
        }
        return output;
    }

    public static List getModuleClasspath(Module module, boolean includeJdk) throws IOException {
        String jdkPath = PluginUtils.getJdkHomePath(module);
        File jdkRtPath = new File(jdkPath);
        ArrayList<File> classpath = new ArrayList<File>();
        for (VirtualFile virtualFile : OrderEnumerator.orderEntries((Module)module).recursively().exportedOnly().getPathsList().getVirtualFiles()) {
            File f = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
            if (!f.exists() || !includeJdk && FileUtil.isAncestor((File)jdkRtPath, (File)f, (boolean)true)) continue;
            classpath.add(f);
        }
        return classpath;
    }

    public static List getModuleOutputs(Module module) {
        File testOutputPath;
        VirtualFile compilerOutputPathForTests;
        File outputPath;
        ArrayList<File> classpath = new ArrayList<File>();
        VirtualFile compilerOutputPath = PluginUtils.getCompilerOutputPath(module);
        if (compilerOutputPath != null && compilerOutputPath.exists() && (outputPath = VfsUtil.virtualToIoFile((VirtualFile)compilerOutputPath)).exists()) {
            classpath.add(outputPath);
        }
        if ((compilerOutputPathForTests = PluginUtils.getCompilerOutputPathForTests(module)) != null && compilerOutputPathForTests.exists() && (testOutputPath = VfsUtil.virtualToIoFile((VirtualFile)compilerOutputPathForTests)).exists()) {
            classpath.add(testOutputPath);
        }
        return classpath;
    }

    public static VirtualFile getCompilerOutputPath(Module module) {
        return PluginUtils.getModulePath("getCompilerOutputPath", module);
    }

    public static VirtualFile getCompilerOutputPathForTests(Module module) {
        return PluginUtils.getModulePath("getCompilerOutputPathForTests", module);
    }

    private static VirtualFile getModulePath(String methodName, Module module) {
        Class clazz = ModuleRootManager.class;
        try {
            clazz = Class.forName("com.intellij.openapi.roots.CompilerModuleExtension");
        }
        catch (ClassNotFoundException cnfex) {
            // empty catch block
        }
        try {
            Method instanceMethod = clazz.getDeclaredMethod("getInstance", Module.class);
            Object instance = instanceMethod.invoke(null, module);
            return (VirtualFile)clazz.getMethod(methodName, NO_PARAMETERS).invoke(instance, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List getPluginClasspath() {
        ClassLoader cl = PluginUtils.class.getClassLoader();
        Method[] methods = cl.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!List.class.isAssignableFrom(method.getReturnType())) continue;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                List urls = (List)method.invoke((Object)cl, (Object[])null);
                for (URL url : urls) {
                    classpath.add(PluginUtils.toFile(url));
                }
                return classpath;
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return null;
    }

    public static File toFile(String url) throws MalformedURLException {
        return PluginUtils.toFile(new URL(url));
    }

    public static File toFile(URL url) {
        try {
            String s = url.toString().replaceAll(" ", "%20");
            if (s.startsWith("file:") && !s.startsWith("file:/")) {
                s = "file:/" + s.substring("file:".length());
            }
            return new File(new URI(s));
        }
        catch (URISyntaxException usex) {
            LOG.error((Throwable)usex);
            throw new IllegalArgumentException("Illegal URL: " + url);
        }
    }

    public static String toUrlString(File file) {
        return PluginUtils.toURL(file).toString();
    }

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException muex) {
            LOG.error((Throwable)muex);
            return null;
        }
    }

    public static String resolvePackageName(String rootPath, String classPath) {
        String relativePath = classPath.substring(rootPath.length() + 1);
        int lastSlash = relativePath.lastIndexOf(47);
        return lastSlash != -1 ? relativePath.substring(0, lastSlash).replace('/', '.') : null;
    }

    public static String getJdkHomePath(Module module) {
        return PluginUtils.getModuleRootString(module, "getHomePath");
    }

    public static String getJdkVersionString(Module module) {
        return PluginUtils.getModuleRootString(module, "getVersionString");
    }

    private static String getModuleRootString(Module module, String methodName) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        try {
            Object jdk;
            try {
                jdk = ModuleRootManager.class.getMethod("getJdk", NO_PARAMETERS).invoke((Object)moduleRootManager, null);
            }
            catch (NoSuchMethodException e) {
                jdk = ModuleRootManager.class.getMethod("getSdk", NO_PARAMETERS).invoke((Object)moduleRootManager, null);
            }
            if (jdk == null) {
                throw new RuntimeException("Module " + module.getName() + " has no JDK!");
            }
            return (String)jdk.getClass().getMethod(methodName, NO_PARAMETERS).invoke(jdk, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isJava5(Project project) {
        Module[] modules = PluginUtils.getProjectModules(project);
        for (int i = 0; i < modules.length; ++i) {
            if (!PluginUtils.isJava5(modules[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isJava5(Module module) {
        String versionString = PluginUtils.getJdkVersionString(module);
        LOG.debug("Detected JDK: " + versionString);
        Matcher versionMatcher = JDK_VERSION_PATTERN.matcher(versionString);
        if (versionMatcher.find() && "1".equals(versionMatcher.group(2)) && versionMatcher.group(3).charAt(0) < '5') {
            LOG.debug("Pre 1.5 JDK: major " + versionMatcher.group(2) + " , minor " + versionMatcher.group(3));
            return false;
        }
        return true;
    }

    public static void setProgress(ProgressIndicator progressIndicator, int total, int current) {
        progressIndicator.setFraction(1.0 / ((double)total / (double)current));
    }

    public static void runProcessWithProgressSynchronously(Runnable runnable, String title, boolean cancelable, Project project) {
        String currentBuildNo = ApplicationInfo.getInstance().getBuildNumber();
        if ("5131".compareTo(currentBuildNo) <= 0) {
            PluginUtils.runProcessWithProgressSynchronously(ProgressManager.getInstance(), runnable, title, cancelable, project);
        } else {
            PluginUtils.runProcessWithProgressSynchronously(ApplicationManager.getApplication(), runnable, title, cancelable, project);
        }
    }

    private static void runProcessWithProgressSynchronously(Object o, Runnable runnable, String title, boolean cancelable, Project project) {
        try {
            Method method = o.getClass().getMethod("runProcessWithProgressSynchronously", Runnable.class, String.class, Boolean.TYPE, Project.class);
            method.invoke(o, runnable, title, cancelable ? Boolean.TRUE : Boolean.FALSE, project);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static Module[] getProjectModules(Project project) {
        ProjectModuleFinder projectModuleFinder = new ProjectModuleFinder(project);
        try {
            ActionRunner.runInsideReadAction((ActionRunner.InterruptibleRunnable)projectModuleFinder);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return projectModuleFinder.getModules();
    }

    private static class ProjectModuleFinder
    implements ActionRunner.InterruptibleRunnable {
        private final Project project;
        private Module[] modules;

        public ProjectModuleFinder(Project project) {
            this.project = project;
        }

        public void run() {
            this.modules = ModuleManager.getInstance((Project)this.project).getModules();
        }

        public Module[] getModules() {
            return this.modules;
        }
    }
}

