/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import se.expertsystem.intellij.ToggledProjectComponent;

public abstract class AbstractToggleAction
extends ToggleAction {
    private final Class componentClass;

    protected AbstractToggleAction(Class componentClass) {
        this.componentClass = componentClass;
    }

    public boolean isSelected(AnActionEvent event) {
        Project currentProject = (Project)event.getDataContext().getData(DataConstants.PROJECT);
        if (currentProject != null && currentProject.hasComponent(this.componentClass)) {
            ToggledProjectComponent component = (ToggledProjectComponent)currentProject.getComponent(this.componentClass);
            return component.isActivated();
        }
        return false;
    }

    public void setSelected(AnActionEvent event, boolean selected) {
        Project currentProject = (Project)event.getDataContext().getData(DataConstants.PROJECT);
        if (currentProject != null && currentProject.hasComponent(this.componentClass)) {
            ToggledProjectComponent component = (ToggledProjectComponent)currentProject.getComponent(this.componentClass);
            component.changeTo(selected);
        }
    }
}

