DROP TABLE IF EXISTS PLAYERS CASCADE;
DROP TABLE IF EXISTS EVENTS CASCADE;
DROP TABLE IF EXISTS GAMES CASCADE;
DROP TABLE IF EXISTS VARIANTS CASCADE;
DROP TABLE IF EXISTS MOVES CASCADE;
DROP TABLE IF EXISTS POSITIONS CASCADE;
DROP TABLE IF EXISTS POSITIONS_IN_GAME CASCADE;
DROP TABLE IF EXISTS CHESS_PIECES CASCADE;
DROP TABLE IF EXISTS FIELDS_ON_BOARD;

-- Create table players --
CREATE TABLE PLAYERS(
  ID UUID PRIMARY KEY NOT NULL,
  NAME VARCHAR(100) NOT NULL
);
CREATE INDEX players_player_id_index ON PLAYERS(ID);
CREATE INDEX players_name_index ON PLAYERS(NAME);

--Create table events --
CREATE TABLE EVENTS(
  ID UUID PRIMARY KEY NOT NULL,
  NAME VARCHAR(50) NULL,
  PLACE VARCHAR(50) NULL
);
CREATE INDEX events_event_id_index ON EVENTS(ID);
CREATE INDEX events_name_and_place_index ON EVENTS(NAME, PLACE);

--Create table games --
CREATE TABLE GAMES(
  ID UUID PRIMARY KEY NOT NULL,
  WHITE_PLAYER_ID UUID NOT NULL,
  BLACK_PLAYER_ID UUID NOT NULL,
  EVENT_ID UUID NOT NULL,
  GAME_DATE VARCHAR(11) NULL,
  GAME_ROUND VARCHAR(2) NULL,
  RESULT VARCHAR(10) NOT NULL,
  ADDITIONAL_INFO TEXT NULL,
  DESCRIPTION TEXT NULL
);
CREATE INDEX games_game_id_index ON GAMES(ID);
CREATE INDEX games_white_player_id_index ON GAMES(WHITE_PLAYER_ID);
CREATE INDEX games_black_player_id_index ON GAMES(BLACK_PLAYER_ID);
CREATE INDEX games_event_id_index ON GAMES(EVENT_ID);

-- Create table moves --
CREATE TABLE MOVES(
  ID UUID PRIMARY KEY NOT NULL,
  GAME_ID UUID NOT NULL,
  MOVE_NUMBER INT NOT NULL,
  START_FIELD VARCHAR(2) NOT NULL,
  FINAL_FIELD VARCHAR(2) NOT NULL,
  MOVE_TYPE VARCHAR(10) NOT NULL,
  MOVED_PIECE_CODE VARCHAR(3) NOT NULL,
  PROMOTED_PIECE_CODE VARCHAR(3) NULL,
  CAPTURED_PIECE_CODE VARCHAR(3) NULL,
  COMMENT TEXT NULL,
  VARIANT_ID INT NULL,
  FEN TEXT NOT NULL,
  POSITION_ID UUID NOT NULL,
  VARIANT_TYPE VARCHAR(2) NULL,
  ENTITY_NUMBER INT NOT NULL,
  SAN VARCHAR(50) NOT NULL
);
CREATE INDEX moves_move_id_index ON MOVES(ID);
CREATE INDEX moves_game_id_index ON MOVES(GAME_ID);
CREATE INDEX moves_fen_index ON MOVES(FEN);
CREATE INDEX moves_position_id_index ON MOVES(POSITION_ID);

--Create table positions --
CREATE TABLE POSITIONS(
  ID UUID PRIMARY KEY NOT NULL,
  FEN TEXT NOT NULL,
  WHITE_PIECES_COUNT INT NOT NULL,
  BLACK_PIECES_COUNT INT NOT NULL,
  WHITE_PAWNS_COUNT INT NOT NULL,
  BLACK_PAWNS_COUNT INT NOT NULL
);
CREATE INDEX positions_position_id_index ON POSITIONS(ID);
CREATE INDEX positions_fen_index ON POSITIONS(FEN);

-- Create table tags --
CREATE TABLE TAGS(
  NAME TEXT PRIMARY KEY NOT NULL
);
INSERT INTO TAGS VALUES('Event');
INSERT INTO TAGS VALUES('Site');
INSERT INTO TAGS VALUES('Date');
INSERT INTO TAGS VALUES('Round');
INSERT INTO TAGS VALUES('White');
INSERT INTO TAGS VALUES('Black');
INSERT INTO TAGS VALUES('Result');


-- Create table tree --
CREATE TABLE TREE(
  START_POSITION_ID UUID NOT NULL,
  FINAL_POSITION_ID UUID NOT NULL,
  MOVE_SAN VARCHAR(10) NOT NULL,
  MOVE_COUNT INT NOT NULL,
  PRIMARY KEY (START_POSITION_ID,MOVE_SAN)
);
-- Create table tree_status --
CREATE TABLE TREE_STATUS(
  IS_TREE_UP_TO_DATE BOOLEAN,
  IS_TREE_WITH_VARIANTS BOOLEAN
);

-- Create table chess_pieces --
CREATE TABLE CHESS_PIECES(
  CODE VARCHAR(3) PRIMARY KEY NOT NULL,
  COLOR VARCHAR(5) NOT NULL,
  NAME VARCHAR(10) NOT NULL
);
-- White Pieces
INSERT INTO CHESS_PIECES VALUES('WPN','WHITE','PAWN');
INSERT INTO CHESS_PIECES VALUES('WKT','WHITE','KNIGHT');
INSERT INTO CHESS_PIECES VALUES('WRK','WHITE','ROOK');
INSERT INTO CHESS_PIECES VALUES('WBP','WHITE','BISHOP');
INSERT INTO CHESS_PIECES VALUES('WQN','WHITE','QUEEN');
INSERT INTO CHESS_PIECES VALUES('WKG','WHITE','KING');
-- Black Pieces
INSERT INTO CHESS_PIECES VALUES('BPN','BLACK','PAWN');
INSERT INTO CHESS_PIECES VALUES('BKT','BLACK','KNIGHT');
INSERT INTO CHESS_PIECES VALUES('BRK','BLACK','ROOK');
INSERT INTO CHESS_PIECES VALUES('BBP','BLACK','BISHOP');
INSERT INTO CHESS_PIECES VALUES('BQN','BLACK','QUEEN');
INSERT INTO CHESS_PIECES VALUES('BKG','BLACK','KING');

-- Create table fields_on_board  --
CREATE TABLE FIELDS_ON_BOARD(
  CODE VARCHAR(2) PRIMARY KEY NOT NULL,
  XPOS INT NOT NULL,
  YPOS INT NOT NULL
);

--PL/SQL scripts
DO $$
DECLARE
  xPos VARCHAR(1)[]:=ARRAY['A','B','C','D','E','F','G','H'];
  yPos VARCHAR(1)[]:=ARRAY['1','2','3','4','5','6','7','8'];
  code VARCHAR(2); 
BEGIN
  FOR x in 1 .. 8 LOOP 
    FOR y in 1 .. 8 LOOP
      SELECT CONCAT(xPos[x],yPos[y]) INTO code; 
      INSERT INTO FIELDS_ON_BOARD(CODE,XPOS,YPOS) VALUES (code,x-1,y-1);
    END LOOP;  
  END LOOP;
END; $$;

