<!DOCTYPE html>
<html dir="ltr" lang="en" mode="ios">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=5.0" />
    <title>Ionicons Icon Component</title>
    <script type="module" src="/build/ionicons.esm.js"></script>
    <script nomodule src="/build/ionicons.js"></script>
  </head>

  <body>
    <h1>Ionicons</h1>

    <h2>Default</h2>
    <ion-icon name="cellular"></ion-icon>
    <ion-icon name="at"></ion-icon>
    <ion-icon name="call"></ion-icon>
    <ion-icon name="football"></ion-icon>
    <ion-icon name="analytics"></ion-icon>
    <ion-icon name="grid"></ion-icon>
    <ion-icon name="funnel"></ion-icon>
    <ion-icon name="watch"></ion-icon>
    <ion-icon name="add-circle-outline"></ion-icon>

    <h2>Mode from html ios mode attribute</h2>
    <ion-icon md="logo-android" ios="logo-apple"></ion-icon>
    <ion-icon md="logo-android" ios="logo-apple"></ion-icon>

    <h2>Mode set on icon</h2>
    <ion-icon mode="ios" md="logo-android" ios="logo-apple"></ion-icon>
    <ion-icon mode="md" md="logo-android" ios="logo-apple"></ion-icon>

    <h2>Colors</h2>
    <ion-icon color="primary" name="cellular"></ion-icon>
    <ion-icon color="secondary" name="at"></ion-icon>
    <ion-icon color="tertiary" name="call"></ion-icon>
    <ion-icon color="success" name="football"></ion-icon>
    <ion-icon color="warning" name="analytics"></ion-icon>
    <ion-icon color="danger" name="grid"></ion-icon>
    <ion-icon color="light" name="funnel"></ion-icon>
    <ion-icon color="medium" name="watch"></ion-icon>
    <ion-icon color="dark" name="toggle"></ion-icon>

    <h2>Stroke width</h2>
    <ion-icon name="heart-outline" style="--ionicon-stroke-width: 8px"></ion-icon>

    <h2>Font size</h2>
    <ion-icon name="book" style="font-size: 50px"></ion-icon>
    <ion-icon src="./assets/bug_report.svg" style="font-size: 50px"></ion-icon>

    <h2>Custom SVGs</h2>
    <ion-icon src="./assets/bug_report.svg"></ion-icon>
    <ion-icon src="./assets/chat.svg"></ion-icon>
    <ion-icon src="./assets/commute.svg"></ion-icon>
    <ion-icon src="./assets/copyright.svg"></ion-icon>
    <ion-icon src="./assets/done_all.svg"></ion-icon>
    <ion-icon src="./assets/lock_open.svg"></ion-icon>
    <ion-icon src="./assets/toll.svg"></ion-icon>
    <ion-icon src="./assets/web_asset.svg"></ion-icon>
    <ion-icon src="./assets/work_outline.svg"></ion-icon>

    <h2>Custom SVGs: colors</h2>
    <ion-icon color="primary" src="./assets/bug_report.svg"></ion-icon>
    <ion-icon color="secondary" src="./assets/chat.svg"></ion-icon>
    <ion-icon color="tertiary" src="./assets/commute.svg"></ion-icon>
    <ion-icon color="success" src="./assets/copyright.svg"></ion-icon>
    <ion-icon color="warning" src="./assets/done_all.svg"></ion-icon>
    <ion-icon color="danger" src="./assets/lock_open.svg"></ion-icon>
    <ion-icon color="light" src="./assets/toll.svg"></ion-icon>
    <ion-icon color="medium" src="./assets/web_asset.svg"></ion-icon>
    <ion-icon color="dark" src="./assets/work_outline.svg"></ion-icon>

    <h2>Custom CSS</h2>
    <ion-icon class="custom" name="grid"></ion-icon>
    <ion-icon class="custom" name="funnel"></ion-icon>
    <ion-icon class="custom" name="watch"></ion-icon>
    <ion-icon class="custom" name="logo-react"></ion-icon>
    <ion-icon class="custom" name="logo-javascript"></ion-icon>
    <ion-icon class="custom" name="logo-angular"></ion-icon>
    <ion-icon class="custom" src="./assets/done_all.svg"></ion-icon>
    <ion-icon class="custom" src="./assets/web_asset.svg"></ion-icon>
    <ion-icon class="custom" src="./assets/work_outline.svg"></ion-icon>

    <h2>Aria</h2>
    <ion-icon name="cellular"></ion-icon>
    <ion-icon name="cellular" aria-label="Mobile data"></ion-icon>
    <ion-icon name="cellular" aria-hidden="true"></ion-icon>

    <h1>RTL</h1>

    <h2>Default: Non-arrows</h2>
    <ion-icon name="cut"></ion-icon>
    <ion-icon name="call"></ion-icon>
    <ion-icon name="checkbox"></ion-icon>
    <ion-icon name="brush"></ion-icon>

    <h2>Flip: Non-arrows</h2>
    <ion-icon name="cut" flip-rtl></ion-icon>
    <ion-icon name="call" flip-rtl></ion-icon>
    <ion-icon name="checkbox" flip-rtl></ion-icon>
    <ion-icon name="brush" flip-rtl></ion-icon>

    <h2>Auto Flip: arrows</h2>
    <ion-icon name="arrow-up"></ion-icon>
    <ion-icon name="arrow-forward"></ion-icon>
    <ion-icon name="arrow-down"></ion-icon>
    <ion-icon name="arrow-back"></ion-icon>

    <h2>Un-flip: arrows</h2>
    <ion-icon name="arrow-up" flip-rtl="false"></ion-icon>
    <ion-icon name="arrow-forward" flip-rtl="false"></ion-icon>
    <ion-icon name="arrow-down" flip-rtl="false"></ion-icon>
    <ion-icon name="arrow-back" flip-rtl="false"></ion-icon>

    <h2>Auto Flip: chevrons</h2>
    <ion-icon name="chevron-up"></ion-icon>
    <ion-icon name="chevron-forward"></ion-icon>
    <ion-icon name="chevron-down"></ion-icon>
    <ion-icon name="chevron-back"></ion-icon>

    <h2>Un-flip: chevrons</h2>
    <ion-icon name="chevron-up" flip-rtl="false"></ion-icon>
    <ion-icon name="chevron-forward" flip-rtl="false"></ion-icon>
    <ion-icon name="chevron-down" flip-rtl="false"></ion-icon>
    <ion-icon name="chevron-back" flip-rtl="false"></ion-icon>

    <h2>Sanitized (shouldn't show)</h2>
    <ion-icon src="./assets/sanitize.svg"></ion-icon>

    <h2>Not Sanitized (should show)</h2>
    <ion-icon sanitize="false" src="./assets/no-sanitize.svg"></ion-icon>

    <p>
      <a href="./cheatsheet.html">Cheatsheet</a>
    </p>

    <style>
      body {
        margin: 0;
        padding: 16px;
        font-size: 32px;
        font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
      }

      h1 {
        margin: 15px 0 5px;
        font-size: 25px;
      }

      h2 {
        margin: 15px 0 5px;
        font-size: 18px;
      }

      .custom {
        stroke: red;
        fill: blue;
      }
    </style>
  </body>
</html>
