/*! grapesjs-plugin-forms - 0.2.10 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["grapesjs-plugin-placeholder"] = factory();
	else
		root["grapesjs-plugin-placeholder"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 3);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (editor) {
  var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var c = opt;

  var bm = editor.BlockManager;

  if (c.blocks.indexOf('input') >= 0) {
    bm.add('input', {
      label: '\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,9 C22,8.4 21.5,8 20.75,8 L3.25,8 C2.5,8 2,8.4 2,9 L2,15 C2,15.6 2.5,16 3.25,16 L20.75,16 C21.5,16 22,15.6 22,15 L22,9 Z M21,15 L3,15 L3,9 L21,9 L21,15 Z"></path>\n        <polygon class="gjs-block-svg-path" points="4 10 5 10 5 14 4 14"></polygon>\n      </svg>\n      <div class="gjs-block-label">' + c.labelInputName + '</div>',
      category: 'Forms',
      content: '<input class="input"/>'
    });
  }

  if (c.blocks.indexOf('TextPlaceholder') >= 0) {
    bm.add('TextPlaceholder', {
      label: '\n      <div class="gjs-fonts gjs-f-text"></div>\n      <div class="gjs-block-label">' + c.labelTextPlaceholderName + '</div>',
      category: 'Forms',
      content: {
        type: 'TextPlaceholder',
        content: 'text',
        style: { padding: '10px' },
        activeOnRender: 1
      },
      attributes: { type: 'placeholder' },
      copyable: false
    });
  }

  editor.on('block:drag:stop', function (model) {

    if (model.attributes.type == 'custom-type' || model.attributes.type == 'TextPlaceholder') {

      var modal = editor.Modal;
      modal.setTitle("Please Select Available Token");
      modal.setContent('<select id="customVariable"></select><br /><button id="sbm">submit</button>');
      var p = c.param;
      $('#customVariable').append($('<option>', {
        value: "",
        text: 'Please Select'
      }));
      $.each(p, function (i, item) {
        if (i != "" || Object.keys(i).length > 0) {
          $('#customVariable').append($('<option>', {
            value: item,
            text: item
          }));
        }
      });
      modal.open();

      $("#sbm").on("click", function () {
        console.log(model);

        var val = $("#customVariable").val();
        if (val != "") {
          model.set('content', val);
          console.log("." + model.cid);
          var doc = editor.Canvas.getBody().ownerDocument;
          doc.querySelector("." + model.cid).innerHTML = val;
        }
        modal.close();
      });
    } else {
      //model.set('content', 'test2');
    }
  });

  // Parse a URL into its parts
  var parseURL = function parseURL(url) {
    var p = document.createElement('a');

    p.href = url;

    var obj = {
      'protocol': p.protocol,
      'hostname': p.hostname,
      'port': p.port,
      'pathname': p.pathname,
      'search': p.search,
      'query': p.search.substring(1),
      'args': parseStr(p.search.substring(1)),
      'hash': p.hash,
      'host': p.host
    };

    return obj;
  };
  // Parse a query string
  var parseStr = function parseStr(string) {
    var args = string.split('&');
    var argsParsed = {};

    for (var i = 0; i < args.length; i++) {
      var arg = decodeURIComponent(args[i]);

      if (arg.indexOf('=') == -1) {
        argsParsed[arg.trim()] = true;
      } else {
        var kvp = arg.split('=');
        argsParsed[kvp[0].trim()] = kvp[1].trim();
      }
    }

    return argsParsed;
  };
};

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (editor) {
  var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var c = opt;
  var domc = editor.DomComponents;
  var defaultType = domc.getType('default');
  var textType = domc.getType('text');
  var defaultModel = defaultType.model;
  var defaultView = defaultType.view;
  var textModel = textType.model;
  var textView = textType.view;

  var stateNormal = 'Normal';
  var stateSuccess = 'Success';
  var stateError = 'Error';

  var idTrait = {
    name: 'id',
    label: c.labelTraitId
  };

  var forTrait = {
    name: 'for',
    label: c.labelTraitFor
  };

  var nameTrait = {
    name: 'name',
    label: c.labelTraitName
  };

  var placeholderTrait = {
    name: 'placeholder',
    label: c.labelTraitPlaceholder
  };

  var valueTrait = {
    name: 'value',
    label: c.labelTraitValue
  };

  var requiredTrait = {
    type: 'checkbox',
    name: 'required',
    label: c.labelTraitRequired
  };

  var checkedTrait = {
    label: c.labelTraitChecked,
    type: 'checkbox',
    name: 'checked',
    changeProp: 1
  };

  var preventDefaultClick = function preventDefaultClick() {
    return defaultType.view.extend({
      events: {
        'mousedown': 'handleClick'
      },

      handleClick: function handleClick(e) {
        e.preventDefault();
      }
    });
  };

  // INPUT
  domc.addType('input', {
    model: defaultModel.extend({
      defaults: Object.assign({}, defaultModel.prototype.defaults, {
        'custom-name': c.labelInputName,
        tagName: 'input',
        draggable: '*',
        droppable: false,
        traits: [nameTrait, placeholderTrait, {
          label: c.labelTraitType,
          type: 'select',
          name: 'type',
          options: [{ value: 'text', name: c.labelTypeText }, { value: 'email', name: c.labelTypeEmail }, { value: 'password', name: c.labelTypePassword }, { value: 'number', name: c.labelTypeNumber }]
        }, requiredTrait]
      })
    }, {
      isComponent: function isComponent(el) {
        if (el.tagName == 'INPUT') {
          return { type: 'input' };
        }
      }
    }),
    view: defaultView
  });

  var inputType = domc.getType('input');
  var inputModel = inputType.model;
  //custom-type #286 issue?
  domc.addType('TextPlaceholder', {
    model: defaultModel.extend({
      defaults: Object.assign({}, defaultModel.prototype.defaults, {
        'custom-name': c.labelButtonName,
        tagName: 'div',
        draggable: '*',
        droppable: true,
        attributes: { type: 'placeholder' },

        traits: [{
          type: 'content',
          label: 'Text'
        }],
        content: {
          type: 'text',
          content: 'text',
          style: { padding: '10px' },
          activeOnRender: 1
        }
      })
    }, {
      isComponent: function isComponent(el) {
        if (el.tagName == 'div') {
          return { type: 'div' };
        }
      }
    }),
    view: defaultView.extend({
      events: {
        'click': 'handleClick'
        //'active': 'alert("a")',
        //'drop': 'alert("a")',
        //'block:drag:stop': 'doStuff',
      },

      init: function init() {
        //this.listenTo(this.model, 'change:content', this.updateContent);
        //this.listenTo(this.model, 'active', this.doStuff);
      },
      doStuff: function doStuff() {
        //alert("a")

        var modal = editor.Modal;
        modal.setTitle("Please Select Available Token");
        modal.setContent('<select id="customVariable"></select><br /><button id="sbm">submit</button>');
        var p = c.param;
        $('#customVariable').append($('<option>', {
          value: "",
          text: 'Please Select'
        }));
        $.each(p.args, function (i, item) {
          if (i != "" || Object.keys(i).length > 0) {
            $('#customVariable').append($('<option>', {
              value: item,
              text: item
            }));
          }
        });
        modal.open();

        $("#sbm").on("click", function () {
          //console.log(Object.keys(model))
          console.log(this.model.cid);
          var val = $("#customVariable").val();
          if (val != "") {
            //window.zzxx = model
            console.log(this.model.child.cid);
            $('.' + this.model.child.cid).innerHTML = val;
            //model.config.content = "tt"
            //model.setContent(val)
          }
          modal.close();
        });
      },
      handleClick: function handleClick(e) {

        e.preventDefault();
      }
    })
  });
};

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (editor) {
  var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var trm = editor.TraitManager;
  var textTrat = trm.getType('text');

  trm.addType('content', {
    events: {
      'keyup': 'onChange'
    },

    onValueChange: function onValueChange() {
      var md = this.model;
      var target = md.target;
      target.set('content', md.get('value'));
    },

    getInputEl: function getInputEl() {
      if (!this.inputEl) {
        this.inputEl = textTrat.prototype.getInputEl.bind(this)();
        this.inputEl.value = this.target.get('content');
      }
      return this.inputEl;
    }
  });

  trm.addType('select-options', {
    events: {
      'keyup': 'onChange'
    },

    onValueChange: function onValueChange() {
      var optionsStr = this.model.get('value').trim();
      var options = optionsStr.split('\n');
      var optComps = [];
      for (var i = 0; i < options.length; i++) {
        var optionStr = options[i];
        var option = optionStr.split('::');
        var opt = {
          tagName: 'option',
          attributes: {}
        };
        if (option[1]) {
          opt.content = option[1];
          opt.attributes.value = option[0];
        } else {
          opt.content = option[0];
          opt.attributes.value = option[0];
        }
        optComps.push(opt);
      }
      var comps = this.target.get('components');
      comps.reset(optComps);
      this.target.view.render();
    },

    getInputEl: function getInputEl() {
      if (!this.$input) {
        var md = this.model;
        var trg = this.target;
        var name = md.get('name');
        var optionsStr = '';
        var opts = { placeholder: '' };
        var options = trg.get('components');
        for (var i = 0; i < options.length; i++) {
          var option = options.models[i];
          var optAttr = option.get('attributes');
          var optValue = optAttr.value || '';
          optionsStr += optValue + (optValue ? '::' : '') + option.get('content') + '\n';
        }
        this.$input = $('<textarea>', opts);
        this.$input.val(optionsStr);
      }
      return this.$input.get(0);
    }
  });
};

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


grapesjs.plugins.add('gjs-plugin-placeholder', function (editor, opts) {
  var c = opts || {};
  var config = editor.getConfig();
  var pfx = config.stylePrefix;

  var defaults = {
    blocks: ['TextPlaceholder'],
    labelTextPlaceholderName: 'TextPlaceholder',
    labelTraitType: 'Type',
    labelTypeSubmit: 'Submit',
    labelTypeReset: 'Reset',
    labelTypeButton: 'Button'
  };

  for (var name in defaults) {
    if (!(name in c)) c[name] = defaults[name];
  }

  // Add components
  var loadComponents = __webpack_require__(1);
  loadComponents.default(editor, c);

  // Add traits
  __webpack_require__(2).default(editor, c);

  // Add blocks
  var loadBlocks = __webpack_require__(0);
  loadBlocks.default(editor, c);
});

/***/ })
/******/ ]);
});