# PHP GrapesJS

## This is a PHP-based CMS that uses the GrapesJS Web Builder Framework, it also includes an access and registration system. 

Easy installation recommendation, unzip your source in the folder to install and follow each step each step, in case you need to configure your database first, the page.sql file is in the installer/sql/ folder then continue with installation. 

Many more functionalities are being developed, but as this is very functional and practical.

## Dashboard
### Basic and classic.
<img src="https://pepiuox.net/files/builder1.jpg">
<hr>

## Builder
### Build and edit your web site.
<img src="https://pepiuox.net/files/builder2.jpg">
<hr>

### Components drag and drop.
<img src="https://pepiuox.net/files/builder3.jpg">
<hr>

## First step
### Installation start, connect to database.
<img src="https://pepiuox.net/files/first-step.jpg">
<hr>

## Second step
### Verify the base connection and create database.
<img src="https://pepiuox.net/files/second-step1.jpg">
<hr>

## Third step
### Install tables.
<img src="https://pepiuox.net/files/third-step.jpg">
<hr>

## Fourth step
### Define configuration.
<img src="https://pepiuox.net/files/fourth-step1.jpg">
<hr>

## Fifth step
### Create user for administration.
<img src="https://pepiuox.net/files/fifth-step1.jpg">
<hr>

## Sixth step
### Create file connection and installation completion.
<img src="https://pepiuox.net/files/sixth-step.jpg">
<hr>

## Seventh step 
### Rename installation files, to prevent illegal installations. 

# CRUD system included.
## Create, read, update and delete data from your tables without making forms. 

## Plugins

### Extensions
* [grapesjs-plugin-export](https://github.com/artf/grapesjs-plugin-export) - Export GrapesJS templates in a zip archive
* [grapesjs-plugin-filestack](https://github.com/artf/grapesjs-plugin-filestack) - Add Filestack uploader in Asset Manager
* [grapesjs-plugin-ckeditor](https://github.com/artf/grapesjs-plugin-ckeditor) - Replaces the built-in RTE with CKEditor
* [grapesjs-aviary](https://github.com/artf/grapesjs-aviary) - Add the Aviary Image Editor (dismissed, use the plugin below instead)
* [grapesjs-tui-image-editor](https://github.com/artf/grapesjs-tui-image-editor) - GrapesJS TOAST UI Image Editor
* [grapesjs-blocks-basic](https://github.com/artf/grapesjs-blocks-basic) - Basic set of blocks
* [grapesjs-plugin-forms](https://github.com/artf/grapesjs-plugin-forms) - Set of form components and blocks
* [grapesjs-navbar](https://github.com/artf/grapesjs-navbar) - Simple navbar component
* [grapesjs-component-countdown](https://github.com/artf/grapesjs-component-countdown) - Simple countdown component
* [grapesjs-style-gradient](https://github.com/artf/grapesjs-style-gradient) - Add `gradient` type input to the Style Manager
* [grapesjs-style-filter](https://github.com/artf/grapesjs-style-filter) - Add `filter` type input to the Style Manager
* [grapesjs-blocks-flexbox](https://github.com/artf/grapesjs-blocks-flexbox) - Add the flexbox block
* [grapesjs-lory-slider](https://github.com/artf/grapesjs-lory-slider) - Slider component by using [lory](https://github.com/meandmax/lory)
* [grapesjs-tabs](https://github.com/artf/grapesjs-tabs) - Simple tabs component
* [grapesjs-tooltip](https://github.com/artf/grapesjs-tooltip) - Simple, CSS only, tooltip component for GrapesJS
* [grapesjs-custom-code](https://github.com/artf/grapesjs-custom-code) - Embed custom code
* [grapesjs-touch](https://github.com/artf/grapesjs-touch) - Enable touch support
* [grapesjs-indexeddb](https://github.com/artf/grapesjs-indexeddb) - Storage wrapper for IndexedDB
* [grapesjs-firestore](https://github.com/artf/grapesjs-firestore) - Storage wrapper for [Cloud Firestore](https://firebase.google.com/docs/firestore)
* [grapesjs-parser-postcss](https://github.com/artf/grapesjs-parser-postcss) - Custom CSS parser for GrapesJS by using [PostCSS](https://github.com/postcss/postcss)

### Presets
* [grapesjs-preset-webpage](https://github.com/artf/grapesjs-preset-webpage) - Webpage Builder
* [grapesjs-preset-newsletter](https://github.com/artf/grapesjs-preset-newsletter) - Newsletter Builder
* [grapesjs-mjml](https://github.com/artf/grapesjs-mjml) - Newsletter Builder with MJML components

<hr>

## Dear friends.
### This application is being developed, there are parts that are not yet fully functional, but the creation of pages if it is useful and is in function, if you want to contribute to the development, it would be of great help.
Thanks to all of whom I use your code to implement this development.
