# Bug Bounty Free Resources 
Introduction

What is a bug?

Security bug or vulnerability is “a weakness in the computational logic (e.g., code) found in software and hardware components that, when exploited, results in a negative impact to confidentiality, integrity, OR availability.
What is Bug Bounty?

A bug bounty or bug bounty program is IT jargon for a reward or bounty program given for finding and reporting a bug in a particular software product. Many IT companies offer bug bounties to drive product improvement and get more interaction from end users or clients. Companies that operate bug bounty programs may get hundreds of bug reports, including security bugs and security vulnerabilities, and many who report those bugs stand to receive awards.

What is the Reward?

There are all types of rewards based on the severity of the issue and the cost to fix. They may range from real money (most prevalent) to premium subscriptions (Prime/Netflix), discount coupons (for e commerce of shopping sites), gift vouchers, swags (apparels, badges, customized stationery, etc.). Money may range from 50$ to 50,000$ and even more.
What to learn?

Technical

Computer Fundamentals

https://www.comptia.org/training/by-certification/a

https://www.tutorialspoint.com/computer_fundamentals/index.htm

https://onlinecourses.swayam2.ac.in/cec19_cs06/preview

https://www.udemy.com/course/complete-computer-basics-course/

https://www.coursera.org/courses?query=computer%20fundamentals

Computer Networking

https://www.udacity.com/course/computer-networking--ud436

https://www.coursera.org/professional-certificates/google-it-support

https://www.udemy.com/course/introduction-to-computer-networks/

Operating Systems

https://www.coursera.org/learn/os-power-user

https://www.udacity.com/course/introduction-to-operating-systems--ud923

https://www.udemy.com/course/linux-command-line-volume1/


Programming C

https://www.programiz.com/c-programming

Where to learn from?


Blogs and Articles

Hacking Articles: https://www.hackingarticles.in/

Vickie Li Blogs: https://vickieli.dev/

Bugcrowd Blogs: https://www.bugcrowd.com/blog/

Intigriti Blogs: https://blog.intigriti.com/

Portswigger Blogs: https://portswigger.net/blog

Forums

Reddit: https://www.reddit.com/r/websecurity/

Reddit: https://www.reddit.com/r/netsec/

Official Websites

OWASP: https://owasp.org/

PortSwigger: https://portswigger.net/

Cloudflare: https://www.cloudflare.com/

YouTube Channels
https://www.youtube.com/@penetestersquad


PRACTICE! PRACTICE! and PRACTICE!
CTF

Hacker 101: https://www.hackerone.com/hackers/hacker101

PicoCTF: https://picoctf.org/

TryHackMe: https://tryhackme.com/ (premium/free)

HackTheBox: https://www.hackthebox.com/ (premium)

VulnHub: https://www.vulnhub.com/

HackThisSite: https://hackthissite.org/

CTFChallenge: https://ctfchallenge.co.uk/

PentesterLab: https://pentesterlab.com/ (premium)

Online Labs


PortSwigger Web Security Academy: https://portswigger.net/web-security

OWASP Juice Shop: https://owasp.org/www-project-juice-shop/

XSSGame: https://xss-game.appspot.com/

BugBountyHunter: https://www.bugbountyhunter.com/ (premium)

W3Challs : https://w3challs.com/

Offline Labs

DVWA: https://dvwa.co.uk/

bWAPP: http://www.itsecgames.com/

Metasploitable2: https://sourceforge.net/projects/metasploitable/files/Metasploitable2/

BugBountyHunter: https://www.bugbountyhunter.com/ (premium)

W3Challs : https://w3challs.com/

More Tools and Services To use
Servers

Shodan - Search Engine for the Internet of Everything

Censys Search - Search Engine for every server on the Internet to reduce exposure and improve security

Onyphe.io - Cyber Defense Search Engine for open-source and cyber threat intelligence data

ZoomEye - Global cyberspace mapping

GreyNoise - The source for understanding internet noise

Natlas - Scaling Network Scanning

Netlas.io - Discover, Research and Monitor any Assets Available Online

FOFA - Cyberspace mapping

Quake - Cyberspace surveying and mapping system

Hunter - Internet Search Engines For Security Researchers

Vulnerabilities

NIST NVD - US National Vulnerability Database

MITRE CVE - Identify, define, and catalog publicly disclosed cybersecurity vulnerabilities

GitHub Advisory Database - Security vulnerability database inclusive of CVEs and GitHub originated security advisories

cloudvulndb.org - The Open Cloud Vulnerability & Security Issue Database

osv.dev - Open Source Vulnerabilities

Vulners.com - Your Search Engine for Security Intelligence

opencve.io - Easiest way to track CVE updates and be alerted about new vulnerabilities

security.snyk.io - Open Source Vulnerability Database

Mend Vulnerability Database - The largest open source vulnerability DB

Rapid7 - DB - Vulnerability & Exploit Database

CVEDetails - The ultimate security vulnerability datasource

VulnIQ - Vulnerability intelligence and management solution

SynapsInt - The unified OSINT research tool

Aqua Vulnerability Database - Vulnerabilities and weaknesses in open source applications and cloud native infrastructure

Vulmon - Vulnerability and exploit search engine

VulDB - Number one vulnerability database

ScanFactory - Realtime Security Monitoring

Trend Micro Zero Day Initiative - Publicly disclosed vulnerabilities discovered by Zero Day Initiative researchers

Google Project Zero - Vulnerabilities including Zero Days

Trickest CVE Repository - Gather and update all available and newest CVEs with their PoC

cnvd.org.cn - Chinese National Vulnerability Database

InTheWild.io - Check CVEs in our free, open source feed of exploited vulnerabilities

Vulnerability Lab - Vulnerability research, bug bounties and vulnerability assessments

Red Hat Security Advisories - Information about security flaws that affect Red Hat products and services in the form of security advisories

Cisco Security Advisories - Security advisories and vulnerability information for Cisco products, including network equipment and software

Microsoft Security Response Center - Reports of security vulnerabilities affecting Microsoft products and services

VARIoT - VARIoT IoT Vulnerabilities Database

Exploits

Exploit-DB - Exploit Database

Sploitus - Convenient central place for identifying the newest exploits

Rapid7 - DB - Vulnerability & Exploit Database

Vulmon - Vulnerability and exploit search engine

packetstormsecurity.com - Information Security Services, News, Files, Tools, Exploits, Advisories and Whitepapers

0day.today - Ultimate database of exploits and vulnerabilities

LOLBAS - Living Off The Land Binaries, Scripts and Libraries

GTFOBins - Curated list of Unix binaries that can be used to bypass local security restrictions in misconfigured systems

Payloads All The Things - A list of useful payloads and bypasses for Web Application Security

XSS Payloads - The wonderland of JavaScript unexpected usages, and more

exploitalert.com - Database of Exploits

Reverse Shell generator - Online Reverse Shell generator with Local Storage functionality, URI & Base64 Encoding, MSFVenom Generator, and Raw Mode

HackerOne hacktivity - See the latest hacker activity on HackerOne

Bugcrowd Crowdstream - Showcase of accepted and disclosed submissions on Bugcrowd programs

GTFOArgs - Curated list of Unix binaries that can be manipulated for argument injection

shell-storm.org/shellcode - Shellcodes database for study cases

Hacking the Cloud - Encyclopedia of the attacks/tactics/techniques that offensive security professionals can use on their next cloud exploitation adventure

LOLDrivers - Open-source project that brings together vulnerable, malicious, and known malicious Windows drivers

PwnWiki - Collection of TTPs (tools, tactics, and procedures) for what to do after access has been gained

CVExploits Search - Your comprehensive database for CVE exploits from across the internet

VARIoT - VARIoT IoT exploits database

LOOBins - Detailed information on various built-in macOS binaries and how they can be used by threat actors for malicious purposes

Coalition Exploit Scoring System - Model that dynamically scores new and existing vulnerabilities to reflect their exploit likelihood

WADComs - Interactive cheat sheet containing a curated list of offensive security tools and their respective commands to be used against Windows/AD environments

LOLAPPS - Compendium of applications that can be used to carry out day-to-day exploitation

Living off the Hardware - Resource collection that provides guidance on identifying and utilizing malicious hardware and malicious devices

Living Off the Pipeline - How development tools commonly used in CI/CD pipelines can be used to achieve arbitrary code execution


Bug Bounty Platforms
Crowdsourcing

Bugcrowd: https://www.bugcrowd.com/

Hackerone: https://www.hackerone.com/

Intigriti: https://www.intigriti.com/

YesWeHack: https://www.yeswehack.com/

OpenBugBounty: https://www.openbugbounty.org/

Individual Programs

Meta: https://www.facebook.com/whitehat

Google: https://about.google/appsecurity/

Bug Bounty Report Format
Title

The first impression is the last impression, the security engineer looks at the title first and he should be able to identify the issue.
Write about what kind of functionality you can able to abuse or what kind of protection you can bypass. Write in just one line.
Include the Impact of the issue in the title if possible.
Description

This component provides details of the vulnerability, you can explain the vulnerability here, write about the paths, endpoints, error messages you got while testing. You can also attach HTTP requests, vulnerable source code.
Steps to Reproduce

Write the stepwise process to recreate the bug. It is important for an app owner to be able to verify what you've found and understand the scenario.
You must write each step clearly in-order to demonstrate the issue. that helps security engineers to triage fast.
Proof of Concept

This component is the visual of the whole work. You can record a demonstration video or attach screenshots.
Impact

Write about the real-life impact, How an attacker can take advantage if he/she successfully exploits the vulnerability.
What type of possible damages could be done? (avoid writing about the theoretical impact)
Should align with the business objective of the organization

## 🔍 Learn Vulnerabilities
- [Exploit Notes](https://exploit-notes.hdks.org/)
- [Bug Bounty Hunting](https://www.bugbountyhunting.com/)
- [Mind Maps](https://github.com/imran-parray/Mind-Maps)
- [CQR Company - IDOR](https://cqr.company/?s=idor)
- [MindAPI References](https://dsopas.github.io/MindAPI/references/)
- [MindAPI Play](https://dsopas.github.io/MindAPI/play/)
- [Web Security Vulnerabilities](https://notes.defendergb.org/web-sec/vuln/)
- [How To Hunt](https://github.com/coderahsan/HowToHunt)
- [Acunetix Web Vulnerabilities](https://www.acunetix.com/vulnerabilities/web/)
- [Vulnerability Checklist](https://github.com/Az0x7/vulnerability-Checklist)
- [Web App Hacking](https://s0cm0nkey.gitbook.io/s0cm0nkeys-security-reference-guide/red-offensive/web-app-hacking)
- [Handbook for Web Applications](https://0xffsec.com/handbook/web-applications/)
- [Awesome Bug Bounty Writeups](https://github.com/devanshbatham/Awesome-Bugbounty-Writeups/tree/master)
- [HowToHunt](https://kathan19.gitbook.io/howtohunt/)
- [Automated Scanners](https://gabb4r.gitbook.io/oscp-notes/web-http/automated-scanners)
- [Ired Team](https://www.ired.team/)
- [HolyTips](https://github.com/HolyBugx/HolyTips/tree/main/Resources)
- [Awesome Web Security](https://github.com/qazbnm456/awesome-web-security)
- [Vulnerable Machines](https://bitvijays.github.io/LFC-VulnerableMachines.html)
- [Web Vulnerabilities Methodology](https://hacktricks.boitatech.com.br/pentesting-web/web-vulnerabilities-methodology)
- [LFI Cheat Sheet](https://highon.coffee/blog/lfi-cheat-sheet/)
- [PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings/)
- [Web Vulnerabilities Methodology](https://book.hacktricks.xyz/pentesting-web/web-vulnerabilities-methodology)
- [Network Security](https://www.network-sec.de/)
- [Practical Bug Bounty](https://practicalbugbounty.com)
- [OffSec Tools](https://offsec.tools/)
- [Detectify Blog](https://blog.detectify.com/)
- [Web App Pentest](https://workbook.securityboat.in/resources/web-app-pentest/)
- [Projects Cheat Sheet](https://0xn3va.gitbook.io/projects/)
- [SalmonSec Cheat Sheet](https://salmonsec.com/cheatsheethome)
- [Burp Suite Extensions](https://apps.burpsuite.guide/)
- [Awesome Burp Extensions](https://github.com/snoopysecurity/awesome-burp-extensions)
- [BugBounty](https://github.com/00xtrace/BugBounty)

## 📝 Writeups
- [Awesome Bug Bounty Writeups](https://github.com/devanshbatham/Awesome-Bugbounty-Writeups/tree/master)
- [Pentester Land Writeups](https://pentester.land/writeups/)
- [Detectify Blog](https://blog.detectify.com/)
- Writeups

Medium: https://medium.com/analytics-vidhya/a-beginners-guide-to-cyber-security-3d0f7891c93a

Infosec Writeups: https://infosecwriteups.com/?gi=3149891cc73d

Hackerone Hacktivity: https://hackerone.com/hacktivity

Google VRP Writeups: https://github.com/xdavidhu/awesome-google-vrp-writeups

## 🔎 Recon
- [YouTube Video 1](https://www.youtube.com/watch?v=p4JgIu1mceI)
- [YouTube Video 2](https://www.youtube.com/watch?v=SYExiynPEKM)
- [YouTube Video 3](https://www.youtube.com/watch?v=IbdEoocfEmE)
- [Google Presentation](https://docs.google.com/presentation/d/1AA0gX2-SI_9ErTkBhtW0b-5BH70-1B1X/edit#slide=id.p9)

## 🛠️ The Bug Hunter’s Methodology
- [YouTube Video](https://www.youtube.com/watch?v=HmDY7w8AbR4)
- [Mind Maps](https://github.com/imran-parray/Mind-Maps)
- [Galaxy Bug Bounty Checklist](https://github.com/0xmaximus/Galaxy-Bugbounty-Checklist)
- [Bug Bounty Mindmap](https://github.com/Ignitetechnologies/Mindmap/tree/main)
- [Bug Bounty Methodology](https://xmind.app/m/cKAVyk/)
  
## 🏋️ Practice
- [RingZer0 CTF](https://ringzer0ctf.com/)
- [Root Me](https://www.root-me.org/?lang=en)
- [Offensive Security Labs](https://www.offsec.com/labs/individual/)
- [PortSwigger](https://portswigger.net/)
- [VulnHub](https://www.vulnhub.com/)
- [OverTheWire](https://overthewire.org/wargames/)
- [HackXpert Labs](https://labs.hackxpert.com/)
- [Let's Defend](https://app.letsdefend.io/training)
- [EchoCTF](https://echoctf.red/)
- [AuthLab](https://authlab.digi.ninja/)
- [Prompt Riddle](https://promptriddle.com/)
- [247CTF](https://247ctf.com/dashboard)
- [CTFLearn](https://ctflearn.com/challenge/1/browse)
- [W3Challs](https://w3challs.com/challenges/list/web)
- [CrackMes](https://crackmes.one/)
- [CryptoHack](https://cryptohack.org/challenges/)
- [Hacker101](https://www.hacker101.com/)
- [Hack This Site](https://www.hackthissite.org/)
- [PicoCTF](https://picoctf.org/)
- [Pwnable.xyz](https://pwnable.xyz/challenges/)
- [Hacking Hub](https://www.hackinghub.io/)
- [Bug Bounty Hunter](https://www.bugbountyhunter.com/)
- [Java Vulnerable Lab](https://github.com/CSPF-Founder/JavaVulnerableLab)
- [Java Security Course](https://github.com/CSPF-Founder/JavaSecurityCourse)
- [Web Hacking KR](https://webhacking.kr/chall.php)
- [WebSec FR](http://websec.fr/)
- [Suninatas](http://suninatas.com/challenges/web)
- [Promptriddle](https://promptriddle.com/)
- [PwnTN](https://pwn.tn/)
- [HBH Authentication](https://hbh.sh/authentication)
- [Thematic Enigmas](https://enigmes-a-thematiques.fr/front/categorie/7)


You can explore these resources to learn and practice various aspects of cybersecurity, including vulnerability assessment, bug hunting, and penetration testing.
