# pinia-starter-ts


[![Deploy](https://github.com/pdsuwwz/pinia-starter-ts/workflows/gh-pages/badge.svg)](https://github.com/pdsuwwz/pinia-starter-ts/actions/workflows/deploy.yml)
[![GitHub Workflow Status (branch)](https://img.shields.io/github/actions/workflow/status/pdsuwwz/pinia-starter-ts/deploy.yml?branch=main)](https://github.com/pdsuwwz/pinia-starter-ts/deployments/activity_log?environment=github-pages)
[![jest](https://jestjs.io/img/jest-badge.svg)](https://github.com/facebook/jest)
[![thanks](https://badgen.net/badge/thanks/♥/pink)](https://github.com/pdsuwwz)
[![License](https://img.shields.io/github/license/pdsuwwz/pinia-starter-ts?color=blue)](https://github.com/pdsuwwz/pinia-starter-ts/blob/main/LICENSE)


🪁  A Vue 3.x Starter template built on Vite 5.x + TypeScript + Pinia@next 🍍


[🚀 Live Demo 在线体验](https://pdsuwwz.github.io/pinia-starter-ts)


## 🌱 不同版本
目前一共有以下五个不同技术栈的仓库模板在持续维护，请尝试后选择适合自己的模板使用

- 💥 (推荐) [TS + Pinia + 🌐 低耦合(i18n)多语言 Vite5 + Vue3 + TS + Unocss + Unplugin + Element-Plus2 + vue-i18n@next](https://github.com/pdsuwwz/vue-boilerplate-i18n)

- ⚡️ TS + Pinia 版 (当前仓库)[Vite5 + Vue3 + TS + Pinia + Element-Plus2 + useLocale + i18n](https://github.com/pdsuwwz/pinia-starter-ts)
- ⚡️ JS + Pinia 版 [Vite5 + Vue3 + Pinia + Element-Plus2 + useLocale + i18n](https://github.com/pdsuwwz/vite-pinia-starter)

- ⚡️ TS + Vuex4 版 [Vite5 + Vue3 + TS + Vuex4 + Element-Plus2 + Unocss + Unplugin + useLocale + i18n](https://github.com/pdsuwwz/vite-ts-starter)
- ⚡️ JS + Vuex4 版 [Vite5 + Vue3 + Vuex4 + Element-Plus2 + useLocale + i18n](https://github.com/pdsuwwz/vite-starter)


## Environment Support

* Vue 3.x
* Node >= 16.15.x
* Pnpm >= 8.14.x
* **VS Code 插件 `dbaeumer.vscode-eslint` >= v3.0.5 (pre-release)**


## 🪄 使用不同的 UI 库

如果更偏好使用 [Naive UI](https://www.naiveui.com/) 作为 UI 库, 这里也为你准备了几个相应的模板项目，可在此基础上进行业务二次开发和定制：

- 🏄‍♂️ [Naive UI 基础模板，集成常用技术栈](https://github.com/pdsuwwz/vite-naive-template)
- 🗂️ [基于 Naive UI 的 Tab 多页签切换选项卡演示](https://github.com/pdsuwwz/vue3-tab-demo)


## 安装

运行 `pnpm i` 来安装依赖项

```bash
pnpm i
```

## 本地运行

运行 `pnpm dev` 来启动前端开发服务器

```bash
pnpm dev
```

## 单元测试


```bash
pnpm test
```

单元测试，覆盖率测试

```bash
pnpm test:coverage
```

## 😎 Awesome

* [awesome-vite](https://github.com/pdsuwwz/awesome-vite)

## License

[MIT](./LICENSE) License | Copyright © 2020-PRESENT [Wisdom](https://github.com/pdsuwwz)

