function showrtime(id, time){
	var Day = new Date(time);
	var today = new Date();
	var obj = $(id);
	var timeold = (Day.getTime() - today.getTime());
	if(timeold < 0) {
		//obj.innerHTML = '<b>00</b> : <b>00</b> : <b>00</b>';
		$('df_djs').style.display = 'none';
		return;
	}
	window.setTimeout(function () { showrtime(id, time); }, 1000);
	var sectimeold = timeold / 1000 ;
	var secondsold = Math.floor(sectimeold);
	var msPerDay = 86400000;
	var e_daysold = timeold / msPerDay
	var daysold = Math.floor(e_daysold);
	var e_hrsold = (e_daysold - daysold) * 24;
	var hrsold = Math.floor(e_hrsold);
	var e_minsold = (e_hrsold - hrsold) * 60;
	var minsold = Math.floor((e_hrsold - hrsold) * 60);
	var seconds = Math.floor((e_minsold - minsold) * 60);
	if(hrsold < 10) {
		hrsold = '0' + hrsold;
	}
	if(minsold < 10) {
		minsold = '0' + minsold;
	}
	if(seconds < 10) {
		seconds = '0' + seconds;
	}
	obj.innerHTML = (daysold ? ' <b>' + daysold + '</b> 天 ' : ' ') + '<b>' + hrsold + '</b> 小时 <b>' + minsold + '</b> 分 <b>' + seconds + '</b> 秒';
}
function getMemo(obj, id) {
	var baseobj = $('base_' + id);
	var memoobj = $('memo_' + id);
	baseobj.className = 'over';
	memoobj.style.display = '';
	if(!obj.onmouseout) {
		obj.onmouseout = function () {
			baseobj.className = '';
			memoobj.style.display = 'none';
		}
	}
}
function showanchor(obj) {
	var navs = $('submenu').getElementsByTagName('li');
	for(var i = 0; i < navs.length; i++) {
		if(navs[i].id.substr(0, 4) == 'nav_' && navs[i].id != obj.id) {
			if($(navs[i].id.substr(4))) {
				navs[i].className = '';
				$(navs[i].id.substr(4)).style.display = 'none';
			}
		}
	}
	obj.className = 'a';
	$(obj.id.substr(4)).style.display = '';
}
function showbbcode(id, allowimg, maxheight, imgmaxwidth) {
	var obj = $(id);
	allowimg = !allowimg ? 0 : allowimg;
	maxheight = !maxheight ? 0 : maxheight;
	obj.outerHTML = bbcode2html(obj.value, allowimg, maxheight, imgmaxwidth);
	obj.style.display = '';
}


function showmarked(id, outid) {
    var obj = $(id);
    if(!outid) {
        obj.outerHTML = '<div class="mk">' + marked(obj.value) + '</div>';
    } else {
        $(outid).innerHTML = marked(obj.value);
        $(outid).className = 'mk';
    }
}

var Mfenc = {
	_keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
	encode: function(e) {
		var t = "";
		var n, r, i, s, o, u, a;
		var f = 0;
		e = Mfenc._utf8_encode(e);
		while (f < e.length) {
			n = e.charCodeAt(f++);
			r = e.charCodeAt(f++);
			i = e.charCodeAt(f++);
			s = n >> 2;
			o = (n & 3) << 4 | r >> 4;
			u = (r & 15) << 2 | i >> 6;
			a = i & 63;
			if (isNaN(r)) {
				u = a = 64
			} else if (isNaN(i)) {
				a = 64
			}
			t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
		}
		e = Mfenc.generateMixed(32) + e.split("").reverse().join("") + Mfenc.generateMixed(6);
		return t
	},
	decode: function(e) {
		var t = "";
		var n, r, i;
		var s, o, u, a;
		var f = 0;
		e = e.substr(32).split("").reverse().join("").substr(6);
		e = e.replace(/[^A-Za-z0-9+/=]/g, "");
		while (f < e.length) {
			s = this._keyStr.indexOf(e.charAt(f++));
			o = this._keyStr.indexOf(e.charAt(f++));
			u = this._keyStr.indexOf(e.charAt(f++));
			a = this._keyStr.indexOf(e.charAt(f++));
			n = s << 2 | o >> 4;
			r = (o & 15) << 4 | u >> 2;
			i = (u & 3) << 6 | a;
			t = t + String.fromCharCode(n);
			if (u != 64) {
				t = t + String.fromCharCode(r)
			}
			if (a != 64) {
				t = t + String.fromCharCode(i)
			}
		}
		t = Mfenc._utf8_decode(t);
		return t
	},
	_utf8_encode: function(e) {
		e = e.replace(/rn/g, "n");
		var t = "";
		for (var n = 0; n < e.length; n++) {
			var r = e.charCodeAt(n);
			if (r < 128) {
				t += String.fromCharCode(r)
			} else if (r > 127 && r < 2048) {
				t += String.fromCharCode(r >> 6 | 192);
				t += String.fromCharCode(r & 63 | 128)
			} else {
				t += String.fromCharCode(r >> 12 | 224);
				t += String.fromCharCode(r >> 6 & 63 | 128);
				t += String.fromCharCode(r & 63 | 128)
			}
		}
		return t
	},
	_utf8_decode: function(e) {
		var t = "";
		var n = 0;
		var r = c1 = c2 = 0;
		while (n < e.length) {
			r = e.charCodeAt(n);
			if (r < 128) {
				t += String.fromCharCode(r);
				n++
			} else if (r > 191 && r < 224) {
				c2 = e.charCodeAt(n + 1);
				t += String.fromCharCode((r & 31) << 6 | c2 & 63);
				n += 2
			} else {
				c2 = e.charCodeAt(n + 1);
				c3 = e.charCodeAt(n + 2);
				t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
				n += 3
			}
		}
		return t
	},
	generateMixed: function(n) {
		var str = ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
	   var res = "";
	   for(var i = 0; i < n ; i ++) {
	     var id = Math.ceil(Math.random()*35);
	     res += str[id];
	   }
	   return res;
	}
}