/* eslint-disable @typescript-eslint/no-unused-vars */

/**
 * This is a list of all possible imports from Payload 2.x
 *
 * All of these should either resolve here
 *
 * OR
 *
 * Be documented in the migration guide and breaking changes doc
 */

import payload from 'payload'
import {
  CollectionPermission,
  FieldPermissions,
  GlobalPermission,
  IncomingAuthType,
  Permission,
  Permissions,
  User,
  VerifyConfig,
} from 'payload/auth'
import {
  Banner,
  Button,
  Check,
  Chevron,
  ErrorPill,
  Menu,
  MinimalTemplate,
  Pill,
  Popup,
  Search,
  ShimmerEffect,
  Tooltip,
  X,
} from 'payload/components'
import {
  Access,
  AccessArgs,
  AccessResult,
  AdminView,
  AdminViewComponent,
  AdminViewConfig,
  AdminViewProps,
  baseBlockFields,
  baseIDField,
  BaseLocalizationConfig,
  buildConfig,
  Config,
  defaults,
  EditView,
  EditViewConfig,
  EmailOptions,
  EmailTransport,
  EmailTransportOptions,
  Endpoint,
  EntityDescription,
  FieldTypes,
  GeneratePreviewURL,
  GraphQLExtension,
  hasTransport,
  hasTransportOptions,
  InitOptions,
  LivePreviewConfig,
  Locale,
  LocalizationConfig,
  LocalizationConfigWithLabels,
  LocalizationConfigWithNoLabels,
  PayloadHandler,
  Plugin,
  sanitizeConfig,
  SanitizedConfig,
  SanitizedLocalizationConfig,
  sanitizeFields,
} from 'payload/config'
import {
  BaseDatabaseAdapter,
  BeginTransaction,
  combineQueries,
  CommitTransaction,
  Connect,
  Count,
  CountArgs,
  Create,
  CreateArgs,
  createDatabaseAdapter,
  CreateGlobal,
  CreateGlobalArgs,
  CreateGlobalVersion,
  CreateGlobalVersionArgs,
  CreateMigration,
  createMigration,
  CreateVersion,
  CreateVersionArgs,
  DBIdentifierName,
  DeleteMany,
  DeleteManyArgs,
  DeleteOne,
  DeleteOneArgs,
  DeleteVersions,
  DeleteVersionsArgs,
  Destroy,
  EntityPolicies,
  Find,
  FindArgs,
  FindGlobal,
  FindGlobalArgs,
  FindGlobalVersions,
  FindGlobalVersionsArgs,
  FindOne,
  FindOneArgs,
  FindVersions,
  FindVersionsArgs,
  flattenWhereToOperators,
  getLocalizedPaths,
  getMigrations,
  Init,
  migrate,
  migrateDown,
  migrateRefresh,
  migrateReset,
  migrateStatus,
  Migration,
  MigrationData,
  migrationsCollection,
  migrationTemplate,
  PaginatedDocs,
  PathToQuery,
  QueryDrafts,
  QueryDraftsArgs,
  readMigrationFiles,
  RollbackTransaction,
  Transaction,
  TypeWithVersion,
  UpdateGlobal,
  UpdateGlobalArgs,
  UpdateGlobalVersion,
  UpdateGlobalVersionArgs,
  UpdateOne,
  UpdateOneArgs,
  UpdateVersion,
  UpdateVersionArgs,
  validateQueryPaths,
  validateSearchParam,
} from 'payload/database'
import {
  APIError,
  AuthenticationError,
  DuplicateCollection,
  DuplicateGlobal,
  ErrorDeletingFile,
  FileUploadError,
  Forbidden,
  InvalidConfiguration,
  InvalidFieldName,
  InvalidFieldRelationship,
  LockedAuth,
  MissingCollectionLabel,
  MissingFieldInputOptions,
  MissingFieldType,
  MissingFile,
  NotFound,
  QueryError,
  ValidationError,
} from 'payload/errors'
import { buildPaginatedListType, GraphQL } from 'payload/graphql'
import {
  AccessArgs as AccessArgsType,
  Access as AccessType,
  AllOperations,
  ArrayField,
  AuthOperations,
  BeforeDuplicate,
  Block,
  BlockField,
  CellComponentProps,
  CheckboxField,
  CodeField,
  CollapsibleField,
  Collection,
  CollectionAfterChangeHook,
  CollectionAfterDeleteHook,
  CollectionAfterForgotPasswordHook,
  CollectionAfterLoginHook,
  CollectionAfterOperationHook,
  CollectionAfterReadHook,
  CollectionBeforeChangeHook,
  CollectionBeforeDeleteHook,
  CollectionBeforeLoginHook,
  CollectionBeforeOperationHook,
  CollectionBeforeReadHook,
  CollectionBeforeValidateHook,
  CollectionConfig,
  Condition,
  CreateFormData,
  CustomPublishButtonProps,
  CustomPublishButtonType,
  CustomSaveButtonProps,
  CustomSaveDraftButtonProps,
  Data,
  DateField,
  docHasTimestamps,
  Document,
  EmailField,
  Field,
  FieldAccess,
  FieldAffectingData,
  fieldAffectsData,
  FieldBase,
  fieldHasMaxDepth,
  fieldHasSubFields,
  FieldHook,
  FieldHookArgs,
  fieldIsArrayType,
  fieldIsBlockType,
  fieldIsGroupType,
  fieldIsLocalized,
  fieldIsPresentationalOnly,
  FieldPresentationalOnly,
  Fields,
  fieldSupportsMany,
  FieldWithMany,
  FieldWithMaxDepth,
  FieldWithPath,
  FieldWithRichTextRequiredEditor,
  FieldWithSubFields,
  FileData,
  FilterOptions,
  FilterOptionsProps,
  FormField,
  FormFieldsContext,
  GlobalAfterChangeHook,
  GlobalAfterReadHook,
  GlobalBeforeChangeHook,
  GlobalBeforeReadHook,
  GlobalBeforeValidateHook,
  GlobalConfig,
  GroupField,
  HookName,
  ImageSize,
  IncomingUploadType,
  JSONField,
  Labels,
  NamedTab,
  NonPresentationalField,
  NumberField,
  Operation,
  Operator,
  Option,
  optionIsObject,
  optionIsValue,
  OptionObject,
  optionsAreObjects,
  PayloadRequest,
  PointField,
  PolymorphicRelationshipField,
  RadioField,
  RelationshipField,
  RelationshipValue,
  RichTextAdapter,
  RichTextFieldProps,
  RichTextFieldRequiredEditor,
  RichTextField as RichTextFieldType,
  RowAdmin,
  RowField,
  RowLabel,
  SanitizedCollectionConfig,
  SanitizedGlobalConfig,
  SelectField,
  SingleRelationshipField,
  Tab,
  TabAsField,
  tabHasName,
  TabsAdmin,
  TabsField,
  TextareaField,
  TextField,
  TypeWithID,
  UIField,
  UnnamedTab,
  UploadField,
  Validate,
  ValidateOptions,
  validOperators,
  valueIsValueWithRelation,
  ValueWithRelation,
  VersionOperations,
  Where,
  WhereField,
} from 'payload/types'
import {
  afterReadPromise,
  afterReadTraverseFields,
  combineMerge,
  configToJSONSchema,
  createArrayFromCommaDelineated,
  deepCopyObject,
  deepMerge,
  entityToJSONSchema,
  extractTranslations,
  fieldSchemaToJSON,
  fieldsToJSONSchema,
  flattenTopLevelFields,
  formatLabels,
  formatNames,
  getCollectionIDFieldTypes,
  getIDType,
  getTranslation,
  i18nInit,
  isValidID,
  toWords,
  withMergedProps,
  withNullableJSONSchemaType,
} from 'payload/utilities'
import {
  buildVersionCollectionFields,
  buildVersionGlobalFields,
  deleteCollectionVersions,
  enforceMaxVersions,
  getLatestCollectionVersion,
  getLatestGlobalVersion,
  saveVersion,
} from 'payload/versions'

/**
 * Plugins
 */

import {
  Args,
  MigrateDownArgs,
  MigrateUpArgs,
  MongooseAdapter,
  mongooseAdapter,
} from '@payloadcms/db-mongodb'
import {
  MigrateDownArgs as MigrateDownArgsPg,
  MigrateUpArgs as MigrateUpArgsPg,
  postgresAdapter,
} from '@payloadcms/db-postgres'
import { handleMessage, mergeData, ready, subscribe, unsubscribe } from '@payloadcms/live-preview'
import { useLivePreview } from '@payloadcms/live-preview-react'
import { createKey, getStorageClient, payloadCloud } from '@payloadcms/payload-cloud'
import { cloudStorage } from '@payloadcms/plugin-cloud-storage'
import { fields, getPaymentTotal } from '@payloadcms/plugin-form-builder'
import {
  BeforeEmail,
  BlockConfig,
  CountryField,
  Email,
  FieldConfig,
  FieldsConfig,
  FieldValues,
  Form,
  FormattedEmail,
  CheckboxField as FormBuilderCheckboxField,
  EmailField as FormBuilderEmailField,
  SelectField as FormBuilderSelectField,
  TextField as FormBuilderTextField,
  FormFieldBlock,
  FormSubmission,
  HandlePayment,
  isValidBlockConfig,
  MessageField,
  PaymentField,
  PaymentFieldConfig,
  PluginConfig,
  PriceCondition,
  Redirect,
  SelectFieldOption,
  StateField,
  SubmissionValue,
  TextAreaField,
} from '@payloadcms/plugin-form-builder/types'
import nestedDocs from '@payloadcms/plugin-nested-docs'
import { createBreadcrumbsField, createParentField } from '@payloadcms/plugin-nested-docs/fields'
import {
  Breadcrumb,
  GenerateLabel,
  GenerateURL,
  PluginConfig as NestedDocsPluginConfig,
} from '@payloadcms/plugin-nested-docs/types'
import redirects from '@payloadcms/plugin-redirects'
import { PluginConfig as RedirectsPluginConfig } from '@payloadcms/plugin-redirects/types'

// Skip plugin-sentry

import search from '@payloadcms/plugin-search'
import {
  BeforeSync,
  DocToSync,
  SearchConfig,
  SyncWithSearch,
} from '@payloadcms/plugin-search/types'
import seo from '@payloadcms/plugin-seo'
import {
  GenerateDescription,
  GenerateImage,
  GenerateTitle,
  Meta,
  GenerateURL as seoGenerateURL,
  PluginConfig as SeoPluginConfig,
} from '@payloadcms/plugin-seo/types'
import stripePlugin from '@payloadcms/plugin-stripe'
import {
  FieldSyncConfig,
  SanitizedStripeConfig,
  StripeConfig,
  StripeProxy,
  StripeWebhookHandler,
  StripeWebhookHandlers,
  SyncConfig,
} from '@payloadcms/plugin-stripe/types'
import {
  $createAutoLinkNode,
  $createBlockNode,
  $createLinkNode,
  $createRelationshipNode,
  $createUploadNode,
  $isAutoLinkNode,
  $isBlockNode,
  $isLinkNode,
  $isRelationshipNode,
  $isUploadNode,
  AdapterProps,
  addSwipeDownListener,
  addSwipeLeftListener,
  addSwipeRightListener,
  addSwipeUpListener,
  AlignFeature,
  AutoLinkNode,
  BlockFields,
  BlockNode,
  BlockQuoteFeature,
  BlocksFeature,
  BlocksFeatureProps,
  BoldTextFeature,
  CAN_USE_DOM,
  CheckListFeature,
  cloneDeep,
  consolidateHTMLConverters,
  convertLexicalNodesToHTML,
  convertLexicalToHTML,
  convertSlateNodesToLexical,
  convertSlateToLexical,
  createBlockNode,
  defaultEditorConfig,
  defaultEditorFeatures,
  defaultHTMLConverters,
  defaultRichTextValue,
  defaultSanitizedEditorConfig,
  defaultSlateConverters,
  DETAIL_TYPE_TO_DETAIL,
  DOUBLE_LINE_BREAK,
  EditorConfig,
  EditorConfigProvider,
  ELEMENT_FORMAT_TO_TYPE,
  ELEMENT_TYPE_TO_FORMAT,
  ENABLE_SLASH_MENU_COMMAND,
  Feature,
  FeatureProvider,
  FeatureProviderMap,
  FloatingToolbarSection,
  FloatingToolbarSectionEntry,
  FormatSectionWithEntries,
  getDOMRangeRect,
  getEnabledNodes,
  getSelectedNode,
  HeadingFeature,
  HTMLConverter,
  HTMLConverterFeature,
  HTMLConverterFeatureProps,
  IndentFeature,
  InlineCodeTextFeature,
  invariant,
  IS_ALL_FORMATTING,
  isHTMLElement,
  isPoint,
  ItalicTextFeature,
  joinClasses,
  LexicalBlock,
  lexicalEditor,
  LexicalEditorProps,
  lexicalHTML,
  LexicalPluginToLexicalFeature,
  LexicalRichTextAdapter,
  LinebreakHTMLConverter,
  LinkFeature,
  LinkFeatureProps,
  LinkFields,
  LinkNode,
  loadFeatures,
  LTR_REGEX,
  NodeFormat,
  NodeValidation,
  NON_BREAKING_SPACE,
  OrderedListFeature,
  ParagraphFeature,
  ParagraphHTMLConverter,
  Point,
  PopulationPromise,
  RawUploadPayload,
  Rect,
  RelationshipData,
  RelationshipFeature,
  RelationshipNode,
  ResolvedFeature,
  ResolvedFeatureMap,
  RTL_REGEX,
  SanitizedEditorConfig,
  SanitizedFeatures,
  sanitizeEditorConfig,
  sanitizeFeatures,
  sanitizeUrl,
  SerializedAutoLinkNode,
  SerializedBlockNode,
  SerializedLinkNode,
  SerializedRelationshipNode,
  SerializedUploadNode,
  setFloatingElemPosition,
  setFloatingElemPositionForLinkEditor,
  SlashMenuGroup,
  SlashMenuOption,
  SlateBlockquoteConverter,
  SlateHeadingConverter,
  SlateIndentConverter,
  SlateLinkConverter,
  SlateListItemConverter,
  SlateNode,
  SlateNodeConverter,
  SlateOrderedListConverter,
  SlateRelationshipConverter,
  SlateToLexicalFeature,
  SlateUnknownConverter,
  SlateUnorderedListConverter,
  SlateUploadConverter,
  sortFeaturesForOptimalLoading,
  StrikethroughTextFeature,
  SubscriptTextFeature,
  SuperscriptTextFeature,
  TestRecorderFeature,
  TEXT_MODE_TO_TYPE,
  TEXT_TYPE_TO_FORMAT,
  TEXT_TYPE_TO_MODE,
  TextDropdownSectionWithEntries,
  TextHTMLConverter,
  TOGGLE_LINK_COMMAND,
  TreeViewFeature,
  UnderlineTextFeature,
  UnorderedListFeature,
  UploadData,
  UploadFeature,
  UploadFeatureProps,
  UploadNode,
  useEditorConfigContext,
  validateUrl,
} from '@payloadcms/richtext-lexical'
import {
  defaultEditorLexicalConfig,
  RichTextCell,
  RichTextField,
  ToolbarButton,
  ToolbarDropdown,
} from '@payloadcms/richtext-lexical/components'
import {
  AdapterArguments,
  ElementButton,
  ElementNode,
  FieldProps,
  LeafButton,
  nodeIsTextNode,
  RichTextCustomElement,
  RichTextCustomLeaf,
  RichTextElement,
  RichTextLeaf,
  slateEditor,
  TextNode,
  toggleElement,
} from '@payloadcms/richtext-slate'
