import React from 'react'

import './index.scss'

export const MoreIcon: React.FC<{ className?: string }> = ({ className }) => (
  <svg
    className={['icon icon--more', className].filter(Boolean).join(' ')}
    viewBox="0 0 20 20"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      className="fill"
      d="M10 10.6666C10.3682 10.6666 10.6667 10.3682 10.6667 9.99998C10.6667 9.63179 10.3682 9.33331 10 9.33331C9.63182 9.33331 9.33334 9.63179 9.33334 9.99998C9.33334 10.3682 9.63182 10.6666 10 10.6666Z"
      strokeLinecap="square"
    />
    <path
      className="fill"
      d="M14.6667 10.6666C15.0349 10.6666 15.3333 10.3682 15.3333 9.99998C15.3333 9.63179 15.0349 9.33331 14.6667 9.33331C14.2985 9.33331 14 9.63179 14 9.99998C14 10.3682 14.2985 10.6666 14.6667 10.6666Z"
      strokeLinecap="square"
    />
    <path
      className="fill"
      d="M5.33334 10.6666C5.70153 10.6666 6.00001 10.3682 6.00001 9.99998C6.00001 9.63179 5.70153 9.33331 5.33334 9.33331C4.96515 9.33331 4.66667 9.63179 4.66667 9.99998C4.66667 10.3682 4.96515 10.6666 5.33334 10.6666Z"
      strokeLinecap="square"
    />
  </svg>
)
