import type { DefaultTranslationsObject, Language } from '../types.js'

export const csTranslations: DefaultTranslationsObject = {
  authentication: {
    account: 'Účet',
    accountOfCurrentUser: 'Účet současného uživatele',
    accountVerified: 'Účet byl úspěšně ověřen.',
    alreadyActivated: 'Již aktivováno',
    alreadyLoggedIn: 'Již přihlášen',
    apiKey: 'API klíč',
    authenticated: 'Ověřený',
    backToLogin: 'Zpět na přihlášení',
    beginCreateFirstUser: 'Začněte vytvořením svého prvního uživatele.',
    changePassword: 'Změnit heslo',
    checkYourEmailForPasswordReset:
      'Pokud je e-mailová adresa spojena s účtem, brzy obdržíte pokyny k resetování vašeho hesla. Pokud e-mail nenajdete ve vaší doručené poště, zkontrolujte prosím složku se spamem nebo nevyžádanou poštou.',
    confirmGeneration: 'Potvrdit generaci',
    confirmPassword: 'Potvrdit heslo',
    createFirstUser: 'Vytvořit prvního uživatele',
    emailNotValid: 'Zadaný email není platný',
    emailOrUsername: 'E-mail nebo Uživatelské jméno',
    emailSent: 'Email odeslán',
    emailVerified: 'E-mail úspěšně ověřen.',
    enableAPIKey: 'Povolit API klíč',
    failedToUnlock: 'Nepodařilo se odemknout',
    forceUnlock: 'Vynutit odemčení',
    forgotPassword: 'Zapomněli jste heslo?',
    forgotPasswordEmailInstructions:
      'Zadejte svůj email níže. Obdržíte email s instrukcemi, jak resetovat vaše heslo.',
    forgotPasswordQuestion: 'Zapomněli jste heslo?',
    forgotPasswordUsernameInstructions:
      'Zadejte níže své uživatelské jméno. Instrukce, jak obnovit vaše heslo, budou odeslány na e-mailovou adresu spojenou s vaším uživatelským jménem.',
    generate: 'Generovat',
    generateNewAPIKey: 'Generovat nový API klíč',
    generatingNewAPIKeyWillInvalidate:
      'Vytvoření nového API klíče <1>zneplatní</1> předchozí klíč. Opravdu chcete pokračovat?',
    lockUntil: 'Uzamknout do',
    logBackIn: 'Znovu se přihlásit',
    loggedIn: 'Abyste se mohli přihlásit s jiným uživatelem, nejdříve se <0>odhlaste</0>.',
    loggedInChangePassword: 'Pro změnu hesla přejděte do svého <0>účtu</0> a zde si heslo upravte.',
    loggedOutInactivity: 'Byli jste odhlášeni z důvodu neaktivity.',
    loggedOutSuccessfully: 'Byli jste úspěšně odhlášeni.',
    loggingOut: 'Odhlášení...',
    login: 'Přihlásit se',
    loginAttempts: 'Pokusy o přihlášení',
    loginUser: 'Přihlásit uživatele',
    loginWithAnotherUser:
      'Abyste se mohli přihlásit s jiným uživatelem, nejdříve se <0>odhlaste</0>.',
    logOut: 'Odhlásit se',
    logout: 'Odhlásit se',
    logoutSuccessful: 'Odhlášení úspěšné.',
    logoutUser: 'Odhlásit uživatele',
    newAccountCreated:
      'Pro přístup k <a href="{{serverURL}}">{{serverURL}}</a> byl pro vás vytvořen nový účet. Klepněte na následující odkaz nebo zkopírujte URL do svého prohlížeče pro ověření vašeho emailu: <a href="{{verificationURL}}">{{verificationURL}}</a><br> Po ověření vašeho emailu se budete moci úspěšně přihlásit.',
    newAPIKeyGenerated: 'Byl vygenerován nový API klíč.',
    newPassword: 'Nové heslo',
    passed: 'Ověření prošlo',
    passwordResetSuccessfully: 'Heslo bylo úspěšně resetováno.',
    resetPassword: 'Resetovat heslo',
    resetPasswordExpiration: 'Expirace resetování hesla',
    resetPasswordToken: 'Token pro resetování hesla',
    resetYourPassword: 'Resetujte své heslo',
    stayLoggedIn: 'Zůstat přihlášen',
    successfullyRegisteredFirstUser: 'Úspěšně zaregistrován první uživatel.',
    successfullyUnlocked: 'Úspěšně odemčeno',
    tokenRefreshSuccessful: 'Obnovení tokenu úspěšné.',
    unableToVerify: 'Nepodařilo se ověřit',
    username: 'Uživatelské jméno',
    usernameNotValid: 'Poskytnuté uživatelské jméno není platné.',
    verified: 'Ověřeno',
    verifiedSuccessfully: 'Úspěšně ověřeno',
    verify: 'Ověřit',
    verifyUser: 'Ověřit uživatele',
    verifyYourEmail: 'Ověřte svůj email',
    youAreInactive:
      'Nějakou dobu jste nebyli aktivní a brzy budete automaticky odhlášeni z bezpečnostních důvodů. Chcete zůstat přihlášen?',
    youAreReceivingResetPassword:
      'Tento email obdržíte, protože jste (nebo někdo jiný) požádali o resetování hesla pro váš účet.',
    youDidNotRequestPassword:
      'Pokud jste o to nepožádali, ignorujte prosím tento e-mail a vaše heslo zůstane nezměněno.',
  },
  error: {
    accountAlreadyActivated: 'Tento účet již byl aktivován.',
    autosaving: 'Při automatickém ukládání tohoto dokumentu došlo k chybě.',
    correctInvalidFields: 'Opravte neplatná pole.',
    deletingFile: 'Při mazání souboru došlo k chybě.',
    deletingTitle:
      'Při mazání {{title}} došlo k chybě. Zkontrolujte své připojení a zkuste to znovu.',
    emailOrPasswordIncorrect: 'Zadaný email nebo heslo není správné.',
    followingFieldsInvalid_one: 'Následující pole je neplatné:',
    followingFieldsInvalid_other: 'Následující pole jsou neplatná:',
    incorrectCollection: 'Nesprávná kolekce',
    invalidFileType: 'Neplatný typ souboru',
    invalidFileTypeValue: 'Neplatný typ souboru: {{value}}',
    invalidRequestArgs: 'Neplatné argumenty v požadavku: {{args}}',
    loadingDocument: 'Při načítání dokumentu s ID {{id}} došlo k chybě.',
    localesNotSaved_one: 'Následující lokalitu se nepodařilo uložit:',
    localesNotSaved_other: 'Následující lokality se nepodařilo uložit:',
    logoutFailed: 'Odhlášení se nezdařilo.',
    missingEmail: 'Chybějící email.',
    missingIDOfDocument: 'Chybějící ID dokumentu pro aktualizaci.',
    missingIDOfVersion: 'Chybějící ID verze.',
    missingRequiredData: 'Chybějící povinná data.',
    noFilesUploaded: 'Nebyly nahrány žádné soubory.',
    noMatchedField: 'Pro "{{label}}" nebylo nalezeno žádné odpovídající pole',
    notAllowedToAccessPage: 'Nemáte povolení přistupovat k této stránce.',
    notAllowedToPerformAction: 'Nemáte povolení provádět tuto akci.',
    notFound: 'Požadovaný zdroj nebyl nalezen.',
    noUser: 'Žádný uživatel',
    previewing: 'Při náhledu tohoto dokumentu došlo k chybě.',
    problemUploadingFile: 'Při nahrávání souboru došlo k chybě.',
    tokenInvalidOrExpired: 'Token je neplatný nebo vypršel.',
    tokenNotProvided: 'Token není poskytnut.',
    unableToDeleteCount: 'Nelze smazat {{count}} z {{total}} {{label}}',
    unableToReindexCollection:
      'Chyba při přeindexování kolekce {{collection}}. Operace byla přerušena.',
    unableToUpdateCount: 'Nelze aktualizovat {{count}} z {{total}} {{label}}.',
    unauthorized: 'Neautorizováno, pro zadání tohoto požadavku musíte být přihlášeni.',
    unauthorizedAdmin: 'Neautorizováno, tento uživatel nemá přístup k administraci.',
    unknown: 'Došlo k neznámé chybě.',
    unPublishingDocument: 'Při zrušení publikování tohoto dokumentu došlo k chybě.',
    unspecific: 'Došlo k chybě.',
    userEmailAlreadyRegistered: 'Uživatel s daným e-mailem je již zaregistrován.',
    userLocked: 'Tento uživatel je uzamčen kvůli příliš mnoha neúspěšným pokusům o přihlášení.',
    usernameAlreadyRegistered: 'Uživatel se zadaným uživatelským jménem je již zaregistrován.',
    usernameOrPasswordIncorrect: 'Zadané uživatelské jméno nebo heslo je nesprávné.',
    valueMustBeUnique: 'Hodnota musí být jedinečná',
    verificationTokenInvalid: 'Ověřovací token je neplatný.',
  },
  fields: {
    addLabel: 'Přidat {{label}}',
    addLink: 'Přidat odkaz',
    addNew: 'Přidat nový',
    addNewLabel: 'Přidat nový {{label}}',
    addRelationship: 'Přidat vztah',
    addUpload: 'Přidat nahrávání',
    block: 'blok',
    blocks: 'bloky',
    blockType: 'Typ bloku',
    chooseBetweenCustomTextOrDocument:
      'Zvolte mezi vložením vlastního textového URL nebo odkazováním na jiný dokument.',
    chooseDocumentToLink: 'Vyberte dokument, na který se chcete odkázat',
    chooseFromExisting: 'Vybrat z existujících',
    chooseLabel: 'Vybrat {{label}}',
    collapseAll: 'Sbalit vše',
    customURL: 'Vlastní URL',
    editLabelData: 'Upravit data {{label}}',
    editLink: 'Upravit odkaz',
    editRelationship: 'Upravit vztah',
    enterURL: 'Zadejte URL',
    internalLink: 'Interní odkaz',
    itemsAndMore: '{{items}} a {{count}} dalších',
    labelRelationship: 'Vztah {{label}}',
    latitude: 'Zeměpisná šířka',
    linkedTo: 'Odkaz na <0>{{label}}</0>',
    linkType: 'Typ odkazu',
    longitude: 'Zeměpisná délka',
    newLabel: 'Nový {{label}}',
    openInNewTab: 'Otevřít v nové záložce',
    passwordsDoNotMatch: 'Hesla se neshodují.',
    relatedDocument: 'Související dokument',
    relationTo: 'Vztah k',
    removeRelationship: 'Odstranit vztah',
    removeUpload: 'Odstranit nahrání',
    saveChanges: 'Uložit změny',
    searchForBlock: 'Hledat blok',
    selectExistingLabel: 'Vybrat existující {{label}}',
    selectFieldsToEdit: 'Vyberte pole, která chcete upravit',
    showAll: 'Zobrazit vše',
    swapRelationship: 'Zaměnit vztah',
    swapUpload: 'Vyměnit nahrání',
    textToDisplay: 'Text k zobrazení',
    toggleBlock: 'Přepnout blok',
    uploadNewLabel: 'Nahrát nový {{label}}',
  },
  general: {
    aboutToDelete: 'Chystáte se odstranit {{label}} <1>{{title}}</1>. Jste si jisti?',
    aboutToDeleteCount_many: 'Chystáte se smazat {{count}} {{label}}',
    aboutToDeleteCount_one: 'Chystáte se smazat {{count}} {{label}}',
    aboutToDeleteCount_other: 'Chystáte se smazat {{count}} {{label}}',
    addBelow: 'Přidat pod',
    addFilter: 'Přidat filtr',
    adminTheme: 'Motiv administračního rozhraní',
    all: 'Všechny',
    allCollections: 'Všechny kolekce',
    and: 'a',
    anotherUser: 'Jiný uživatel',
    anotherUserTakenOver: 'Jiný uživatel převzal úpravy tohoto dokumentu.',
    applyChanges: 'Použít změny',
    ascending: 'Vzestupně',
    automatic: 'Automatický',
    backToDashboard: 'Zpět na nástěnku',
    cancel: 'Zrušit',
    changesNotSaved: 'Vaše změny nebyly uloženy. Pokud teď odejdete, ztratíte své změny.',
    clearAll: 'Vymazat vše',
    close: 'Zavřít',
    collapse: 'Sbalit',
    collections: 'Kolekce',
    columns: 'Sloupce',
    columnToSort: 'Sloupec k seřazení',
    confirm: 'Potvrdit',
    confirmCopy: 'Potvrzení kopie',
    confirmDeletion: 'Potvrdit odstranění',
    confirmDuplication: 'Potvrdit duplikaci',
    confirmReindex: 'Přeindexovat všechny {{collections}}?',
    confirmReindexAll: 'Přeindexovat všechny kolekce?',
    confirmReindexDescription:
      'Tímto budou odstraněny stávající indexy a dokumenty v kolekcích {{collections}} budou znovu zaindexovány.',
    confirmReindexDescriptionAll:
      'Tímto budou odstraněny stávající indexy a dokumenty ve všech kolekcích budou znovu zaindexovány.',
    copied: 'Zkopírováno',
    copy: 'Kopírovat',
    copying: 'Kopírování',
    copyWarning: 'Chystáte se přepsat {{to}} s {{from}} pro {{label}} {{title}}. Jste si jistý?',
    create: 'Vytvořit',
    created: 'Vytvořeno',
    createdAt: 'Vytvořeno v',
    createNew: 'Vytvořit nové',
    createNewLabel: 'Vytvořit nový {{label}}',
    creating: 'Vytváření',
    creatingNewLabel: 'Vytváření nového {{label}}',
    currentlyEditing:
      'právě upravuje tento dokument. Pokud převezmete kontrolu, budou zablokováni v pokračování úprav a mohou také přijít o neuložené změny.',
    custom: 'Vlastní',
    dark: 'Tmavý',
    dashboard: 'Nástěnka',
    delete: 'Odstranit',
    deletedCountSuccessfully: 'Úspěšně smazáno {{count}} {{label}}.',
    deletedSuccessfully: 'Úspěšně odstraněno.',
    deleting: 'Odstraňování...',
    depth: 'Hloubka',
    descending: 'Sestupně',
    deselectAllRows: 'Zrušte výběr všech řádků',
    document: 'Dokument',
    documentLocked: 'Dokument je uzamčen',
    documents: 'Dokumenty',
    duplicate: 'Duplikovat',
    duplicateWithoutSaving: 'Duplikovat bez uložení změn',
    edit: 'Upravit',
    editedSince: 'Upraveno od',
    editing: 'Úprava',
    editingLabel_many: 'Úprava {{count}} {{label}}',
    editingLabel_one: 'Úprava {{count}} {{label}}',
    editingLabel_other: 'Úprava {{count}} {{label}}',
    editingTakenOver: 'Úpravy byly převzaty',
    editLabel: 'Upravit {{label}}',
    email: 'E-mail',
    emailAddress: 'E-mailová adresa',
    enterAValue: 'Zadejte hodnotu',
    error: 'Chyba',
    errors: 'Chyby',
    fallbackToDefaultLocale: 'Zpětné přepnutí do výchozího locale',
    false: 'Nepravda',
    filter: 'Filtr',
    filters: 'Filtry',
    filterWhere: 'Filtrovat {{label}} kde',
    globals: 'Globální',
    goBack: 'Vrátit se',
    isEditing: 'upravuje',
    language: 'Jazyk',
    lastModified: 'Naposledy změněno',
    leaveAnyway: 'Přesto odejít',
    leaveWithoutSaving: 'Odejít bez uložení',
    light: 'Světlé',
    livePreview: 'Náhled',
    loading: 'Načítání',
    locale: 'Místní verze',
    locales: 'Lokality',
    menu: 'Jídelní lístek',
    moveDown: 'Posunout dolů',
    moveUp: 'Posunout nahoru',
    newPassword: 'Nové heslo',
    next: 'Další',
    noDateSelected: 'Nebylo vybráno žádné datum',
    noFiltersSet: 'Nenastaveny žádné filtry',
    noLabel: '<Žádný {{label}}>',
    none: 'Žádné',
    noOptions: 'Žádné možnosti',
    noResults:
      'Nebyly nalezeny žádné {{label}}. Buď ještě neexistují žádné {{label}}, nebo žádné nesplňují filtry, které jste zadali výše.',
    notFound: 'Nenalezeno',
    nothingFound: 'Nic nenalezeno',
    noUpcomingEventsScheduled: 'Žádné nadcházející události nejsou naplánovány.',
    noValue: 'Žádná hodnota',
    of: 'z',
    only: 'Pouze',
    open: 'Otevřít',
    or: 'Nebo',
    order: 'Pořadí',
    overwriteExistingData: 'Přepsat existující data pole',
    pageNotFound: 'Stránka nenalezena',
    password: 'Heslo',
    payloadSettings: 'Payload nastavení',
    perPage: 'Na stránku: {{limit}}',
    previous: 'Předchozí',
    reindex: 'Přeindexovat',
    reindexingAll: 'Přeindexování všech {{collections}}.',
    remove: 'Odstranit',
    reset: 'Resetovat',
    resetPreferences: 'Obnovit nastavení',
    resetPreferencesDescription: 'Toto obnoví všechna vaše nastavení na výchozí hodnoty.',
    resettingPreferences: 'Obnovování nastavení.',
    row: 'Řádek',
    rows: 'Řádky',
    save: 'Uložit',
    saving: 'Ukládání...',
    schedulePublishFor: 'Naplánovat publikaci pro {{title}}',
    searchBy: 'Vyhledat podle {{label}}',
    selectAll: 'Vybrat vše {{count}} {{label}}',
    selectAllRows: 'Vyberte všechny řádky',
    selectedCount: 'Vybráno {{count}} {{label}}',
    selectValue: 'Vyberte hodnotu',
    showAllLabel: 'Zobrazit všechny {{label}}',
    sorryNotFound: 'Je nám líto, ale neexistuje nic, co by odpovídalo vašemu požadavku.',
    sort: 'Třídit',
    sortByLabelDirection: 'Seřadit podle {{label}} {{direction}}',
    stayOnThisPage: 'Zůstat na této stránce',
    submissionSuccessful: 'Odeslání úspěšné.',
    submit: 'Odeslat',
    submitting: 'Odesílání...',
    success: 'Úspěch',
    successfullyCreated: '{{label}} úspěšně vytvořeno.',
    successfullyDuplicated: '{{label}} úspěšně duplikováno.',
    successfullyReindexed:
      'Úspěšně přeindexováno {{count}} z {{total}} dokumentů z {{collections}} kolekcí.',
    takeOver: 'Převzít',
    thisLanguage: 'Čeština',
    time: 'Čas',
    titleDeleted: '{{label}} "{{title}}" úspěšně smazáno.',
    true: 'Pravda',
    unauthorized: 'Neoprávněný',
    unsavedChanges: 'Máte neuložené změny. Uložte nebo zahoďte před pokračováním.',
    unsavedChangesDuplicate: 'Máte neuložené změny. Chtěli byste pokračovat v duplikování?',
    untitled: 'Bez názvu',
    upcomingEvents: 'Nadcházející události',
    updatedAt: 'Aktualizováno v',
    updatedCountSuccessfully: 'Úspěšně aktualizováno {{count}} {{label}}.',
    updatedSuccessfully: 'Úspěšně aktualizováno.',
    updating: 'Aktualizace',
    uploading: 'Nahrávání',
    uploadingBulk: 'Nahrávání {{current}} z {{total}}',
    user: 'Uživatel',
    username: 'Uživatelské jméno',
    users: 'Uživatelé',
    value: 'Hodnota',
    viewReadOnly: 'Zobrazit pouze pro čtení',
    welcome: 'Vítejte',
  },
  localization: {
    cannotCopySameLocale: 'Nelze kopírovat do stejného umístění',
    copyFrom: 'Kopírovat z',
    copyFromTo: 'Kopírování z {{from}} do {{to}}',
    copyTo: 'Kopírovat do',
    copyToLocale: 'Kopírovat do lokalizace',
    localeToPublish: 'Místo k publikování',
    selectLocaleToCopy: 'Vyberte lokalitu ke kopírování',
  },
  operators: {
    contains: 'obsahuje',
    equals: 'rovná se',
    exists: 'existuje',
    intersects: 'protíná se',
    isGreaterThan: 'je větší než',
    isGreaterThanOrEqualTo: 'je větší nebo rovno',
    isIn: 'je v',
    isLessThan: 'je menší než',
    isLessThanOrEqualTo: 'je menší nebo rovno',
    isLike: 'je jako',
    isNotEqualTo: 'není rovno',
    isNotIn: 'není v',
    near: 'blízko',
    within: 'uvnitř',
  },
  upload: {
    addFile: 'Přidat soubor',
    addFiles: 'Přidat soubory',
    bulkUpload: 'Hromadné nahrání',
    crop: 'Ořez',
    cropToolDescription:
      'Přetáhněte rohy vybrané oblasti, nakreslete novou oblast nebo upravte níže uvedené hodnoty.',
    dragAndDrop: 'Přetáhněte soubor',
    dragAndDropHere: 'nebo sem přetáhněte soubor',
    editImage: 'Upravit obrázek',
    fileName: 'Název souboru',
    fileSize: 'Velikost souboru',
    filesToUpload: 'Soubory k nahrání',
    fileToUpload: 'Soubor k nahrání',
    focalPoint: 'Středobod',
    focalPointDescription:
      'Přetáhněte bod zaměření přímo na náhled nebo upravte níže uvedené hodnoty.',
    height: 'Výška',
    lessInfo: 'Méně informací',
    moreInfo: 'Více informací',
    pasteURL: 'Vložit URL',
    previewSizes: 'Náhled velikostí',
    selectCollectionToBrowse: 'Vyberte kolekci pro procházení',
    selectFile: 'Vyberte soubor',
    setCropArea: 'Nastavit oblast ořezu',
    setFocalPoint: 'Nastavit středobod',
    sizes: 'Velikosti',
    sizesFor: 'Velikosti pro {{label}}',
    width: 'Šířka',
  },
  validation: {
    emailAddress: 'Zadejte prosím platnou e-mailovou adresu.',
    enterNumber: 'Zadejte prosím platné číslo.',
    fieldHasNo: 'Toto pole nemá {{label}}',
    greaterThanMax: '{{value}} je vyšší než maximálně povolená {{label}} {{max}}.',
    invalidInput: 'Toto pole má neplatný vstup.',
    invalidSelection: 'Toto pole má neplatný výběr.',
    invalidSelections: 'Toto pole má následující neplatné výběry:',
    lessThanMin: '{{value}} je nižší než minimálně povolená {{label}} {{min}}.',
    limitReached: 'Dosáhnutý limit, mohou být přidány pouze {{max}} položky.',
    longerThanMin: 'Tato hodnota musí být delší než minimální délka {{minLength}} znaků.',
    notValidDate: '"{{value}}" není platné datum.',
    required: 'Toto pole je povinné.',
    requiresAtLeast: 'Toto pole vyžaduje alespoň {{count}} {{label}}.',
    requiresNoMoreThan: 'Toto pole vyžaduje ne více než {{count}} {{label}}.',
    requiresTwoNumbers: 'Toto pole vyžaduje dvě čísla.',
    shorterThanMax: 'Tato hodnota musí být kratší než maximální délka {{maxLength}} znaků.',
    trueOrFalse: 'Toto pole může být rovno pouze true nebo false.',
    username:
      'Prosím, zadejte platné uživatelské jméno. Může obsahovat písmena, čísla, pomlčky, tečky a podtržítka.',
    validUploadID: 'Toto pole není platné ID pro odeslání.',
  },
  version: {
    type: 'Typ',
    aboutToPublishSelection: 'Chystáte se publikovat všechny {{label}} ve výběru. Jsi si jistá?',
    aboutToRestore:
      'Chystáte se obnovit tento {{label}} dokument do stavu, v jakém byl {{versionDate}}.',
    aboutToRestoreGlobal:
      'Chystáte se obnovit globální {{label}} do stavu, v jakém byl {{versionDate}}.',
    aboutToRevertToPublished:
      'Chystáte se vrátit změny tohoto dokumentu do jeho publikovaného stavu. Jste si jisti?',
    aboutToUnpublish: 'Chystáte se zrušit publikování tohoto dokumentu. Jste si jisti?',
    aboutToUnpublishSelection:
      'Chystáte se zrušit publikování všech {{label}} ve výběru. Jsi si jistá?',
    autosave: 'Automatické uložení',
    autosavedSuccessfully: 'Úspěšně uloženo automaticky.',
    autosavedVersion: 'Verze automatického uložení',
    changed: 'Změněno',
    compareVersion: 'Porovnat verzi s:',
    confirmPublish: 'Potvrďte publikování',
    confirmRevertToSaved: 'Potvrdit vrácení k uloženému',
    confirmUnpublish: 'Potvrdit zrušení publikování',
    confirmVersionRestoration: 'Potvrdit obnovení verze',
    currentDocumentStatus: 'Současný {{docStatus}} dokument',
    currentDraft: 'Současný koncept',
    currentPublishedVersion: 'Aktuálně publikovaná verze',
    draft: 'Koncept',
    draftSavedSuccessfully: 'Koncept úspěšně uložen.',
    lastSavedAgo: 'Naposledy uloženo před {{distance}}',
    noFurtherVersionsFound: 'Nenalezeny další verze',
    noRowsFound: 'Nenalezen {{label}}',
    noRowsSelected: 'Nebyl vybrán žádný {{label}}',
    preview: 'Náhled',
    previouslyPublished: 'Dříve publikováno',
    problemRestoringVersion: 'Při obnovování této verze došlo k problému',
    publish: 'Publikovat',
    publishChanges: 'Publikovat změny',
    published: 'Publikováno',
    publishIn: 'Publikovat v {{locale}}',
    publishing: 'Publikování',
    restoreAsDraft: 'Obnovit jako koncept',
    restoredSuccessfully: 'Úspěšně obnoveno.',
    restoreThisVersion: 'Obnovit tuto verzi',
    restoring: 'Obnovování...',
    reverting: 'Vracení...',
    revertToPublished: 'Vrátit se k publikovanému',
    saveDraft: 'Uložit koncept',
    scheduledSuccessfully: 'Úspěšně naplánováno.',
    schedulePublish: 'Naplánovat publikaci',
    selectLocales: 'Vyberte místní verze pro zobrazení',
    selectVersionToCompare: 'Vyberte verzi pro porovnání',
    showingVersionsFor: 'Zobrazují se verze pro:',
    showLocales: 'Zobrazit místní verze:',
    status: 'Stav',
    unpublish: 'Zrušit publikování',
    unpublishing: 'Zrušuji publikování...',
    version: 'Verze',
    versionCount_many: '{{count}} verzí nalezeno',
    versionCount_none: 'Žádné verze nenalezeny',
    versionCount_one: '{{count}} verze nalezena',
    versionCount_other: '{{count}} verzí nalezeno',
    versionCreatedOn: '{{version}} vytvořena:',
    versionID: 'ID verze',
    versions: 'Verze',
    viewingVersion: 'Zobrazuji verzi pro {{entityLabel}} {{documentTitle}}',
    viewingVersionGlobal: 'Zobrazuji verzi pro globální {{entityLabel}}',
    viewingVersions: 'Zobrazuji verze pro {{entityLabel}} {{documentTitle}}',
    viewingVersionsGlobal: 'Zobrazuji verze pro globální {{entityLabel}}',
  },
}

export const cs: Language = {
  dateFNSKey: 'cs',
  translations: csTranslations,
}
