import type { GenericLanguages } from '@payloadcms/translations'

export const i18n: Partial<GenericLanguages> = {
  ar: {
    placeholder: "ابدأ بالكتابة، أو اضغط على '/' للأوامر ...",
    slashMenuBasicGroupLabel: 'أساسي',
    slashMenuListGroupLabel: 'قوائم',
    toolbarItemsActive: '{{count}} نشط',
  },
  az: {
    placeholder: "Yazmağa başlayın və ya əmrlər üçün '/' düyməsini basın...",
    slashMenuBasicGroupLabel: 'Əsas',
    slashMenuListGroupLabel: 'Siyahılar',
    toolbarItemsActive: '{{count}} aktiv',
  },
  bg: {
    placeholder: "Започнете да пишете или натиснете '/' за команди...",
    slashMenuBasicGroupLabel: 'Основен',
    slashMenuListGroupLabel: 'Списъци',
    toolbarItemsActive: '{{count}} активни',
  },
  cs: {
    placeholder: "Začněte psát nebo stiskněte '/' pro příkazy...",
    slashMenuBasicGroupLabel: 'Základní',
    slashMenuListGroupLabel: 'Seznamy',
    toolbarItemsActive: '{{count}} aktivní',
  },
  da: {
    placeholder: "Begynd at skrive, eller tryk på '/' for kommandoer...",
    slashMenuBasicGroupLabel: 'Grundlæggende',
    slashMenuListGroupLabel: 'Lister',
    toolbarItemsActive: '{{count}} aktive',
  },
  de: {
    placeholder: "Beginne zu tippen oder drücke '/' für Befehle...",
    slashMenuBasicGroupLabel: 'Basis',
    slashMenuListGroupLabel: 'Listen',
    toolbarItemsActive: '{{count}} aktiv',
  },
  en: {
    placeholder: "Start typing, or press '/' for commands...",
    slashMenuBasicGroupLabel: 'Basic',
    slashMenuListGroupLabel: 'Lists',
    toolbarItemsActive: '{{count}} active',
  },
  es: {
    placeholder: "Comience a escribir, o presione '/' para comandos...",
    slashMenuBasicGroupLabel: 'Básico',
    slashMenuListGroupLabel: 'Listas',
    toolbarItemsActive: '{{count}} activo',
  },
  et: {
    placeholder: "Alusta kirjutamist või vajuta '/' käskude jaoks...",
    slashMenuBasicGroupLabel: 'Põhiline',
    slashMenuListGroupLabel: 'Loendid',
    toolbarItemsActive: '{{count}} aktiivne',
  },
  fa: {
    placeholder: "شروع به تایپ کنید، یا برای دستورات '/' را فشار دهید ...",
    slashMenuBasicGroupLabel: 'پایه',
    slashMenuListGroupLabel: 'لیست ها',
    toolbarItemsActive: '{{count}} فعال',
  },
  fr: {
    placeholder: "Commencez à taper, ou appuyez sur '/' pour les commandes...",
    slashMenuBasicGroupLabel: 'De base',
    slashMenuListGroupLabel: 'Listes',
    toolbarItemsActive: '{{count}} actif',
  },
  he: {
    placeholder: "התחיל להקליד, או לחץ על '/' עבור פקודות ...",
    slashMenuBasicGroupLabel: 'בסיסי',
    slashMenuListGroupLabel: 'רשימות',
    toolbarItemsActive: '{{count}} פעיל',
  },
  hr: {
    placeholder: "Počnite tipkati, ili pritisnite '/' za naredbe...",
    slashMenuBasicGroupLabel: 'Osnovno',
    slashMenuListGroupLabel: 'Popisi',
    toolbarItemsActive: '{{count}} aktivno',
  },
  hu: {
    placeholder: "Kezdje el gépelni, vagy nyomja meg a '/' billentyűt a parancsokhoz...",
    slashMenuBasicGroupLabel: 'Alapvető',
    slashMenuListGroupLabel: 'Listák',
    toolbarItemsActive: '{{count}} aktív',
  },
  it: {
    placeholder: "Inizia a digitare, oppure premi '/' per i comandi...",
    slashMenuBasicGroupLabel: 'Base',
    slashMenuListGroupLabel: 'Elenchi',
    toolbarItemsActive: '{{count}} attivo',
  },
  ja: {
    placeholder: "入力を開始するか、コマンドのために'/'を押してください…",
    slashMenuBasicGroupLabel: '基本的な',
    slashMenuListGroupLabel: 'リスト',
    toolbarItemsActive: '{{count}} アクティブ',
  },
  ko: {
    placeholder: "타이핑을 시작하거나, 명령어를 입력하려면 '/'를 누르세요...",
    slashMenuBasicGroupLabel: '기본적인',
    slashMenuListGroupLabel: '목록',
    toolbarItemsActive: '{{count}} 활성화된',
  },
  my: {
    placeholder: "Mula menaip, atau tekan '/' untuk arahan...",
    slashMenuBasicGroupLabel: 'အခြေခံ',
    slashMenuListGroupLabel: 'Senarai',
    toolbarItemsActive: '{{count}} aktif',
  },
  nb: {
    placeholder: "Begynn å skrive, eller trykk '/' for kommandoer...",
    slashMenuBasicGroupLabel: 'Grunnleggende',
    slashMenuListGroupLabel: 'Lister',
    toolbarItemsActive: '{{count}} aktiv',
  },
  nl: {
    placeholder: "Begin met typen, of druk op '/' voor opdrachten...",
    slashMenuBasicGroupLabel: 'Basis',
    slashMenuListGroupLabel: 'Lijsten',
    toolbarItemsActive: '{{count}} actief',
  },
  pl: {
    placeholder: "Rozpocznij pisanie lub naciśnij '/' dla poleceń...",
    slashMenuBasicGroupLabel: 'Podstawowy',
    slashMenuListGroupLabel: 'Listy',
    toolbarItemsActive: '{{count}} aktywny',
  },
  pt: {
    placeholder: "Comece a digitar, ou pressione '/' para comandos...",
    slashMenuBasicGroupLabel: 'Básico',
    slashMenuListGroupLabel: 'Listas',
    toolbarItemsActive: '{{count}} ativo',
  },
  ro: {
    placeholder: "Începeți să tastați sau apăsați '/' pentru comenzi...",
    slashMenuBasicGroupLabel: 'De bază',
    slashMenuListGroupLabel: 'Liste',
    toolbarItemsActive: '{{count}} activ',
  },
  rs: {
    placeholder: "Почните да куцате, или притисните '/' за команде...",
    slashMenuBasicGroupLabel: 'Основно',
    slashMenuListGroupLabel: 'Листе',
    toolbarItemsActive: '{{count}} активно',
  },
  'rs-latin': {
    placeholder: "Počnite da kucate, ili pritisnite '/' za komande...",
    slashMenuBasicGroupLabel: 'Osnovno',
    slashMenuListGroupLabel: 'Liste',
    toolbarItemsActive: '{{count}} aktivan',
  },
  ru: {
    placeholder: "Начните печатать или нажмите '/' для команд...",
    slashMenuBasicGroupLabel: 'Базовый',
    slashMenuListGroupLabel: 'Списки',
    toolbarItemsActive: '{{count}} активных',
  },
  sk: {
    placeholder: "Začnite písať alebo stlačte '/' pre príkazy...",
    slashMenuBasicGroupLabel: 'Základný',
    slashMenuListGroupLabel: 'Zoznamy',
    toolbarItemsActive: '{{count}} aktívne',
  },
  sl: {
    placeholder: 'Začnite tipkati ali pritisnite "/" za ukaze...',
    slashMenuBasicGroupLabel: 'Osnovno',
    slashMenuListGroupLabel: 'Seznami',
    toolbarItemsActive: '{{count}} aktivno',
  },
  sv: {
    placeholder: "Börja skriva, eller tryck på '/' för kommandon...",
    slashMenuBasicGroupLabel: 'Grundläggande',
    slashMenuListGroupLabel: 'Listor',
    toolbarItemsActive: '{{count}} aktiv',
  },
  th: {
    placeholder: "เริ่มพิมพ์หรือกด '/' สำหรับคำสั่ง...",
    slashMenuBasicGroupLabel: 'พื้นฐาน',
    slashMenuListGroupLabel: 'รายการ',
    toolbarItemsActive: '{{count}} ที่ใช้งานอยู่',
  },
  tr: {
    placeholder: "Yazmaya başlayın veya komutlar için '/' tuşuna basın...",
    slashMenuBasicGroupLabel: 'Temel',
    slashMenuListGroupLabel: 'Listeler',
    toolbarItemsActive: '{{count}} aktif',
  },
  uk: {
    placeholder: "Почніть друкувати, або натисніть '/' для команд...",
    slashMenuBasicGroupLabel: 'Базовий',
    slashMenuListGroupLabel: 'Списки',
    toolbarItemsActive: '{{count}} активний',
  },
  vi: {
    placeholder: "Bắt đầu gõ, hoặc nhấn '/' để gọi lệnh...",
    slashMenuBasicGroupLabel: 'Cơ bản',
    slashMenuListGroupLabel: 'Danh sách',
    toolbarItemsActive: '{{count}} đang hoạt động',
  },
  zh: {
    placeholder: "开始输入，或按'/'进行命令...",
    slashMenuBasicGroupLabel: '基础',
    slashMenuListGroupLabel: '列表',
    toolbarItemsActive: '{{count}} 活跃',
  },
  'zh-TW': {
    placeholder: "開始輸入，或按'/'以使用命令...",
    slashMenuBasicGroupLabel: '基本的',
    slashMenuListGroupLabel: '清單',
    toolbarItemsActive: '{{count}} 活躍中',
  },
}
