import type { GenericLanguages } from '@payloadcms/translations'

export const i18n: Partial<GenericLanguages> = {
  ar: {
    inlineBlocks: {
      create: 'أنشئ {{label}}',
      edit: 'تحرير {{التسمية}}',
      label: 'الكتل الداخلية',
      remove: 'إزالة {{التسمية}}',
    },
    label: 'كتل',
  },
  az: {
    inlineBlocks: {
      create: 'Yarat {{label}}',
      edit: '{{label}} redaktə et',
      label: 'Sıralı Bloklar',
      remove: '{{label}} silin',
    },
    label: 'Bloklar',
  },
  bg: {
    inlineBlocks: {
      create: 'Създайте {{етикет}}',
      edit: 'Редактирай {{етикет}}',
      label: 'Вградени блокове',
      remove: 'Премахнете {{етикет}}',
    },
    label: 'Блокове',
  },
  cs: {
    inlineBlocks: {
      create: 'Vytvořte {{štítek}}',
      edit: 'Upravit {{label}}',
      label: 'Inline bloky',
      remove: 'Odstraňte {{label}}',
    },
    label: 'Bloky',
  },
  da: {
    inlineBlocks: {
      create: 'Opret {{label}}',
      edit: 'Rediger {{label}}',
      label: 'Indlejrede blokke',
      remove: 'Fjern {{label}}',
    },
    label: 'Blokke',
  },
  de: {
    inlineBlocks: {
      create: 'Erstelle {{label}}',
      edit: 'Bearbeite {{label}}',
      label: 'Inline-Blöcke',
      remove: 'Entferne {{label}}',
    },
    label: 'Blöcke',
  },
  en: {
    inlineBlocks: {
      create: 'Create {{label}}',
      edit: 'Edit {{label}}',
      label: 'Inline Blocks',
      remove: 'Remove {{label}}',
    },
    label: 'Blocks',
  },
  es: {
    inlineBlocks: {
      create: 'Crear {{etiqueta}}',
      edit: 'Editar {{etiqueta}}',
      label: 'Bloques en línea',
      remove: 'Eliminar {{label}}',
    },
    label: 'Bloques',
  },
  et: {
    inlineBlocks: {
      create: 'Loo {{label}}',
      edit: 'Muuda {{label}}',
      label: 'Sisseehitatud plokid',
      remove: 'Eemalda {{label}}',
    },
    label: 'Plokk',
  },
  fa: {
    inlineBlocks: {
      create: 'ایجاد {{برچسب}}',
      edit: 'ویرایش {{برچسب}}',
      label: 'بلوک‌های درون خطی',
      remove: 'حذف {{برچسب}}',
    },
    label: 'بلوک ها',
  },
  fr: {
    inlineBlocks: {
      create: 'Créer {{label}}',
      edit: 'Modifier {{label}}',
      label: 'Blocs en ligne',
      remove: 'Supprimer {{label}}',
    },
    label: 'Blocs',
  },
  he: {
    inlineBlocks: {
      create: 'צור {{תווית}}',
      edit: 'ערוך {{תווית}}',
      label: 'בלוקים משורשרים',
      remove: 'הסר {{תווית}}',
    },
    label: 'חסימות',
  },
  hr: {
    inlineBlocks: {
      create: 'Stvori {{oznaka}}',
      edit: 'Uredi {{label}}',
      label: 'Unutrašnji blokovi',
      remove: 'Ukloni {{oznaka}}',
    },
    label: 'Blokovi',
  },
  hu: {
    inlineBlocks: {
      create: 'Hozzon létre {{címke}}',
      edit: 'Szerkesztés {{címke}}',
      label: 'Beágyazott blokkok',
      remove: 'Távolítsa el a {{label}}',
    },
    label: 'Blokkok',
  },
  it: {
    inlineBlocks: {
      create: 'Crea {{etichetta}}',
      edit: 'Modifica {{label}}',
      label: 'Blocchi in linea',
      remove: 'Rimuovi {{label}}',
    },
    label: 'Blocchi',
  },
  ja: {
    inlineBlocks: {
      create: '{{label}}を作成する',
      edit: '{{label}}を編集する',
      label: 'インラインブロック',
      remove: '{{ラベル}}を削除します',
    },
    label: 'ブロック',
  },
  ko: {
    inlineBlocks: {
      create: '{{label}} 생성하기',
      edit: '{{label}} 수정하기',
      label: '인라인 블록',
      remove: '{{label}} 제거하세요',
    },
    label: '블록',
  },
  my: {
    inlineBlocks: {
      create: 'Cipta {{label}}',
      edit: 'Sunting {{label}}',
      label: 'Inline Blocks [SKIPPED]',
      remove: 'Buang {{label}}',
    },
    label: 'တံတားများ',
  },
  nb: {
    inlineBlocks: {
      create: 'Opprett {{label}}',
      edit: 'Rediger {{label}}',
      label: 'In-line blokker',
      remove: 'Fjern {{label}}',
    },
    label: 'Blokker',
  },
  nl: {
    inlineBlocks: {
      create: 'Maak {{label}}',
      edit: 'Bewerk {{label}}',
      label: 'Inline Blocks',
      remove: 'Verwijder {{label}}',
    },
    label: 'Blokken',
  },
  pl: {
    inlineBlocks: {
      create: 'Utwórz {{label}}',
      edit: 'Edytuj {{etykieta}}',
      label: 'Blokowanie w linii',
      remove: 'Usuń {{etykieta}}',
    },
    label: 'Bloki',
  },
  pt: {
    inlineBlocks: {
      create: 'Crie {{label}}',
      edit: 'Editar {{label}}',
      label: 'Blocos em linha',
      remove: 'Remova {{label}}',
    },
    label: 'Blocos',
  },
  ro: {
    inlineBlocks: {
      create: 'Creează {{eticheta}}',
      edit: 'Editați {{eticheta}}',
      label: 'Blocuri in linie',
      remove: 'Ștergeți {{etichetă}}',
    },
    label: 'Blocuri',
  },
  rs: {
    inlineBlocks: {
      create: 'Креирај {{label}}',
      edit: 'Измени {{label}}',
      label: 'Уметнути блокови',
      remove: 'Уклони {{label}}',
    },
    label: 'Блокови',
  },
  'rs-latin': {
    inlineBlocks: {
      create: 'Kreiraj {{label}}',
      edit: 'Izmeni {{label}}',
      label: 'Umetnuti blokovi',
      remove: 'Ukloni {{oznaka}}',
    },
    label: 'Blokovi',
  },
  ru: {
    inlineBlocks: {
      create: 'Создать {{label}}',
      edit: 'Изменить {{метка}}',
      label: 'Встроенные блоки',
      remove: 'Удалить {{метка}}',
    },
    label: 'Блоки',
  },
  sk: {
    inlineBlocks: {
      create: 'Vytvorte {{označenie}}',
      edit: 'Upraviť {{label}}',
      label: 'Inline bloky',
      remove: 'Odstráňte {{label}}',
    },
    label: 'Bloky',
  },
  sl: {
    inlineBlocks: {
      create: 'Ustvari {{oznaka}}',
      edit: 'Uredi {{label}}',
      label: 'Vrstični bloki',
      remove: 'Odstrani {{label}}',
    },
    label: 'Bloki',
  },
  sv: {
    inlineBlocks: {
      create: 'Skapa {{label}}',
      edit: 'Redigera {{etikett}}',
      label: 'Inline-blockar',
      remove: 'Ta bort {{etikett}}',
    },
    label: 'Block',
  },
  th: {
    inlineBlocks: {
      create: 'สร้าง {{label}}',
      edit: 'แก้ไข {{label}}',
      label: 'บล็อกแบบอินไลน์',
      remove: 'ลบ {{label}}',
    },
    label: 'บล็อค',
  },
  tr: {
    inlineBlocks: {
      create: '{{Etiketi}} oluşturun',
      edit: "{{Etiket}}'i düzenleyin",
      label: 'Satır İçi Bloklar',
      remove: '{{Etiketi}} kaldırın',
    },
    label: 'Bloklar',
  },
  uk: {
    inlineBlocks: {
      create: 'Створити {{label}}',
      edit: 'Редагувати {{label}}',
      label: 'Вбудовані блоки',
      remove: 'Видалити {{мітку}}',
    },
    label: 'Блоки',
  },
  vi: {
    inlineBlocks: {
      create: 'Tạo {{label}}',
      edit: 'Chỉnh sửa {{nhãn}}',
      label: 'Khối nội tuyến',
      remove: 'Xóa {{nhãn}}',
    },
    label: 'Khối',
  },
  zh: {
    inlineBlocks: {
      create: '创建{{label}}',
      edit: '编辑 {{label}}',
      label: '内联块',
      remove: '删除{{label}}',
    },
    label: '块',
  },
  'zh-TW': {
    inlineBlocks: {
      create: '創建 {{label}}',
      edit: '編輯 {{label}}',
      label: '內聯區塊',
      remove: '移除 {{label}}',
    },
    label: '區塊',
  },
}
