import type { GenericLanguages } from '@payloadcms/translations'

export const i18n: Partial<GenericLanguages> = {
  ar: {
    alignCenterLabel: 'محاذاة في الوسط',
    alignJustifyLabel: 'محاذاة التبرير',
    alignLeftLabel: 'محاذاة إلى اليسار',
    alignRightLabel: 'محاذاة إلى اليمين',
  },
  az: {
    alignCenterLabel: 'Mərkəzə Düzəlt',
    alignJustifyLabel: 'Düzəldin Səsləndirin',
    alignLeftLabel: 'Sola Doğru Hizalama',
    alignRightLabel: 'Sağa Doğru Hizalama',
  },
  bg: {
    alignCenterLabel: 'Центрирай',
    alignJustifyLabel: 'Подравняване по двата края',
    alignLeftLabel: 'Подравняване отляво',
    alignRightLabel: 'Подравняване вдясно',
  },
  cs: {
    alignCenterLabel: 'Zarovnat na střed',
    alignJustifyLabel: 'Zarovnat do bloku',
    alignLeftLabel: 'Zarovnat vlevo',
    alignRightLabel: 'Zarovnat vpravo',
  },
  da: {
    alignCenterLabel: 'Centrer teksten',
    alignJustifyLabel: 'Justér til begge sider',
    alignLeftLabel: 'Justér til venstre',
    alignRightLabel: 'Juster til højre',
  },
  de: {
    alignCenterLabel: 'Zentrieren',
    alignJustifyLabel: 'Blocksatz',
    alignLeftLabel: 'Linksbündig',
    alignRightLabel: 'Rechtsbündig',
  },
  en: {
    alignCenterLabel: 'Align Center',
    alignJustifyLabel: 'Align Justify',
    alignLeftLabel: 'Align Left',
    alignRightLabel: 'Align Right',
  },
  es: {
    alignCenterLabel: 'Alinear al centro',
    alignJustifyLabel: 'Alinear Justificar',
    alignLeftLabel: 'Alinear a la izquierda',
    alignRightLabel: 'Alinear a la derecha',
  },
  et: {
    alignCenterLabel: 'Keskjoondus',
    alignJustifyLabel: 'Rööpjoondus',
    alignLeftLabel: 'Vasakjoondus',
    alignRightLabel: 'Paremjoondus',
  },
  fa: {
    alignCenterLabel: 'تراز در مرکز',
    alignJustifyLabel: 'تراز کردن از دو طرف',
    alignLeftLabel: 'چپ تراز',
    alignRightLabel: 'راست چین',
  },
  fr: {
    alignCenterLabel: 'Aligner au centre',
    alignJustifyLabel: 'Aligner Justifier',
    alignLeftLabel: 'Aligner à gauche',
    alignRightLabel: 'Aligner à droite',
  },
  he: {
    alignCenterLabel: 'ממורכז',
    alignJustifyLabel: 'יישור דו-צדדי',
    alignLeftLabel: 'הסב לשמאל',
    alignRightLabel: 'יישור לימין',
  },
  hr: {
    alignCenterLabel: 'Poravnaj središnje',
    alignJustifyLabel: 'Poravnaj opravdaj',
    alignLeftLabel: 'Poravnaj lijevo',
    alignRightLabel: 'Poravnaj desno',
  },
  hu: {
    alignCenterLabel: 'Középre igazítás',
    alignJustifyLabel: 'Igazítás Sorkizárás',
    alignLeftLabel: 'Igazítás balra',
    alignRightLabel: 'Igazítás jobbra',
  },
  it: {
    alignCenterLabel: 'Allinea al centro',
    alignJustifyLabel: 'Allinea Giustifica',
    alignLeftLabel: 'Allinea a sinistra',
    alignRightLabel: 'Allinea a destra',
  },
  ja: {
    alignCenterLabel: '中央揃え',
    alignJustifyLabel: '両端揃え',
    alignLeftLabel: '左揃え',
    alignRightLabel: '右揃え',
  },
  ko: {
    alignCenterLabel: '중앙 정렬',
    alignJustifyLabel: '정렬 맞춤',
    alignLeftLabel: '왼쪽 정렬',
    alignRightLabel: '오른쪽 정렬',
  },
  my: {
    alignCenterLabel: 'Pusat Selaras',
    alignJustifyLabel: 'Penjajaran Justify',
    alignLeftLabel: 'ဘယ်ဘက်ဦးတည်ခြင်း',
    alignRightLabel: 'Penjajaran Kanan',
  },
  nb: {
    alignCenterLabel: 'Sentrer tekst',
    alignJustifyLabel: 'Juster linje',
    alignLeftLabel: 'Juster til venstre',
    alignRightLabel: 'Juster til høyre',
  },
  nl: {
    alignCenterLabel: 'Centreer uitlijnen',
    alignJustifyLabel: 'Uitlijnen Rechtvaardigen',
    alignLeftLabel: 'Links uitlijnen',
    alignRightLabel: 'Rechts uitlijnen',
  },
  pl: {
    alignCenterLabel: 'Wyśrodkuj',
    alignJustifyLabel: 'Wyjustuj wyrównanie',
    alignLeftLabel: 'Wyrównaj do lewej',
    alignRightLabel: 'Wyrównaj do prawej',
  },
  pt: {
    alignCenterLabel: 'Alinhar ao Centro',
    alignJustifyLabel: 'Alinhar Justificar',
    alignLeftLabel: 'Alinhar à Esquerda',
    alignRightLabel: 'Alinhar à Direita',
  },
  ro: {
    alignCenterLabel: 'Aliniați Centrul',
    alignJustifyLabel: 'Aliniaza Justifica',
    alignLeftLabel: 'Aliniați la stânga',
    alignRightLabel: 'Aliniați la dreapta',
  },
  rs: {
    alignCenterLabel: 'Поравнај по средини',
    alignJustifyLabel: 'Поравнај обострано',
    alignLeftLabel: 'Поравнај лево',
    alignRightLabel: 'Поравнај десно',
  },
  'rs-latin': {
    alignCenterLabel: 'Poravnaj po sredini',
    alignJustifyLabel: 'Poravnaj obostrano',
    alignLeftLabel: 'Poravnaj levo',
    alignRightLabel: 'Poravnaj desno',
  },
  ru: {
    alignCenterLabel: 'Выровнять по центру',
    alignJustifyLabel: 'Выровнять по ширине',
    alignLeftLabel: 'Выровнять по левому краю',
    alignRightLabel: 'Выровнять по правому краю',
  },
  sk: {
    alignCenterLabel: 'Vycentrovať',
    alignJustifyLabel: 'Zarovnať do bloku',
    alignLeftLabel: 'Zarovnať doľava',
    alignRightLabel: 'Zarovnať doprava',
  },
  sl: {
    alignCenterLabel: 'Poravnaj na sredino',
    alignJustifyLabel: 'Poravnaj Obojestransko',
    alignLeftLabel: 'Poravnaj na levo',
    alignRightLabel: 'Poravnaj na desno',
  },
  sv: {
    alignCenterLabel: 'Centrera',
    alignJustifyLabel: 'Justera Justify',
    alignLeftLabel: 'Justera till vänster',
    alignRightLabel: 'Justera till höger',
  },
  th: {
    alignCenterLabel: 'จัดแนวกึ่งกลาง',
    alignJustifyLabel: 'จัดแนวตรง',
    alignLeftLabel: 'จัดชิดซ้าย',
    alignRightLabel: 'จัดชิดขวา',
  },
  tr: {
    alignCenterLabel: 'Ortaya Hizala',
    alignJustifyLabel: 'Hizala Yasla',
    alignLeftLabel: 'Sola Hizala',
    alignRightLabel: 'Sağa Hizala',
  },
  uk: {
    alignCenterLabel: 'Вирівняти по центру',
    alignJustifyLabel: 'Вирівняти за шириною',
    alignLeftLabel: 'Вирівняти по лівому краю',
    alignRightLabel: 'Вирівняти по правому краю',
  },
  vi: {
    alignCenterLabel: 'Căn giữa',
    alignJustifyLabel: 'Căn đều',
    alignLeftLabel: 'Căn lề trái',
    alignRightLabel: 'Căn phải',
  },
  zh: {
    alignCenterLabel: '居中对齐',
    alignJustifyLabel: '对齐调整',
    alignLeftLabel: '向左对齐',
    alignRightLabel: '向右对齐',
  },
  'zh-TW': {
    alignCenterLabel: '對齊中心',
    alignJustifyLabel: '對齊並排列',
    alignLeftLabel: '向左對齊',
    alignRightLabel: '向右對齊',
  },
}
