import { addSelectGenericsToGeneratedTypes } from './addSelectGenericsToGeneretedTypes.js'

const INPUT_AND_OUTPUT = [
  {
    input: `
/* tslint:disable */
/* eslint-disable */
/**
 * This file was automatically generated by Payload.
 * DO NOT MODIFY IT BY HAND. Instead, modify your source Payload config,
 * and re-run \`payload generate:types\` to regenerate this file.
 */

export interface Config {
  auth: {
    users: UserAuthOperations;
  };
  collections: {
    posts: Post;
    users: User;
    'payload-locked-documents': PayloadLockedDocument;
    'payload-preferences': PayloadPreference;
    'payload-migrations': PayloadMigration;
  };
  collectionsSelect: {
    posts: PostsSelect;
    users: UsersSelect;
    'payload-locked-documents': PayloadLockedDocumentsSelect;
    'payload-preferences': PayloadPreferencesSelect;
    'payload-migrations': PayloadMigrationsSelect;
  };
  db: {
    defaultIDType: string;
  };
  globals: {};
  globalsSelect: {};
  locale: null;
  user: User & {
    collection: 'users';
  };
}
export interface UserAuthOperations {
  forgotPassword: {
    email: string;
    password: string;
  };
  login: {
    email: string;
    password: string;
  };
  registerFirstUser: {
    email: string;
    password: string;
  };
  unlock: {
    email: string;
    password: string;
  };
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "posts".
 */
export interface Post {
  id: string;
  text?: string | null;
  number?: number | null;
  group?: {
    text?: string | null;
    number?: number | null;
  };
  array?:
    | {
        text?: string | null;
        number?: number | null;
        id?: string | null;
      }[]
    | null;
  blocks?:
    | (
        | {
            text?: string | null;
            introText?: string | null;
            id?: string | null;
            blockName?: string | null;
            blockType: 'intro';
          }
        | {
            text?: string | null;
            ctaText?: string | null;
            id?: string | null;
            blockName?: string | null;
            blockType: 'cta';
          }
      )[]
    | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "users".
 */
export interface User {
  id: string;
  updatedAt: string;
  createdAt: string;
  email: string;
  resetPasswordToken?: string | null;
  resetPasswordExpiration?: string | null;
  salt?: string | null;
  hash?: string | null;
  loginAttempts?: number | null;
  lockUntil?: string | null;
  password?: string | null;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-locked-documents".
 */
export interface PayloadLockedDocument {
  id: string;
  document?:
    | ({
        relationTo: 'posts';
        value: string | Post;
      } | null)
    | ({
        relationTo: 'users';
        value: string | User;
      } | null);
  globalSlug?: string | null;
  user: {
    relationTo: 'users';
    value: string | User;
  };
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-preferences".
 */
export interface PayloadPreference {
  id: string;
  user: {
    relationTo: 'users';
    value: string | User;
  };
  key?: string | null;
  value?:
    | {
        [k: string]: unknown;
      }
    | unknown[]
    | string
    | number
    | boolean
    | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-migrations".
 */
export interface PayloadMigration {
  id: string;
  name?: string | null;
  batch?: number | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "posts_select".
 */
export interface PostsSelect {
  text?: boolean;
  number?: boolean;
  sharedGroup?: boolean | SharedGroup;
  group?:
    | boolean
    | {
        text?: boolean;
        number?: boolean;
      };
  array?:
    | boolean
    | {
        text?: boolean;
        number?: boolean;
        id?: boolean;
      };
  blocks?:
    | boolean
    | {
        intro?:
          | boolean
          | {
              text?: boolean;
              introText?: boolean;
              id?: boolean;
              blockName?: boolean;
            };
        cta?:
          | boolean
          | {
              text?: boolean;
              ctaText?: boolean;
              id?: boolean;
              blockName?: boolean;
            };
      };
  updatedAt?: boolean;
  createdAt?: boolean;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "users_select".
 */
export interface UsersSelect {
  updatedAt?: boolean;
  createdAt?: boolean;
  email?: boolean;
  resetPasswordToken?: boolean;
  resetPasswordExpiration?: boolean;
  salt?: boolean;
  hash?: boolean;
  loginAttempts?: boolean;
  lockUntil?: boolean;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-locked-documents_select".
 */
export interface PayloadLockedDocumentsSelect {
  document?: boolean;
  globalSlug?: boolean;
  user?: boolean;
  updatedAt?: boolean;
  createdAt?: boolean;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-preferences_select".
 */
export interface PayloadPreferencesSelect {
  user?: boolean;
  key?: boolean;
  value?: boolean;
  updatedAt?: boolean;
  createdAt?: boolean;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-migrations_select".
 */
export interface PayloadMigrationsSelect {
  name?: boolean;
  batch?: boolean;
  updatedAt?: boolean;
  createdAt?: boolean;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "auth".
 */
export interface Auth {
  [k: string]: unknown;
}


declare module 'payload' {
  // @ts-ignore 
  export interface GeneratedTypes extends Config {}
}
`,
    output: `
/* tslint:disable */
/* eslint-disable */
/**
 * This file was automatically generated by Payload.
 * DO NOT MODIFY IT BY HAND. Instead, modify your source Payload config,
 * and re-run \`payload generate:types\` to regenerate this file.
 */

export interface Config {
  auth: {
    users: UserAuthOperations;
  };
  collections: {
    posts: Post;
    users: User;
    'payload-locked-documents': PayloadLockedDocument;
    'payload-preferences': PayloadPreference;
    'payload-migrations': PayloadMigration;
  };
  collectionsSelect: {
    posts: PostsSelect<false> | PostsSelect<true>;
    users: UsersSelect<false> | UsersSelect<true>;
    'payload-locked-documents': PayloadLockedDocumentsSelect<false> | PayloadLockedDocumentsSelect<true>;
    'payload-preferences': PayloadPreferencesSelect<false> | PayloadPreferencesSelect<true>;
    'payload-migrations': PayloadMigrationsSelect<false> | PayloadMigrationsSelect<true>;
  };
  db: {
    defaultIDType: string;
  };
  globals: {};
  globalsSelect: {};
  locale: null;
  user: User & {
    collection: 'users';
  };
}
export interface UserAuthOperations {
  forgotPassword: {
    email: string;
    password: string;
  };
  login: {
    email: string;
    password: string;
  };
  registerFirstUser: {
    email: string;
    password: string;
  };
  unlock: {
    email: string;
    password: string;
  };
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "posts".
 */
export interface Post {
  id: string;
  text?: string | null;
  number?: number | null;
  group?: {
    text?: string | null;
    number?: number | null;
  };
  array?:
    | {
        text?: string | null;
        number?: number | null;
        id?: string | null;
      }[]
    | null;
  blocks?:
    | (
        | {
            text?: string | null;
            introText?: string | null;
            id?: string | null;
            blockName?: string | null;
            blockType: 'intro';
          }
        | {
            text?: string | null;
            ctaText?: string | null;
            id?: string | null;
            blockName?: string | null;
            blockType: 'cta';
          }
      )[]
    | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "users".
 */
export interface User {
  id: string;
  updatedAt: string;
  createdAt: string;
  email: string;
  resetPasswordToken?: string | null;
  resetPasswordExpiration?: string | null;
  salt?: string | null;
  hash?: string | null;
  loginAttempts?: number | null;
  lockUntil?: string | null;
  password?: string | null;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-locked-documents".
 */
export interface PayloadLockedDocument {
  id: string;
  document?:
    | ({
        relationTo: 'posts';
        value: string | Post;
      } | null)
    | ({
        relationTo: 'users';
        value: string | User;
      } | null);
  globalSlug?: string | null;
  user: {
    relationTo: 'users';
    value: string | User;
  };
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-preferences".
 */
export interface PayloadPreference {
  id: string;
  user: {
    relationTo: 'users';
    value: string | User;
  };
  key?: string | null;
  value?:
    | {
        [k: string]: unknown;
      }
    | unknown[]
    | string
    | number
    | boolean
    | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-migrations".
 */
export interface PayloadMigration {
  id: string;
  name?: string | null;
  batch?: number | null;
  updatedAt: string;
  createdAt: string;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "posts_select".
 */
export interface PostsSelect<T extends boolean = true> {
  text?: T;
  number?: T;
  sharedGroup?: T | SharedGroup<T>;
  group?:
    | T
    | {
        text?: T;
        number?: T;
      };
  array?:
    | T
    | {
        text?: T;
        number?: T;
        id?: T;
      };
  blocks?:
    | T
    | {
        intro?:
          | T
          | {
              text?: T;
              introText?: T;
              id?: T;
              blockName?: T;
            };
        cta?:
          | T
          | {
              text?: T;
              ctaText?: T;
              id?: T;
              blockName?: T;
            };
      };
  updatedAt?: T;
  createdAt?: T;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "users_select".
 */
export interface UsersSelect<T extends boolean = true> {
  updatedAt?: T;
  createdAt?: T;
  email?: T;
  resetPasswordToken?: T;
  resetPasswordExpiration?: T;
  salt?: T;
  hash?: T;
  loginAttempts?: T;
  lockUntil?: T;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-locked-documents_select".
 */
export interface PayloadLockedDocumentsSelect<T extends boolean = true> {
  document?: T;
  globalSlug?: T;
  user?: T;
  updatedAt?: T;
  createdAt?: T;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-preferences_select".
 */
export interface PayloadPreferencesSelect<T extends boolean = true> {
  user?: T;
  key?: T;
  value?: T;
  updatedAt?: T;
  createdAt?: T;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "payload-migrations_select".
 */
export interface PayloadMigrationsSelect<T extends boolean = true> {
  name?: T;
  batch?: T;
  updatedAt?: T;
  createdAt?: T;
}
/**
 * This interface was referenced by \`Config\`'s JSON-Schema
 * via the \`definition\` "auth".
 */
export interface Auth {
  [k: string]: unknown;
}


declare module 'payload' {
  // @ts-ignore 
  export interface GeneratedTypes extends Config {}
}
`,
  },
]

describe('addSelectGenericsToGeneratedTypes', () => {
  it('should match return of given input with output', () => {
    for (const { input, output } of INPUT_AND_OUTPUT) {
      expect(
        addSelectGenericsToGeneratedTypes({
          compiledGeneratedTypes: input,
        }),
      ).toStrictEqual(output)
    }
  })
})
