import type { Metadata } from 'next'

import { draftMode } from 'next/headers'

import { AdminBar } from '../../components/AdminBar'
import { Header } from '../../components/Header'
import './app.scss'

export const metadata: Metadata = {
  description: 'Generated by create next app',
  title: 'Create Next App',
}

// eslint-disable-next-line no-restricted-exports
export default async function RootLayout({ children }: { children: React.ReactNode }) {
  const { isEnabled } = await draftMode()

  return (
    <html lang="en">
      <body>
        <AdminBar
          adminBarProps={{
            preview: isEnabled,
          }}
        />
        <Header />
        {children}
      </body>
    </html>
  )
}
