#include <stdint.h>
#include "LovyanGFX.hpp"  // for PROGREM

const uint8_t FRCharcount = 40;

struct CharsetTable
{
  uint16_t UTF;
  uint8_t latin;
};

const CharsetTable FRCharset[40] PROGMEM = {
  {0x00ab, 0x7f}, // 'LEFT-POINTING DOUBLE ANGLE QUOTATION MARK'
  {0x00b0, 0x80}, // 'DEGREE SIGN'
  {0x00bb, 0x81}, // 'RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK'
  {0x00c0, 0x82}, // 'LATIN CAPITAL LETTER A WITH GRAVE'
  {0x00c2, 0x83}, // 'LATIN CAPITAL LETTER A WITH CIRCUMFLEX'
  {0x00c4, 0x84}, // 'LATIN CAPITAL LETTER A WITH DIAERESIS'
  {0x00c6, 0x85}, // 'LATIN CAPITAL LETTER AE'
  {0x00c7, 0x86}, // 'LATIN CAPITAL LETTER C WITH CEDILLA'
  {0x00c8, 0x87}, // 'LATIN CAPITAL LETTER E WITH GRAVE'
  {0x00c9, 0x88}, // 'LATIN CAPITAL LETTER E WITH ACUTE'
  {0x00ca, 0x89}, // 'LATIN CAPITAL LETTER E WITH CIRCUMFLEX'
  {0x00cb, 0x8a}, // 'LATIN CAPITAL LETTER E WITH DIAERESIS'
  {0x00ce, 0x8b}, // 'LATIN CAPITAL LETTER I WITH CIRCUMFLEX'
  {0x00cf, 0x8c}, // 'LATIN CAPITAL LETTER I WITH DIAERESIS'
  {0x00d4, 0x8d}, // 'LATIN CAPITAL LETTER O WITH CIRCUMFLEX'
  {0x00d6, 0x8e}, // 'LATIN CAPITAL LETTER O WITH DIAERESIS'
  {0x00d9, 0x8f}, // 'LATIN CAPITAL LETTER U WITH GRAVE'
  {0x00db, 0x90}, // 'LATIN CAPITAL LETTER U WITH CIRCUMFLEX'
  {0x00dc, 0x91}, // 'LATIN CAPITAL LETTER U WITH DIAERESIS'
  {0x00e0, 0x92}, // 'LATIN SMALL LETTER A WITH GRAVE'
  {0x00e2, 0x93}, // 'LATIN SMALL LETTER A WITH CIRCUMFLEX'
  {0x00e4, 0x94}, // 'LATIN SMALL LETTER A WITH DIAERESIS'
  {0x00e6, 0x95}, // 'LATIN SMALL LETTER AE'
  {0x00e7, 0x96}, // 'LATIN SMALL LETTER C WITH CEDILLA'
  {0x00e8, 0x97}, // 'LATIN SMALL LETTER E WITH GRAVE' <--
  {0x00e9, 0x98}, // 'LATIN SMALL LETTER E WITH ACUTE'
  {0x00ea, 0x99}, // 'LATIN SMALL LETTER E WITH CIRCUMFLEX'
  {0x00eb, 0x9a}, // 'LATIN SMALL LETTER E WITH DIAERESIS'
  {0x00ee, 0x9b}, // 'LATIN SMALL LETTER I WITH CIRCUMFLEX'
  {0x00ef, 0x9c}, // 'LATIN SMALL LETTER I WITH DIAERESIS'
  {0x00f4, 0x9d}, // 'LATIN SMALL LETTER O WITH CIRCUMFLEX'
  {0x00f6, 0x9e}, // 'LATIN SMALL LETTER O WITH DIAERESIS'
  {0x00f9, 0x9f}, // 'LATIN SMALL LETTER U WITH GRAVE'
  {0x00fb, 0xa0}, // 'LATIN SMALL LETTER U WITH CIRCUMFLEX'
  {0x00fc, 0xa1}, // 'LATIN SMALL LETTER U WITH DIAERESIS'
  {0x00ff, 0xa2}, // 'LATIN SMALL LETTER Y WITH DIAERESIS'
  {0x0152, 0xa3}, // 'LATIN CAPITAL LIGATURE OE'
  {0x0153, 0xa4}, // 'LATIN SMALL LIGATURE OE'
  {0x0178, 0xa5}, // 'LATIN CAPITAL LETTER Y WITH DIAERESIS'
  {0x20ac, 0xa6} // 'EURO SIGN'
};