"""
Solution to Project Euler problem 2
https://projecteuler.net/

    Even Fibonacci numbers

    Each new term in the Fibonacci sequence is generated by adding the previous two terms. By starting with 1 and 2, the first 10 terms will be:
    1, 2, 3, 5, 8, 13, 21, 34, 55, 89, ...
    By considering the terms in the Fibonacci sequence whose values do not exceed four million, find the sum of the even-valued terms.

(c) Paul Choi 2021
"""
from utils import format_solution_output


def run():
    res, sum_of_evens = 0, 0
    a = 1
    b = 1

    while res < 4000000:
        a = b
        b = res
        res = a + b

        if res % 2 == 0:
            sum_of_evens += res

    return sum_of_evens


if __name__ == "__main__":
    format_solution_output(2, run())
