unit PSQLToolsTest;
{$I PSQLDAC.inc}
{$IFDEF DUNITX}
  {$M+}
{$ENDIF}
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  PSQLAccess, PSQLDbTables, PSQLTypes, SysUtils, PSQLTools,
  {$IFNDEF DUNITX}
  TestFramework, TestExtensions, TestHelper
  {$ELSE}
  DUnitX.TestFramework, TestXHelper
  {$ENDIF};

type

  {$IFDEF DUNITX}[TestFixture]{$ENDIF}
  TestTPSQLTools = class({$IFNDEF DUNITX}TTestCase{$ELSE}TTestXCase{$ENDIF})
  public
    {$IFNDEF DUNITX}
    procedure SetUp; override;
    procedure TearDown; override;
    {$ELSE}
    [Setup]
    procedure SetUp;
    [TearDown]
    procedure TearDown;
    {$ENDIF}
  published
    procedure TestAnalyze;
    procedure TestVacuum;
    procedure TestReindex;
    procedure TestCluster;
    procedure TestException;
    {$IFDEF DUNITX}
    [SetupFixture]
    procedure SetupFixture;
    [TearDownFixture]
    procedure TearDownFixture;
    {$ENDIF}
  end;

var
  Tools: TPSQLTools;

implementation

procedure InternalSetUp;
begin
end;

procedure InternalTearDown;
begin
{$IFNDEF NEXTGEN}
  Tools.Free;
{$ELSE}
  Tools.DisposeOf;
{$ENDIF}
end;

procedure TestTPSQLTools.SetUp;
begin
  Tools := TPSQLTools.Create(nil);
  Tools.Database := TestDBSetup.Database;
  Tools.Verbose := True;
  Tools.TableName := 'tools_test_case_table';
end;

{$IFDEF DUNITX}
procedure TestTPSQLTools.SetupFixture;
begin
  InternalSetUp;
end;

procedure TestTPSQLTools.TearDownFixture;
begin
end;
{$ENDIF}

procedure TestTPSQLTools.TearDown;
begin
  Tools.Free;
end;

procedure TestTPSQLTools.TestAnalyze;
begin
  Tools.Operation := poANALYZE;
  Check(Tools.Execute, 'Cannot execute ANALYZE');
end;

procedure TestTPSQLTools.TestCluster;
begin
  Tools.Operation := poCLUSTER;
  Tools.IndexName := 'rfield_idx';
  Check(Tools.Execute, 'Cannot execute CLUSTER INDEX');
  Tools.IndexName := '';
  Check(Tools.Execute, 'Cannot execute CLUSTER TABLE');
  Tools.TableName := '';
  Check(Tools.Execute, 'Cannot execute CLUSTER DATABASE');
end;

procedure TestTPSQLTools.TestException;
begin
  Tools.TableName := 'WRONG_TABLE_NAME';
  try
    Tools.Execute(poANALYZE);
  except
    on E: Exception do
      Check(E is EPSQLDatabaseError, 'Overloaded Execute method failed');
  end;
end;

procedure TestTPSQLTools.TestReindex;
begin
  Tools.Operation := poREINDEX;
  Tools.IndexName := 'rfield_idx';
  Check(Tools.Execute, 'Cannot execute REINDEX INDEX');
  Tools.IndexName := '';
  Check(Tools.Execute, 'Cannot execute REINDEX TABLE');
  Tools.TableName := '';
  Check(Tools.Execute, 'Cannot execute REINDEX DATABASE');
end;

procedure TestTPSQLTools.TestVacuum;
begin
  Tools.Operation := poVACUUM;
  Tools.ColumnList.CommaText := 'id,sfield,tfield';
  Tools.VacuumOptions := [voFULL, voFREEZE, voANALYZE];
  Check(Tools.Execute, 'Cannot execute VACUUM');
end;

initialization
 {$IFDEF DUNITX}
  TDUnitX.RegisterTestFixture(TestTPSQLTools);
{$ENDIF}

end.

