unit PSQLTableTest;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit 
  being tested.

}

interface

uses
  PSQLAccess, PSQLDbTables, PSQLTypes, Classes, Db,
  {$IFNDEF DUNITX}
  TestFramework, TestExtensions, TestHelper
  {$ELSE}
  DUnitX.TestFramework, TestXHelper
  {$ENDIF};

type

  {$IFDEF DUNITX}[TestFixture]{$ENDIF}
  TestTPSQLTable = class({$IFNDEF DUNITX}TTestCase{$ELSE}TTestXCase{$ENDIF})
  private
    FPSQLTable: TPSQLTable;
  public
    {$IFNDEF DUNITX}
    procedure SetUp; override;
    procedure TearDown; override;
    {$ELSE}
    [Setup]
    procedure SetUp;
    [TearDown]
    procedure TearDown;
    {$ENDIF}
    procedure TestAddIndex;
    procedure TestApplyRange;
    procedure TestCancelRange;
    procedure TestCreateTable;
    procedure TestDeleteIndex;
    procedure TestEditKey;
    procedure TestEditRangeEnd;
    procedure TestEditRangeStart;
    procedure TestEmptyTable;
    procedure TestFindNearest;
    procedure TestGetIndexNames;
    procedure TestGotoCurrent;
    procedure TestGotoKey;
    procedure TestGotoNearest;
    procedure TestSetKey;
    procedure TestSetRange;
    procedure TestSetRangeEnd;
    procedure TestSetRangeStart;
  published
    procedure TestFindKey;
    procedure TestOpenEmptyTable;
    {$IFDEF DUNITX}
    [SetupFixture]
    procedure SetupFixture;
    {$ENDIF}
  end;

implementation

procedure InternalSetUp;
begin
end;

procedure TestTPSQLTable.SetUp;
begin
  FPSQLTable := TPSQLTable.Create(nil);
  FPSQLTable.Database := TestDBSetup.Database;
end;

{$IFDEF DUNITX}
procedure TestTPSQLTable.SetupFixture;
begin
  InternalSetUp;
end;
{$ENDIF}

procedure TestTPSQLTable.TearDown;
begin
  FPSQLTable.Free;
  FPSQLTable := nil;
end;

procedure TestTPSQLTable.TestAddIndex;
var
  DescFields: string;
  Options: TIndexOptions;
  Fields: string;
  Name: string;
begin
  // TODO: Setup method call parameters
  FPSQLTable.AddIndex(Name, Fields, Options, DescFields);
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestApplyRange;
begin
  FPSQLTable.ApplyRange;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestCancelRange;
begin
  FPSQLTable.CancelRange;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestCreateTable;
begin
  FPSQLTable.CreateTable;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestDeleteIndex;
var
  Name: string;
begin
  // TODO: Setup method call parameters
  FPSQLTable.DeleteIndex(Name);
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestEditKey;
begin
  FPSQLTable.EditKey;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestEditRangeEnd;
begin
  FPSQLTable.EditRangeEnd;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestEditRangeStart;
begin
  FPSQLTable.EditRangeStart;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestEmptyTable;
begin
  FPSQLTable.EmptyTable;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestFindKey;
begin
  FPSQLTable.TableName := 'testtable';
  FPSQLTable.Open;
  FPSQLTable.IndexName := 'pk_testtable';
  Check(FPSQLTable.FindKey(['11', '21']), 'FindKey failed for two-column index');
end;

procedure TestTPSQLTable.TestFindNearest;
var
  KeyValues: array of TVarRec;
begin
  // TODO: Setup method call parameters
  FPSQLTable.FindNearest(KeyValues);
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestGetIndexNames;
var
  List: TStrings;
begin
  List := TStringList.Create;
  // TODO: Setup method call parameters
  FPSQLTable.GetIndexNames(List);
  // TODO: Validate method results
  List.Free;
end;

procedure TestTPSQLTable.TestGotoCurrent;
var
  Table: TPSQLTable;
begin
  Table := TPSQLTable.Create(nil);
  // TODO: Setup method call parameters
  FPSQLTable.GotoCurrent(Table);
  // TODO: Validate method results
  Table.Free;
end;

procedure TestTPSQLTable.TestGotoKey;
begin
  Check(FPSQLTable.GotoKey);
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestGotoNearest;
begin
  FPSQLTable.GotoNearest;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestOpenEmptyTable;
begin
  FPSQLTable.Database.Execute('CREATE TEMP TABLE IF NOT EXISTS empty_table( id int4, ss varchar, num numeric, dt timestamp)');
  FPSQLTable.TableName := 'empty_table';
  FPSQLTable.Open;
  FPSQLTable.Last;
  FPSQLTable.Refresh;
end;

procedure TestTPSQLTable.TestSetKey;
begin
  FPSQLTable.SetKey;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestSetRange;
var
  EndValues:  array of TVarRec;
  StartValues:  array of TVarRec;
begin
  // TODO: Setup method call parameters
  FPSQLTable.SetRange(StartValues, EndValues);
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestSetRangeEnd;
begin
  FPSQLTable.SetRangeEnd;
  // TODO: Validate method results
end;

procedure TestTPSQLTable.TestSetRangeStart;
begin
  FPSQLTable.SetRangeStart;
  // TODO: Validate method results
end;

initialization
{$IFDEF DUNITX}
  TDUnitX.RegisterTestFixture(TestTPSQLTable);
{$ENDIF}
end.

