# Coding Ninjas Full Stack Web Development

This repository contains all the resources and materials for the Coding Ninjas Full Stack Web Development course. The course is designed for students who are new to web development and want to learn how to build dynamic, full-featured web applications. The course covers a wide range of topics in web development, including HTML, CSS, JavaScript, Node.js, Express, MongoDB, and more.

## Contents

The repository is organized into modules, each of which covers a specific topic in web development. The modules include:

- Module 1: Introduction to Web Development
- Module 2: HTML and CSS
- Module 3: JavaScript
- Module 4: Node.js and Express
- Module 5: MongoDB and Mongoose
- And more!

## Getting Started

To get started, you'll need to have a basic understanding of web development concepts and some experience with HTML and CSS. You should also have a text editor and a web browser installed on your computer.

1. Clone the repository to your local machine
    ```
    git clone https://github.com/parikshit223933/Coding-Ninjas-Full-Stack-Web-Development.git
    ```
2. Navigate to the appropriate module. Each module contains a set of notes and exercises that will help you learn the material.

3. Follow the instructions in the README file for that module to set up the development environment and run the code examples.

## Installation Instructions

1. This project requires Node.js and npm (Node Package Manager) to be installed in the system. Please check the node version by running `node -v` and npm version by running `npm -v` in the command prompt.

2. Next, you'll want to install the dependencies for the project. In the root directory of the project, run the following command:
    ```
    npm install
    ```
    This command will install all the dependencies listed in the `package.json` file.

3. Start the development server
    ```
    npm start
    ```
    This will start the development server and you can check the app running on `http://localhost:3000/`

## Prerequisites

- Basic understanding of web development concepts and some experience with HTML and CSS
- Text editor (such as Sublime Text, Atom, or Visual Studio Code)
- Web browser (such as Google Chrome, Firefox, or Safari)
- Node.js version 12 or above
- npm (Node Package Manager) version 6 or above
