BSL430.NET.GUI App
------------------
BSL430.NET.GUI App is .NET WPF app wrapping BSL430.NET functions with nice graphical interface. It is Windows only, so if you run Linux, you should check out [Console App](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Console-App). For more details please read docs here at wiki [BSL430.NET Library](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Library) or [FirmwareTools](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.FirmwareTools.Library), especially [**Device Set Up**](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Library#Device-Set-Up), because each time you init communication with MCU, you need to correctly set device up (*MCU*, *InvokeMechanism*, *BaudRate*, *Password*). App functionality is split into *Views*: **Upload**, **Download**, **Erase** and **FW Tools**. There are also some nice *features* included, like integration with Windows Explorer (Shell) in form of **shell ext association** (firmware files double click open), or **shell extension** (right click menu). App **settings** are managed from tray icon.

```
Note: This app packs all (un)managed libraries into single assembly.
      User settings, logs, log backup and exe shadow copy are stored at: 
      C:\Users\<NAME>\AppData\Local\Jakub Parez\BSL430.NET.WPF\
```
- [System Requirements](#System-Requirements)
- [Views](#Views)
  - [Scan](#Scan)
  - [**Upload**](#Upload)
  - [**Download**](#Download)
  - [**Erase**](#Erase)
  - [XML Log](#Erase)
  - [**Firmware Tools**](#Firmware-Tools)
    - [Convert](#Convert)
    - [Combine](#Combine)
    - [Validate](#Validate)
    - [Hex Edit](#Hex-Edit)
    - [Get Password](#Get-Password)
  - [About](#About)
- [Features](#Features)
  - [**Tray Icon Settings**](#Tray-Icon-Settings)
  - [**Shell Integration**](#Shell-Integration)
    - [Shell Association](#Shell-Association)
    - [Shell Extension](#Shell-Extension)

System Requirements
-------------------
BSL430.NET.WPF is built using **.NET Framework 4.6.1**. NET Core 3 (WPF) support is only experimental and would be interesting after .NET Core and WPF will go out better than today (.NET Core 3.0 Preview is first to implement WPF but not fully and without problems). Each architecture (x86, amd64) has its own build as unmanaged libraries are involved, but there are no significant differences when using x86 or amd64 build.
- Framework
  - .NET Framework 4.6.1
  - *.NET Core 3.0 (experimental)*
- OS
  - Windows 7, 8, 8.1, 10
    - x86
    - amd64

Views
-----
### Scan
Scan for available devices. It is important to have drivers installed for using FTDI devices (FTD2XX). If you dont want to or cant install them, please use libftdi. Other device types are USB or Serial (COM).

![Scan1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_scan2.png)

### Upload
Uploading code to micro is the most common way how use this library. First device needs to be set up (MCU family, Invoke Method, Baud Rate) according to [docs](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Library#Device-Set-Up). Then You need to select **firmware file path** in formats Intel-HEX, TI-TXT, SREC or ELF. Password, key to unlock bootloader, is here optional, because mostly you want dont know it and also doesnt care about that data, because they are being overwriten with new one. However there are two use cases, when good password matters. First, you already uploaded main firmware to your device and now you want to upload only Info A memory (user settings, constants..). In this case you dont want to Erase MCU first, so you need to supply valid BSL password. Secondly, read warning below:
```
Warning: Password is optional for Download, but if wrong password is entered, 
         MCU takes it as an attack and erase all memory, executing Mass Erase.
         If modern 5xx/6xx micro is used, code is just wiped, but if old
         1xx/2xx/4xx one is used and LOCK A bit is not set, also Info A mem
         is wiped, with factory calibration data. So please be careful.
```
![Upload1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_upload.png)
![Upload2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_upload2_dark.png)

### Download
Downloading code from micro is useful only sometimes, like when solving a problem with some remote device. First device needs to be set up (MCU family, Invoke Method, Baud Rate) according to [docs](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Library#Device-Set-Up). Then You need to select firmware destination path and output format. Also **Start Addr** and **Byte Size** settings are crucial, which are the address of the very first data node wanted, and the count of bytes downloaded. You can toggle the button **K/1** and switch between scaler of download range. If *1* is set, values are in standard decimal units 1:1, if *K* is set, values are multiplied by 1024. Password is key to unlock bootloader and needs to be set correctly, otherwise bad things happen. Read below.
```
Warning: Password is needed for Download. If wrong password is entered, MCU 
         takes it as an attack and erase all memory, executing Mass Erase.
         If modern 5xx/6xx micro is used, code is just wiped, but if old
         1xx/2xx/4xx one is used and LOCK A bit is not set, also Info A mem
         is wiped, with factory calibration data. So please be careful.
```
![Download1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_download2.png)
![Download2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_download_dark.png)

### Erase
Erasing micro is also sometimes needed and doesnt require any input data, nor it cares about set Baud Rate value. Just call this method and quickly all memory is erased. Device needs to be set up first (MCU family, Invoke Method, Baud Rate) according to [docs](https://github.com/parezj/BSL430.NET/wiki/BSL430.NET.Library#Device-Set-Up).
```
Warning: If old 1xx/2xx/4xx MCU is used and LOCK A bit is not set **DONT** do it!
         Info A memory will be erased as well, with factory calibration data.
         This will also happen when incorrect password entered, so be careful.
         Or just dont use old micros and buy a new better one :)
```
![Erase1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_erase.png)
![Erase2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_erase2_dark.png)

### XML Log
All main operations are logged into XML file located at *C:\Users\<NAME>\AppData\Local\Jakub Parez\BSL430.NET.WPF\*. You can open this log file by embedded explorer (AvalonEdit) by clicking *XML Log* or you cant just simply navigate into that folder by file explorer. If log file grows larger than 2MB, after app start you will be notified of moving this file to backup folder at same location and creating a new blank one.

![Log1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_log.png)
![Log2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_log_dark.png)

### Firmware Tools
This view implements all main functionality of sub-package **BSL430.NET.FirmwareTools**. These functions are universal except of *Get Password*, which is MSP430 specific. First there needs to be chosen (first) firmware file path.
![FwTools1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools.png)
![FwTools2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_dark.png)

#### Convert
Convert firmware TI-TXT, Intel-HEX or ELF format (auto detected) to firmware in TI-TXT, Intel-HEX or SREC format. There needs to be set **output firmware format** by combo-box and after clicking *Convert* button dialog windows opens. There is set **output file path** and optional check-box **FillFF** can be set (fill missing addr nodes with 0xFF and return monolithic piece of code). LineLength can be set via Tray Icon settings and it defines amount of data bytes per one text row. Default values are set (TI-TXT = 16, Intel-HEX = 32, SREC = 32).

![Convert](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_convert.png)

#### Combine
Combines two firmware files into single one with format specified. Usually, main firmware and EEPROM file is done this way, or main firmware and Info A flash content is merged. There needs to be set **output firmware format** by combo-box and after clicking *Convert* button dialog windows opens. There is set **second firmware path** and **output file path** and optional check-box **FillFF** can be set (fill missing addr nodes with 0xFF and return monolithic piece of code). LineLength can be set via Tray Icon settings and it defines amount of data bytes per one text row. Default values are set (TI-TXT = 16, Intel-HEX = 32, SREC = 32).

![Combine](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_combine_dark.png)

#### Validate
Validate firmware file and show dialog window with specific firmware information. **Reset Vector** is MSP430 specifics, other properties are universal. **Format**, **CRC16**, **First Addres** and **Last Address** are pretty straight forward. **Code Size** is real count of bytes from file, **Full Size** is size of all (even missing 0xFF nodes) data located in MCU memory. If parse log is availabe, there is button *Show Parse Log*. If firmware is Valid, also button *Compare* is shown, providing ability to quickly compare this firmware to another.

![Validate1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_validate.png)
![Validate2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_validate_dark.png)

#### Hex Edit
If firmware is valid, opens dedicated window with hex editor (WpfHexEdit). Intel-HEX, TI-TXT and SREC can also be edited and saved, ELF is read-only. Status bar shows important things like addresses, size or scale. For save click button *Save* or close window and answer Yes in Message Box. There is also zoom feature, hold CTRL with mouse wheel.

![HexEdit1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_hex_edit.png)
![HexEdit2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_hex_edit_dark.png)

#### Get Password
This is MSP430 specific property. Validate firmware file and display BSL password for Upload/Download. Password is last 16-byte (F543x-non-A only) or 32-byte (others) of IVT (FFE0-FFFF), if newer 5xx/6xx MCU is used. If MCU from older series is used (1xx/2xx/4xx), password is exactly 20-byte long. Mostly it is 32-byte. You need to specify **MCU** family first for displaying password with correct length.

![Password](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_fw_tools_password.png)

### About
This is only informational window displaying build version, github site, author name and contact and also list of packages used in this assembly.

![About1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_about.png)
![About2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_about_dark.png)

Features
--------
### Tray Icon Settings
Tray icon is located at standard Windows tray bar, usually on right sight of start bar. For making things simple, BSL430.NET user settings can be set only from there.

| Main Menu      | Sub Menu                     | Description |
|----------------|------------------------------|-------------|
| **Upload**     |                              | Open Upload View.
| **Download**   |                              | Open Download View.
| **Erase**      |                              | Open Erase View.
| **FW Tools**   |                              | Open FW Tools View.
| **BSL430.NET** |                              | Open About View.
| Settings       | **Download Size Range**      | Set slider maximum property for Download view. Tweak this according to your MCU Flash memory size. Default is 128K.
| Settings       | **FW Write Line Length**     | Defines amount of data bytes per one text row when creating firmware file. Default is AUTO -> TI-TXT = 16, Intel-HEX = 32, SREC = 32.
| Settings       | **Minimize To Tray Bar**     | If true, when app is minimized, it hides from task bar and resides only in tray bar. Useful for long running.
| Settings       | **Shell Default Action**     | Default action when either double clicked or right clicked on firmware file in windows explorer. Default is Validate.
| Settings       | **Shell File Association**   | If true, firmware file extensions -> .hex .out .elf .s .srec .s19 .eep are associated with windows explorer for double click.  Requires elevating Admin UAC rights.
| Settings       | **Shell Explorer Extension** | If true, any file right click in windows explorer opens menu with extensions and menu -> Open with BSL430.NET. Requires elevating Admin UAC rights.
| Settings       | **Reset User Settings**      | Reset user settings to factory defaults. Requires elevating Admin UAC rights.
| **Dark Mode**  |                              | Switch to dark theme, useful when running app in night or dark environment.
| **Exit**       |                              | Exit Application.

![Tray1](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_tray.png)
![Tray2](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_tray_dark.png)

### Shell Integration
#### Shell Association
This feature needs to be turned on in tray icon settings or at the first start by clicking Yes in Message Box. When turned on (requires UAC Admin elevation), double click in windows explorer opens BSL430.NET and perform default action, that is set also in tray icon settings, default is Validate firmware. Firmware file extensions involved are: **.hex .out .elf .s .srec .s19 .eep**. There is also unified logo for those files created by merging simple file and BSL430.NET logo.

![Association](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_shell_association.png)

#### Shell Extension
This feature needs to be turned on in tray icon settings or at the first start by clicking Yes in Message Box. When turned on (requires UAC Admin elevation), right click any file opens popup menu box with menu item called **Open with BSL430.NET**. After clicking this menu item default action is done. This action is set also in tray icon settings, default is Validate firmware. 

![Extension](https://raw.githubusercontent.com/parezj/BSL430.NET/master/img/screenshots/wpf_gui_shell_extensions.png)
