# Code of Conduct

> Derived from the [Python Code of Conduct](https://www.python.org/psf/conduct/)

Promptmeteo developers are open, considerate, and respectful. Behaviours that reinforce these values contribute to a positive environment, and include:

- Being open. Members of the community are open to collaboration.
- Focusing on what is best for the community. We're respectful of the processes set forth in the community, and we work within them.
- Acknowledging time and effort. We're respectful of the volunteer efforts. We're thoughtful when addressing the efforts of others, keeping in mind that often times the labor was completed simply for the good of the community.
- Being respectful of differing viewpoints and experiences. We're receptive to constructive comments and criticism, as the experiences and skill sets of other members contribute to the whole of our efforts.
- Showing empathy towards other community members. We're attentive in our communications, whether in person or online, and we're tactful when approaching differing views.
- Being considerate. 
- Being respectful. We're respectful of others, their positions, their skills, their commitments, and their efforts.
- Gracefully accepting constructive criticism. When we disagree, we are courteous in raising our issues.
- Using welcoming and inclusive language. We're accepting of all who wish to take part in our activities, fostering an environment where anyone can participate and everyone can make a difference.

## Inappropriate Behavior
Examples of unacceptable behavior by participants include:

- Harassment of any participants in any form
- Deliberate intimidation, stalking, or following
- Logging or taking screenshots of online activity for harassment purposes
- Publishing others' private information, such as a physical or electronic address, without explicit permission
- Violent threats or language directed against another person
- Incitement of violence or harassment towards any individual, including encouraging a person to commit suicide or to engage in self-harm
- Creating additional online accounts in order to harass another person or circumvent a ban
- Sexual language and imagery in online communities or in any conference venue, including talks
- Insults, put downs, or jokes that are based upon stereotypes, that are exclusionary, or that hold others up for ridicule
- Excessive swearing
- Unwelcome sexual attention or advances
- Unwelcome physical contact, including simulated physical contact (eg, textual descriptions like "hug" or "backrub") without consent or after a request to stop
- Pattern of inappropriate social contact, such as requesting/assuming inappropriate levels of intimacy with others
- Sustained disruption of online community discussions, in-person presentations, or other in-person events
- Continued one-on-one communication after requests to cease
- Other conduct that is inappropriate for a professional audience including people of many different backgrounds
- Community members asked to stop any inappropriate behavior are expected to comply immediately.

### Contact Information
If you believe that someone is violating the code of conduct, or have any other concerns, please contact a member of the [core contributors](https://github.com/paradigmadigital/Promptmeteo/graphs/contributors).


#### License
This Code of Conduct is licensed under the [Creative Commons Attribution-ShareAlike 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

#### Attributions
This Code of Conduct was forked from the example policy from the Geek Feminism wiki, created by the Ada Initiative and other volunteers, which is under a Creative Commons Zero license.