# Learn Modern AI Python

This repo is part of the [Certified Cloud Native Applied Generative AI Engineer](https://docs.google.com/document/d/15usu1hkrrRLRjcq_3nCTT-0ljEcgiC44iSdvdqrCprk/edit?usp=sharing) program. It covers the first quarter of the course work:

### AI-101: Modern AI Python Programming

The main focus in this course will be on mastering the fundamentals of Modern Python with Typing using Google Colab, the go-to language for AI and using AI to write Python Programs. We will then move to understanding the basics of GenAI and Prompt Engineering. In the end of the program we will understand the basics of Linux, Docker, VSCode, Devcontainer, and GitHub. 

![Python](top-python.webp)


## Additional Certification Program Material

[Program Podcast](https://youtu.be/ViRWA4wLI8k)

[Agentic AI Detailed Intro Presentation](https://bit.ly/4hTqT4G)

[Program Review by ChatGPT](https://chatgpt.com/share/6732a6f1-a3c4-8001-99cb-1b272c3b3881)

Read this article to understand [The AI agents stack](https://www.letta.com/blog/ai-agents-stack)

## We will following this course to get started [AI Python for Beginners](https://www.deeplearning.ai/short-courses/ai-python-for-beginners/) by Andrew Ng

## We will be using Google Colab for development:

Google Colab is a free, cloud-based Jupyter Notebook service developed by Google. It enables users to write and execute Python code through a web browser, offering seamless integration with Google Drive for easy storage and sharing of notebooks. Colab is particularly beneficial for tasks in machine learning, data analysis, and education, as it provides access to powerful computing resources, including GPUs and TPUs, without requiring any local setup. 

**Key Features of Google Colab:**

- **No Setup Required:** Users can start coding immediately without the need to install any software or manage local environments. 

- **Free Access to Computing Resources:** Colab offers free access to computing resources, including GPUs and TPUs, facilitating the execution of complex computations and machine learning models. 

- **Collaboration:** Notebooks can be easily shared and collaboratively edited, similar to Google Docs, enhancing teamwork and knowledge sharing. 

- **Integration with Google Drive:** Notebooks are stored in Google Drive, allowing for straightforward organization and access across devices. 

- **Support for Various Libraries:** Colab supports popular Python libraries such as TensorFlow, Keras, and NumPy, making it versatile for various data science and machine learning projects. 

**Recent Developments:**

Recently, Google expanded Colab's AI-powered code assistance features to all users in eligible locales, including those on free plans. These features assist in generating code from natural language prompts and provide a code-assisting chatbot to enhance programming efficiency and comprehension. 

**Getting Started with Google Colab:**

To begin using Google Colab:

1. **Access Colab:** Navigate to the [Google Colab website](https://colab.research.google.com/).

2. **Create a New Notebook:** Click on "File" > "New Notebook" to create a new Jupyter Notebook.

3. **Write and Execute Code:** Enter your Python code in the code cells and execute them to see the results.

4. **Save and Share:** Your notebooks are automatically saved in your Google Drive, and you can share them with others by clicking the "Share" button.

For more detailed information and tutorials, refer to the [Colaboratory Frequently Asked Questions](https://research.google.com/colaboratory/faq.html) and the [Colab Help Center](https://support.google.com/colab/).

Google Colab is a valuable tool for both beginners and professionals in data science and machine learning, offering an accessible platform to develop and share projects efficiently. 
