# Learn Modern Python with Type Hints

# Installation

[Install VS Code](https://code.visualstudio.com/)

[Install Python Plugin](https://marketplace.visualstudio.com/items?itemName=ms-python.python)

[Install mypy VS Code Extension](https://marketplace.visualstudio.com/items?itemName=matangover.mypy)


We will learn Modern Python from this text book: 

[Python Crash Course - Third Edition Chapters 1-10](https://www.amazon.com/Python-Crash-Course-Eric-Matthes/dp/1718502702)

There is only one issue with the book, it has been recently published but doesn't cover type hints, we have enhanced the source code for the book with type hints.

To learn type hints you may refer to this Typing Cheat Sheet while reading the book:

[Typing Cheat Sheet](https://mypy.readthedocs.io/en/stable/cheat_sheet_py3.html)

[Python Cheat Sheet for Beginners](https://www.datacamp.com/cheat-sheet/getting-started-with-python-cheat-sheet)

You will add type hints to all the code in the book and run in containers. 



### Type Hints should be used by Professional Developers

Type hints are the biggest change in the history of Python since the unification of types and classes in Python 2.2, released in 2001. However, type hints do not benefit all Python users equally. That’s why they should always be optional.

The goal of Type Hints is to help developer tools find bugs in Python codebases via static analysis, i.e., without actually running the code through tests. The main beneficiaries are professional software engineers using IDEs (Integrated Development Environments) and CI (Continuous Integration). The cost-benefit analysis that makes type hints attractive to this group does not apply to all users of Python. However, we are professional developers, therefore it is beneficial for us to adopt type hints. This Modern Python course uses Type Hints extensively. 

