# AI Python for Beginners

Leverage AI assistants to debug code, explain concepts, and enhance your learning, mirroring real-world software development practices.

You’ll learn with support from an AI chatbot that can provide you with immediate feedback, quickly fix bugs, and keep you on track while learning new skills.

https://www.deeplearning.ai/short-courses/ai-python-for-beginners/

## Google Colab Setup

We will be using Google Colab to learn Python and develop a future-proof programming skill set. Follow these simple steps to set up your environment, then move on to course_1_basics.

#### 1. Create a Folder in Google Drive:

1. Open Google Drive.
2. Create a folder called python_utils.
3. This folder will be used to store utility script you'll use throughout the course.

#### 2. Download the helper_functions.py File:

1. Download the helper_functions.py file from this step.
2. Upload the helper_functions.py file into the python_utils folder in your Google Drive.

#### 2. Mount Google Drive in Google Colab:

To access the files you upload to Google Drive, you'll need to mount your drive in Colab. Use the following code snippet to do this:

```python
from google.colab import drive
drive.mount('/content/drive')

# Change directory to where 'python_utils.py' is stored
%cd /content/drive/MyDrive/python_utils/

# Import the python_utils module
from helper_functions import *
```

#### 3. Add Gemini API key and Try the uploaded file functions

From [Google AI Studio get your API KEY](https://aistudio.google.com/app/apikey) and add a new environment variable GOOGLE_API_KEY in notebook.

Now import and try the function from uploaded file.

````
# Now you can call functions
print_llm_response("What is the capital of France?")```
````

### Course 1: Basics

- L4: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_4/Lesson_4.ipynb)

- L6: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_6/Lesson_6.ipynb)

- L7: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_7/Lesson_7.ipynb)

- L8: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_8/Lesson_8.ipynb)

- L9: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_9/Lesson_9.ipynb)

- L10: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course1_basics/Lesson_10/Lesson_10.ipynb)

### Course 2: Automating Tasks

- L1: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_1/Lesson_1.ipynb)

- L2: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_2/Lesson_2.ipynb)

- L3: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_3/Lesson_3.ipynb)

- L4: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_4/Lesson_4.ipynb)

- L5: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_5/Lesson_5.ipynb)

- L6: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_6/Lesson_6.ipynb)

- L7: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/panaversity/learn-cloud-native-modern-ai-python/blob/main/04_natural_language_programming/02_ai_python_for_beginners/course2_automating_tasks/Lesson_7/Lesson_7.ipynb)
