# PIAIC Generative-AI

Welcome to the PIAIC Generative AI course! In this course, you will delve into the fascinating world of Generative Artificial Intelligence (AI) and learn how to harness the power of various Language Model (LM) variants like ChatGPT, Llamav2, Falcon, Med-Palm2, and more. You will discover how to create intelligent applications using these models and even build your own smart knowledge bot by leveraging embedding and fine-tuning concepts.

[Qasim](https://github.com/EnggQasim) will teach this class.

[Watch the Introductory Video by Qasim](https://www.youtube.com/watch?v=A1hq4OBWSgE)

## [syllabus](https://docs.google.com/document/d/1qqUy6ZBJd1ExyK_FWJt8BY-NlAFr3suBbVYYMNQ70rs/edit)

## Description

Generative AI has gained significant attention in recent years due to its ability to create human-like text, art, music, and more. This course will equip you with the skills to effectively use langchain techniques with a variety of Language Model models. You'll learn how to make intelligent applications, automate content generation, and even construct your own knowledge bot that can answer queries and engage in meaningful conversations.

## Course Contents

### 00_Step_Reading_online_literature

Before diving into the core concepts of Generative AI, it's important to build a foundational understanding of AI. Here are some recommended resources to get you started:

1. **AI for Everyone Course**
   - Link: [AI for Everyone](https://www.deeplearning.ai/courses/ai-for-everyone/)
   - Description: This course provides a non-technical introduction to artificial intelligence, explaining key concepts and their real-world applications.

2. **Introduction to Generative AI**
   - Link: [Introduction to Generative AI](https://www.youtube.com/watch?v=G2fqAlgmoPo)
   - Description: Watch this video to gain an initial insight into what Generative AI is and how it's shaping the field of AI.

3. **ChatGPT Prompt Engineering for Developers**
   - Link: [ChatGPT Prompt Engineering for Developers](https://learn.deeplearning.ai/chatgpt-prompt-eng/)
   - Description: This resource will guide you through the process of effectively engineering prompts for ChatGPT, enabling more controlled and context-aware interactions.

## Course Objectives

By the end of this course, you will be able to:

- Understand the fundamental concepts of Generative AI and its various applications.
- Work with different Language Model variants like ChatGPT, Llamav2, Falcon, Med-Palm2, and more.
- Develop intelligent applications that leverage Generative AI for content generation and interaction.
- Implement embedding and fine-tuning techniques to build your own smart knowledge bot.
- Harness langchain strategies to enhance the performance of Language Models in various tasks.

## Getting Started

To get started with the course, make sure to explore the resources provided in the "00_Step_Reading_online_literature" section. These foundational materials will prepare you for the deeper concepts we'll be covering.

Feel free to reach out to fellow learners and instructors in our community forums if you have questions, insights, or want to discuss your progress.

Get ready to embark on an exciting journey into the world of Generative AI and discover how you can create intelligent applications and bots that can revolutionize various industries!

Let's dive in and start learning!

**Note:** This course content is subject to updates and modifications. Stay tuned for announcements and additional resources as the field of Generative AI continues to evolve.
