# Flexbox Layout CSS

## [Article on FlexBox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)

[Watch this Video to Understand flexbox](https://www.youtube.com/watch?v=tN12g5QUIqg&pp=ygUHRkxFWEJPWA%3D%3D)

[Watch this Video to implement Flexbox in tailwind](https://www.youtube.com/watch?v=X6FIydgCzzY)

[Play Frog Game to Learn Flex](https://flexboxfroggy.com)

# Flex All Remaining Functionality

We will learn Flex remaining functionality with CSS Flex using Tailwind CSS from this [CSS Flex and Grid book](https://shrutibalasa.gumroad.com/l/css-flex-and-grid).

## Learn Flex Grow by reading pages 48 to 56 and review the following working examples:

1. [Inline Subscribe Form Example 6a](https://play.tailwindcss.com/b8LjLcXE2e?size=800x600).
2. [Sticky Footer Example 6b](https://play.tailwindcss.com/rUfPS5AOiR?size=950x600).
3. [Card with Header & Footer Example 6c](https://play.tailwindcss.com/MG8HrxaBO0?size=540x600).
4. [Tabs Hover Effect Example 6d](https://play.tailwindcss.com/EnhCYS0Xht?size=840x500).
5. [Variable Width Responsive Buttons Example 6e](https://play.tailwindcss.com/pH8Ud24h3p?size=900x500).

## Learn Flex Shrink by reading pages 57 to 60 and review the following working examples:

1. [Itinerary Example 7a](https://play.tailwindcss.com/d9XiAMGTCd?size=700x500)
2. [Profile Card - Large Example 7b](https://play.tailwindcss.com/BamUVbR0aJ?size=650x500)

## Learn Flex Basis by reading pages 61 to 69 and review the following docs and working example:

[Flex Basis Official Documentation](https://tailwindcss.com/docs/flex-basis)

[Pricing Plans Example 8c](https://play.tailwindcss.com/zVmsWLf8cf?size=800x500)

## Learn Flex Shorthand Property by reading pages 70 to 76 and review the following working examples:

1. [Navigation Bar with Centered Menu Example 9a](https://play.tailwindcss.com/kwMF9NtnIn?size=1000x500)
2. [Image and Text in 2:1 Ratio Example 9b](https://play.tailwindcss.com/mBmeg6xWUO?size=950x500)

## Learn Auto Margin by reading pages 77 to 79 and review the following working examples:

1. [Notifications Menu Item Example 10a](https://play.tailwindcss.com/4608SM16Cm?size=700x400)
2. [Footer with Multiple Columns Example 10b](https://play.tailwindcss.com/FF3sACeN78?size=1000x500)

## Learn Order by reading pages 80 to 82 and review the following working examples:

[Responsive Navigation Bar Example 11a](https://play.tailwindcss.com/GRFjaZGlYt?size=400x500)

## Learn Align Self by reading pages 83 to 86 and review the following working examples:

1. [Product Display Example 12a](https://play.tailwindcss.com/bfAKatifXF?size=800x600)
2. [Profile with Rating Example 12b](https://play.tailwindcss.com/fH8iy7Avop?size=600x400)

## Learn Align Content by reading pages 87 to 89 and review the following working examples:

[Full Page Testimonials Section Example 13a](https://play.tailwindcss.com/oeSZfHWwNC?size=1100x800)

## Learn Inline Flex by reading pages 90 to 92 and review the following working examples:

[Social Media Icons Example 14a](https://play.tailwindcss.com/IuyXJ1p4ma?size=500x400)

## Comprehensive Examples for Flexbox

1. [Article Preview Example 15a](https://play.tailwindcss.com/Cq9WzaPGpv?size=900x700)
2. [Fitness Report Example 15b](https://play.tailwindcss.com/FS3prtD4ZH?size=900x700)
3. [Tweet Example 15c](https://play.tailwindcss.com/l0fEkRPp5A?size=750x500)
