# Hello World with Next.js 13 and Tailwind CSS

[getting started with Next.js 13](https://nextjs.org/docs) and read [installing Tailwind CSS with Next.js 13](https://nextjs.org/docs/app/building-your-application/styling/tailwind-css)is a utility-first CSS framework that works exceptionally well with Next.js.

## Setup

First, read [getting started with Next.js 13](https://nextjs.org/docs) and read [installing Tailwind CSS with Next.js 13](https://nextjs.org/docs/app/building-your-application/styling/tailwind-css):

```bash
#Terminal

npx create-next-app@latest
```

You just need to select Yes when Next.js ask you to add tailwind

[Follow the Official Docs of using Tailwind CSS with Next.js 13](https://beta.nextjs.org/docs/styling/tailwind-css)

You will be getting errors in app/global.css file. Read [How to fix Unknown at rule `@tailwindcss(unknownAtRules)` in VS Code](https://flaviocopes.com/fix-unknown-at-rule-tailwind/) to correct this.

[Install Tailwind CSS Intellisense Extension in VSCode](https://tailwindcss.com/docs/editor-setup#intelli-sense-for-vs-code)




## Installing Tailwind

Install the Tailwind CSS packages and run the init command to generate both the tailwind.config.js and postcss.config.js files:

```bash
#Terminal

npm install -D tailwindcss postcss autoprefixer
```
```bash
#Terminal

npx tailwindcss init -p
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

[API routes](https://nextjs.org/docs/api-routes/introduction) can be accessed on [http://localhost:3000/api/hello](http://localhost:3000/api/hello). This endpoint can be edited in `pages/api/hello.ts`.

The `pages/api` directory is mapped to `/api/*`. Files in this directory are treated as [API routes](https://nextjs.org/docs/api-routes/introduction) instead of React pages.

## Configuring Tailwind

Inside tailwind.config.js, add paths to the files that will use Tailwind CSS class names:

```bash
#tailwind.config.js

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './app/**/*.{js,ts,jsx,tsx,mdx}', // Note the addition of the `app` directory.
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
 
    // Or if using `src` directory:
    './src/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {},
  },
  plugins: [],
}
```


You do not need to modify postcss.config.js.


## Importing Styles

Add the [Tailwind CSS directives](https://tailwindcss.com/docs/functions-and-directives#directives) that Tailwind will use to inject its generated styles to a [Global Stylesheet](https://nextjs.org/docs/app/building-your-application/styling/css-modules#global-styles)  in your application, for example:  from the creators of Next.js.


```bash
#app/globals.css

@tailwind base;
@tailwind components;
@tailwind utilities;
```


Inside the [root layout](https://nextjs.org/docs/app/building-your-application/routing/pages-and-layouts#root-layout-required)(app/layout.tsx), import the globals.css stylesheet to apply the styles to every route in your application.

```bash
#app/layout.tsx

import type { Metadata } from 'next'
 
// These styles apply to every route in the application
import './globals.css'
 
export const metadata: Metadata = {
  title: 'Create Next App',
  description: 'Generated by create next app',
}
 
export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body>{children}</body>
    </html>
  )
}
```


## Using Classes

After installing Tailwind CSS and adding the global styles, you can use Tailwind's utility classes in your application.

```bash
#app/page.tsx

export default function Page() {
  return <h1 className="text-3xl font-bold underline">Hello, Next.js!</h1>
}
```

## Usage with Turbopack

As of Next.js 13.1, Tailwind CSS and PostCSS are supported with [Turbopack](https://turbo.build/pack/docs/features/css#tailwind-css).



Now, run the development server:

```bash
#Terminal

npm run dev
```


This is a [Next.js](https://nextjs.org/) project bootstrapped with [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app).

## Getting Started

First, run the development server:

```bash
#Terminal

npm run dev

```bash
#Terminal

yarn dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

[API routes](https://nextjs.org/docs/api-routes/introduction) can be accessed on [http://localhost:3000/api/hello](http://localhost:3000/api/hello). This endpoint can be edited in `pages/api/hello.ts`.

The `pages/api` directory is mapped to `/api/*`. Files in this directory are treated as [API routes](https://nextjs.org/docs/api-routes/introduction) instead of React pages.

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js/) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/deployment) for more details.
