# Learn Modern Web Development in Baby Steps

The stack used in this learning repo, it is a mixture of [Jamstack](https://jamstack.org/) and [T3](https://create.t3.gg/) Stacks:
[TypeScript](https://www.typescriptlang.org/),
[Next.js](https://nextjs.org/),
[Chakra UI](https://chakra-ui.com/),
[tRPC](https://trpc.io/),
[Prisma](https://www.prisma.io/), and
[Strapi](https://strapi.io/)

This repo is part of the [Certified Web 3.0 and Metaverse Developer Training Program](https://www.panaverse.co/)

Before start learning from this repo, learn TypeScript by doing these [TypeScript Node.js Projects](https://github.com/panacloud-modern-global-apps/chakra-nextjs-projects)

After completing this repo you should move to these specialized Web 3 learning repos:

[Next Dapps Learning Repo](https://github.com/panacloud-modern-global-apps/dapps-nextjs)

[Smart Contract Development Repo](https://github.com/panacloud-modern-global-apps/defi-dapps-solidity-smart-contracts)

Learn Chakra UI by doing Projects:

[Chakra UI Next Projects Repo](https://github.com/panacloud-modern-global-apps/chakra-nextjs-projects)

### Read these articles before starting the course: 

[Vercel, Netlify, and the new era of serverless PaaS](https://www.infoworld.com/article/3650751/vercel-netlify-and-the-new-era-of-serverless-paas.html)

[How Next.js Became a Top Jamstack Framework](https://www.netlify.com/blog/2021/06/14/how-next.js-became-a-top-jamstack-framework/)

[Predictions for the Jamstack in 2022](https://thenewstack.io/predictions-for-the-jamstack-in-2022/)

[Jamstack agency founder on the rise of Next.js and Vercel](https://sacra.com/research/jamstack-agency-founder-nextjs-vercel/)

[Exploring Headless CMS](https://blog.tarkalabs.com/exploring-headless-cms-f94466b765a2)

In this course repo we will learn Web 2.0 cloud development using the latest state of the art stack. Using this stack you will be able to develop SaaS applications that scale instantly to support even the most demanding applications, while at the same time delivering up to 90% cost savings. This stack is ideal for a broad set of applications. For example, enterprises that have hundreds of thousands of applications, or software as a service (SaaS) vendors that have multi-tenant environments with hundreds or thousands of databases, can use this stack across the entire enterprise. This stack also provides the foundations for developing Web 3.0 applications and Metaverse experiences.

The Web 2.0 full stack applicatios are build using these technologies:

1. [Typescript Programming Language for Front-end and Backend Development](https://www.typescriptlang.org/)
2. [Visual Studio Code Editor](https://code.visualstudio.com/)
3. [Front-end Web 2.0 Development Using Next.js](https://nextjs.org/)

This Web 2.0 stack can be easily extended to develop Web 3.0 Dapps using these technologies:

### [Solidity Learning Repo](https://github.com/panacloud-modern-global-apps/defi-dapps-solidity-smart-contracts)

### [Dapp using Next.js Learning Repo](https://github.com/panacloud-modern-global-apps/dapps-nextjs)

1. [Ethereum Blockchain](https://ethereum.org/en/)
2. [Solidity Smart Contract Programming Language](https://docs.soliditylang.org/)
3. [OpenZepllin Smart Contracts](https://www.openzeppelin.com/contracts)
4. [Hardhat Ethereum Development Envirnoment](https://hardhat.org/)
5. [Ethers.js](https://docs.ethers.io/v5/)
6. [Metamask Wallet](https://metamask.io/)
7. [Alchemy](https://www.alchemy.com/)
8. [The Graph](https://thegraph.com/en/)
9. [Chainlink](https://chain.link/)
10. Panacloud Panaweb Web 3 Framework (Under development)

For more details check out the [Panacloud Web 3 Learning Repo](https://github.com/panacloud-modern-global-apps/defi-dapps-solidity-smart-contracts)

The Web 2.0 and Web 3.0 stacks can easily be extended to develop Metaverse experiences. The backend will remain more less the same, the front-end will move towards 3D from 2D using [Web Technologies](https://github.com/panaverse/metaverse-web):

1. [Three.js](https://threejs.org/)
2. [WebGPU](https://developer.chrome.com/en/docs/web-platform/webgpu/)
3. [WebXR](https://immersiveweb.dev/)


