# Learn Modern Web Development using Next.js 13 in Baby Steps

[Must Read: Web Development in 2023: JavaScript Still Rules, AI Emerges](https://thenewstack.io/web-development-in-2023-javascript-still-rules-ai-emerges/)

Next.js Conf Keynote Announcing Version 13 :

[<img src="next13.png" width="75%">](https://www.youtube.com/watch?v=NiknNI_0J48 "Keynote Next.js 13")

[The Future of the Web: From Cloud to Edge](https://www.youtube.com/watch?v=HlXLVb3QCvQ)

### [Next.js 13 Docs](https://nextjs.org/docs)

Before going forward check out this [directory of headless ecommerce stores that excel at both Design and Performance]. Also check out the [tools they are using](https://theheadlessclub.com/tools)

The stack used in this learning repo, it is a mixture of [Jamstack](https://jamstack.org/) and [T3](https://create.t3.gg/) Stacks:
[TypeScript](https://www.typescriptlang.org/),
[Next.js 13](https://nextjs.org/blog/next-13),
[Chakra UI](https://chakra-ui.com/),
[tRPC](https://trpc.io/),
[Prisma](https://www.prisma.io/),
[Strapi](https://strapi.io/),
[CockroachDB serverless](https://www.cockroachlabs.com/blog/announcing-cockroachdb-serverless/) (SQL), and [MongoDB Atlas](https://www.mongodb.com/atlas/database) (NoSQL).

This repo is part of the [Certified Web 3.0 and Metaverse Developer Training Program](https://www.panaverse.co/)

Before start learning from this repo, [learn TypeScript](https://github.com/panacloud-modern-global-apps/learn-typescript) and by doing these [TypeScript Node.js Projects](https://github.com/panacloud-modern-global-apps/chakra-nextjs-projects)

[Checkout the Practice Problems for Next.js 13](https://www.practiceprobs.com/problemsets/nextjs/dunder-mifflin/)

[Step By Step Guide To Full Stack Web Development | Next.js13 Tailwind Prisma Postgresql Typescript](https://www.youtube.com/watch?v=gxkwMm_j850)

After completing this repo you should move to these specialized Web 3 learning repos:

[Next Dapps Learning Repo](https://github.com/panacloud-modern-global-apps/dapps-nextjs)

[Smart Contract Development Repo](https://github.com/panacloud-modern-global-apps/defi-dapps-solidity-smart-contracts)

Learn Chakra UI by doing Projects:

[Chakra UI Next Projects Repo](https://github.com/panacloud-modern-global-apps/chakra-nextjs-projects)
