# Full Stack Next.js E-Commerce

The Hackathon challenge:

1. Build out the project given the [Live Site](https://full-stack-ecommerce-clothing-web.vercel.app/) using Next.js 13.5+ Tailwind CSS, and Shadcn UI
2. Implementing cart functionality using Vercel Postgres SQL and Drizzle ORM
3. Connecting to Sanity as back end CMS with all the product Data
4. Connecting Stripe APIs to power online payment processing for e-commerce
5. Use React-hot-toast library to adds beautiful notifications
6. Use Icons from Lucid (default from Shadcn-UI)
7. [Stripe Test Credit Cards](https://stripe.com/docs/testing)

Note: We are using Sanity in order to support [Visual Editing](https://www.sanity.io/docs/vercel-visual-editing). You can learn more about visual editing by reading this [blog post](https://www.sanity.io/blog/visual-editing-sanity-vercel).

## Starting Template for the Hackathon

Khubaib from Peshawar has build this template for Hackathon one which uses ShadCn-UI. We will use this foundation Template in Karachi, Lahore, Islamabad and Peshawar:

https://github.com/mkdeveloper/Hackathon-with-shadcn-ui

## Advanced Features

Once implementing the above basic functionality, you will add user signin and signup fuctionality i.e. and user management module. In addition, you will add a admin panel from where the admin can do Order Fulfillment, Manage Inventory, etc.

References:

[Shadcn UI Learning Steps](https://github.com/panaverse/learn-nextjs/tree/main/step07_styling/tailwindCSS/step12_shadcn_ui/)

[Sanity Learning Steps](https://github.com/panaverse/learn-nextjs/tree/main/step09_headless_cms/sanity)
