# Online Market Place

Build a Online marketplace using Nextjs 13 App Router with server components, parallel and intercepting routes as well as Drizzle ORM.

Online marketplace allowing users to purchase products as well as sign up and list their own products for sale. Users can create a seller profile, manage products and collect payment.

Key features:

1. Intercepted routes (with parallel routing) on new product creation in admin
2. Using React Server Components for data queries with Drizzle ORM
3. Using UploadThing for typesafe file uploads (e.g., product images)
4. User authentication with Clerk

[The Demo](https://onestopshop.jackblatch.com/)

[The code for the project](https://github.com/jackblatch/OneStopShop) is available please donot copy just use it to learn.

Note: Please use Vercel Postgres as your Database

References:

[Best UI kit for Next.js 13 | shadcn ui tutorial](https://www.youtube.com/watch?v=-UE_lWgVpes)

[A Next.js 13 template for building apps with Radix UI and Tailwind CSS](https://github.com/shadcn/next-template)

[NextJS 13 UI Game Changer: The Library for Faster, Better Development](https://www.youtube.com/watch?v=DeLHGl936Fo)

[Integrate Next.js and Storybook](https://storybook.js.org/recipes/next/)

[Integrate Next.js and Storybook automatically](https://storybook.js.org/blog/integrate-nextjs-and-storybook-automatically/)