<?php

/**
 * PageCarton
 *
 * LICENSE
 *
 * @category   PageCarton
 * @package    Ayoola_Object_PageWidget_Abstract
 * @copyright  Copyright (c) 2019 PageCarton (http://www.pagecarton.org)
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @version    $Id: Abstract.php Wednesday 22nd of May 2019 09:36AM ayoola@ayoo.la $
 */

/**
 * @see PageCarton_Widget
 */


class Ayoola_Object_PageWidget_Abstract extends PageCarton_Widget
{
	
    /**
     * Identifier for the column to edit
     * 
     * @var array
     */
	protected $_identifierKeys = array( 'pagewidget_id' );
 	
    /**
     * The column name of the primary key
     *
     * @var string
     */
	protected $_idColumn = 'pagewidget_id';
	
    /**
     * Identifier for the column to edit
     * 
     * @var string
     */
	protected $_tableClass = 'Ayoola_Object_PageWidget';
	
    /**
     * Access level for player. Defaults to everyone
     *
     * @var boolean
     */
	protected static $_accessLevel = array( 99, 98 );


    /**
     * creates the form for creating and editing page
     * 
     * param string The Value of the Submit Button
     * param string Value of the Legend
     * param array Default Values
     */
	public function createForm( $submitValue = null, $legend = null, Array $values = null )  
    {
		//	Form to create a new page
        $form = new Ayoola_Form( array( 'name' => $this->getObjectName(), 'data-not-playable' => true ) );
		$form->submitValue = $submitValue ;
//		$form->oneFieldSetAtATime = true;

		$fieldset = new Ayoola_Form_Element;

        if( $code = $values['parameters']['content'] ? : $values['parameters']['codes'] )
        {
            $code = Ayoola_Page_Editor_Text::oldWidgetConvert( $code, $values['parameters'] );
        }
        else
        {
            $code = 
'<widget>
    <script type="application/json">
    ' . json_encode( $values['parameters'] ) . '
    </script>
</widget>
';
            
        }

        $fieldset->addElement( array( 'name' => 'class_name', 'type' => 'InputText', 'value' => @$values['class_name'] ) );        
        $fieldset->addElement( array( 'name' => 'parameters', 'type' => 'TextArea', 'value' => json_encode( $values['parameters'] ) ) );       
        $fieldset->addElement( array( 'name' => 'html_embed_code', 'type' => 'TextArea', 'value' => $code ) );       
        $fieldset->addElement( array( 'name' => 'widget_name', 'type' => 'InputText', 'value' => @$values['widget_name'] ) ); 
        $fieldset->addElement( array( 'name' => 'url', 'type' => 'InputText', 'value' => @$values['url'] ) ); 
        $fieldset->addElement( array( 'name' => 'section_name', 'type' => 'InputText', 'value' => @$values['section_name'] ) ); 

		$fieldset->addLegend( $legend );
		$form->addFieldset( $fieldset );   
		$this->setForm( $form );
    } 

	// END OF CLASS
}
