// Code generated by oto; DO NOT EDIT.

// Client provides access to remote services.
export class Client {
	// host points to the Firesearch instance.
	public host: string = ''
	// apiKey is the API key to access the services.
	// This should only be used for backend to backend communication,
	// secret keys should never find their way into the browser.
	public apiKey: string = ''
	// fetch is the method to use to access remote
	// services.
	public fetch: any = null
	constructor(host: string) {
		this.host = host
	}
}


// AccessKeyService provides keys needed to perform searches.
export class AccessKeyService {
	constructor(readonly client: Client) {}
	
// GenerateKey generates a key for an index path prefix to enable searches. The key
// expires after 24 hours.
	async generateKey(generateKeyRequest?: GenerateKeyRequest): Promise<GenerateKeyResponse> {
		if (generateKeyRequest == null) {
			generateKeyRequest = new GenerateKeyRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AccessKeyService.GenerateKey: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AccessKeyService.GenerateKey', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(generateKeyRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AccessKeyService.GenerateKey: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new GenerateKeyResponse(json);
		})
	}
	
}

// AutocompleteService provides the ability to create and manage autocomplete
// indexes, as well as populate them with data, and perform lookups.
export class AutocompleteService {
	constructor(readonly client: Client) {}
	
// Complete performs a search on an AutocompleteIndex.
	async complete(completeRequest?: CompleteRequest): Promise<CompleteResponse> {
		if (completeRequest == null) {
			completeRequest = new CompleteRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.Complete: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.Complete', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(completeRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.Complete: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new CompleteResponse(json);
		})
	}
	
// CreateIndex creates a new index.
	async createIndex(createAutocompleteIndexRequest?: CreateAutocompleteIndexRequest): Promise<CreateAutocompleteIndexResponse> {
		if (createAutocompleteIndexRequest == null) {
			createAutocompleteIndexRequest = new CreateAutocompleteIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.CreateIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.CreateIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(createAutocompleteIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.CreateIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new CreateAutocompleteIndexResponse(json);
		})
	}
	
// DeleteDoc removes a document from an AutocompleteIndex. Once deleted, it will
// stop appearing in search results.
	async deleteDoc(deleteAutocompleteDocRequest?: DeleteAutocompleteDocRequest): Promise<DeleteAutocompleteDocResponse> {
		if (deleteAutocompleteDocRequest == null) {
			deleteAutocompleteDocRequest = new DeleteAutocompleteDocRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.DeleteDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.DeleteDoc', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(deleteAutocompleteDocRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.DeleteDoc: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new DeleteAutocompleteDocResponse(json);
		})
	}
	
// DeleteIndex deletes the AutocompleteIndex. All index data, as well as any
// metadata about this AutocompleteIndex will be completely deleted.
	async deleteIndex(deleteAutocompleteIndexRequest?: DeleteAutocompleteIndexRequest): Promise<DeleteAutocompleteIndexResponse> {
		if (deleteAutocompleteIndexRequest == null) {
			deleteAutocompleteIndexRequest = new DeleteAutocompleteIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.DeleteIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.DeleteIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(deleteAutocompleteIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.DeleteIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new DeleteAutocompleteIndexResponse(json);
		})
	}
	
// GetIndex gets an AutocompleteIndex.
	async getIndex(getAutocompleteIndexRequest?: GetAutocompleteIndexRequest): Promise<GetAutocompleteIndexResponse> {
		if (getAutocompleteIndexRequest == null) {
			getAutocompleteIndexRequest = new GetAutocompleteIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.GetIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.GetIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(getAutocompleteIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.GetIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new GetAutocompleteIndexResponse(json);
		})
	}
	
// GetIndexes gets a list of AutocompleteIndexes.
	async getIndexes(getAutocompleteIndexesRequest?: GetAutocompleteIndexesRequest): Promise<GetAutocompleteIndexesResponse> {
		if (getAutocompleteIndexesRequest == null) {
			getAutocompleteIndexesRequest = new GetAutocompleteIndexesRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.GetIndexes: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.GetIndexes', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(getAutocompleteIndexesRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.GetIndexes: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new GetAutocompleteIndexesResponse(json);
		})
	}
	
// PutDoc puts a document into an AutocompleteIndex.
	async putDoc(putAutocompleteDocRequest?: PutAutocompleteDocRequest): Promise<PutAutocompleteDocResponse> {
		if (putAutocompleteDocRequest == null) {
			putAutocompleteDocRequest = new PutAutocompleteDocRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: AutocompleteService.PutDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.PutDoc', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(putAutocompleteDocRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: AutocompleteService.PutDoc: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new PutAutocompleteDocResponse(json);
		})
	}
	
}

// IndexService provides the ability to create and manage full-text indexes, as
// well as populate them with data, and perform searches.
export class IndexService {
	constructor(readonly client: Client) {}
	
// CreateIndex creates a new index.
	async createIndex(createIndexRequest?: CreateIndexRequest): Promise<CreateIndexResponse> {
		if (createIndexRequest == null) {
			createIndexRequest = new CreateIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.CreateIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.CreateIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(createIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.CreateIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new CreateIndexResponse(json);
		})
	}
	
// DeleteDoc removes a document from an Index. Once deleted, it will stop appearing
// in search results.
	async deleteDoc(deleteDocRequest?: DeleteDocRequest): Promise<DeleteDocResponse> {
		if (deleteDocRequest == null) {
			deleteDocRequest = new DeleteDocRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.DeleteDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.DeleteDoc', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(deleteDocRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.DeleteDoc: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new DeleteDocResponse(json);
		})
	}
	
// DeleteIndex deletes the Index. All index data, as well as any metadata about
// this Index will be completely deleted.
	async deleteIndex(deleteIndexRequest?: DeleteIndexRequest): Promise<DeleteIndexResponse> {
		if (deleteIndexRequest == null) {
			deleteIndexRequest = new DeleteIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.DeleteIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.DeleteIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(deleteIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.DeleteIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new DeleteIndexResponse(json);
		})
	}
	
// GetIndex gets an Index.
	async getIndex(getIndexRequest?: GetIndexRequest): Promise<GetIndexResponse> {
		if (getIndexRequest == null) {
			getIndexRequest = new GetIndexRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.GetIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.GetIndex', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(getIndexRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.GetIndex: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new GetIndexResponse(json);
		})
	}
	
// GetIndexes gets a list of Indexes.
	async getIndexes(getIndexesRequest?: GetIndexesRequest): Promise<GetIndexesResponse> {
		if (getIndexesRequest == null) {
			getIndexesRequest = new GetIndexesRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.GetIndexes: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.GetIndexes', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(getIndexesRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.GetIndexes: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new GetIndexesResponse(json);
		})
	}
	
// PutDoc puts a document into an Index.
	async putDoc(putDocRequest?: PutDocRequest): Promise<PutDocResponse> {
		if (putDocRequest == null) {
			putDocRequest = new PutDocRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.PutDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.PutDoc', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(putDocRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.PutDoc: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new PutDocResponse(json);
		})
	}
	
// Search performs a search on an Index.
	async search(searchRequest?: SearchRequest): Promise<SearchResponse> {
		if (searchRequest == null) {
			searchRequest = new SearchRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: IndexService.Search: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/IndexService.Search', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(searchRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: IndexService.Search: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new SearchResponse(json);
		})
	}
	
}

// MetaService provides convenience methods to check or validate indexes. Most
// people will not need to use this service.
export class MetaService {
	constructor(readonly client: Client) {}
	
// CheckIndexName checks to see if an index name is available or not.
	async checkIndexName(checkIndexNameRequest?: CheckIndexNameRequest): Promise<CheckIndexNameResponse> {
		if (checkIndexNameRequest == null) {
			checkIndexNameRequest = new CheckIndexNameRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: MetaService.CheckIndexName: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/MetaService.CheckIndexName', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(checkIndexNameRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: MetaService.CheckIndexName: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new CheckIndexNameResponse(json);
		})
	}
	
// CheckIndexPath checks to see if an IndexPath is valid for creating an index.
	async checkIndexPath(checkIndexPathRequest?: CheckIndexPathRequest): Promise<CheckIndexPathResponse> {
		if (checkIndexPathRequest == null) {
			checkIndexPathRequest = new CheckIndexPathRequest();
		}
		const headers: any = {};
		if (this.client.apiKey) {
			headers['X-API-Key'] = this.client.apiKey;
		}
		headers['Accept'] = 'application/json';
		headers['Content-Type'] = 'application/json';
		if (this.client.fetch == null) {
			throw new Error(`firesearch: MetaService.CheckIndexPath: no fetch (try client.fetch = window.fetch.bind(window))`)
		}
		const response = await this.client.fetch(this.client.host + '/api/MetaService.CheckIndexPath', {
			method: 'POST',
			headers: headers,
			body: JSON.stringify(checkIndexPathRequest),
		})
		if (response.status !== 200) {
			throw new Error(`firesearch: MetaService.CheckIndexPath: ${response.status} ${response.statusText}`);
		}
		return response.json().then((json: any) => {
			if (json.error) {
				throw new Error(json.error);
			}
			return new CheckIndexPathResponse(json);
		})
	}
	
}



// GenerateKeyRequest is the input object for GenerateKey.
export class GenerateKeyRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPathPrefix = data.indexPathPrefix;
			
		
		}
	}

	// IndexPathPrefix is the collection path prefix in Firestore to provide access
// for. For example, if you put the prefix "firesearch/orgs/my-org" you will be
// able to perform searches on both "firesearch/orgs/my-org/cards" and
// "firesearch/orgs/my-org/messages" indexes.
	indexPathPrefix: string = stringDefault;

}

// GenerateKeyResponse is the output object for GenerateKey.
export class GenerateKeyResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.accessKey = data.accessKey;
			
		
			
			this.error = data.error;
			
		
		}
	}

	// AccessKey is the string that gets passed to `Search` and `Complete` methods to
// perform searches. Access keys are valid for 24 hours.
	accessKey: string = stringDefault;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// Field is a non-searchable key/value pair that can be filtered at query time.
export class Field {
	constructor(data?: any) {
		if (data) {
		
			
			this.key = data.key;
			
		
			
			this.value = data.value;
			
		
		}
	}

	// Key is the name of the field. Cannot begin with an underscore.
	key: string = stringDefault;

	// Value is the filterable value of this Field.
	value: any = anyDefault;

}

// AutocompleteDoc describes a document that can be searched.
export class AutocompleteDoc {
	constructor(data?: any) {
		if (data) {
		
			
			this.id = data.id;
			
		
			
			this.text = data.text;
			
		
			
				
					if (data.fields) {
						this.fields = new Array<Field>()
						for (let i = 0; i < data.fields.length; i++) {
							this.fields.push(new Field(data.fields[i]));
						}
					}
				
			
		
		}
	}

	// ID is the document identifier.
	id: string = stringDefault;

	// Text is a string that can be completed via a call to Complete.
	text: string = stringDefault;

	// Fields are the filterable fields for this document.
	fields?: Field[];

}

// AutocompleteIndex describes a search index.
export class AutocompleteIndex {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.name = data.name;
			
		
			
			this.caseSensitive = data.caseSensitive;
			
		
		}
	}

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	indexPath: string = stringDefault;

	// Name is an internal human readable name for this index. End users will never see
// this.
	name: string = stringDefault;

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	caseSensitive: boolean = booleanDefault;

}

// CompleteQuery describes a search query.
export class CompleteQuery {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.accessKey = data.accessKey;
			
		
			
			this.limit = data.limit;
			
		
			
			this.text = data.text;
			
		
		}
	}

	// IndexPath is the path of the index to search.
	indexPath: string = stringDefault;

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	accessKey: string = stringDefault;

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	limit: number = numberDefault;

	// Text contains a phrase to autocomplete.
	text: string = stringDefault;

}

// CompleteRequest is the input object for Search.
export class CompleteRequest {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.query = new CompleteQuery(data.query);
				
			
		
		}
	}

	// Query is the CompleteQuery to perform.
	query?: CompleteQuery;

}

// CompleteResponse is the output object for Search.
export class CompleteResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.query = new CompleteQuery(data.query);
				
			
		
			
				
					if (data.hits) {
						this.hits = new Array<AutocompleteDoc>()
						for (let i = 0; i < data.hits.length; i++) {
							this.hits.push(new AutocompleteDoc(data.hits[i]));
						}
					}
				
			
		
			
			this.duration = data.duration;
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Query is the CompleteQuery that generated these results.
	query?: CompleteQuery;

	// Hits are the search results.
	hits?: AutocompleteDoc[];

	// Duration is the milliseconds that the search took to execute in the server side
	duration: number = numberDefault;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// CreateAutocompleteIndexRequest is the input object for CreateAutocompleteIndex.
export class CreateAutocompleteIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new AutocompleteIndex(data.index);
				
			
		
		}
	}

	// Index is the AutocompleteIndex to create.
	index?: AutocompleteIndex;

}

// CreateAutocompleteIndexResponse is the output object for
// CreateAutocompleteIndex.
export class CreateAutocompleteIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new AutocompleteIndex(data.index);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Index is the AutocompleteIndex that was created.
	index?: AutocompleteIndex;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// DeleteAutocompleteDocRequest is the input object for DeleteAutocompleteDoc.
export class DeleteAutocompleteDocRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.id = data.id;
			
		
		}
	}

	// IndexPath is the AutocompleteIndex to delete from.
	indexPath: string = stringDefault;

	// ID is the identifier of the document to delete.
	id: string = stringDefault;

}

// DeleteAutocompleteDocResponse is the output object for DeleteAutocompleteDoc.
export class DeleteAutocompleteDocResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// DeleteAutocompleteIndexRequest is the input object for DeleteAutocompleteIndex.
export class DeleteAutocompleteIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
		}
	}

	// IndexPath is the collection path in Firestore that identifies an
// AutocompleteIndex.
	indexPath: string = stringDefault;

}

// DeleteAutocompleteIndexResponse is the output object for
// DeleteAutocompleteIndex.
export class DeleteAutocompleteIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// GetAutocompleteIndexRequest is the input object for GetAutocompleteIndex.
export class GetAutocompleteIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
		}
	}

	// IndexPath is the collection path in Firestore that identifies an
// AutocompleteIndex.
	indexPath: string = stringDefault;

}

// GetAutocompleteIndexResponse is the output object for GetAutocompleteIndex.
export class GetAutocompleteIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new AutocompleteIndex(data.index);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Index is the AutocompleteIndex that was created.
	index?: AutocompleteIndex;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// GetAutocompleteIndexesRequest is the input object for GetAutocompleteIndexes.
export class GetAutocompleteIndexesRequest {
	constructor(data?: any) {
		if (data) {
		
		}
	}

}

// GetAutocompleteIndexesResponse is the output object for GetAutocompleteIndexes.
export class GetAutocompleteIndexesResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					if (data.indexes) {
						this.indexes = new Array<AutocompleteIndex>()
						for (let i = 0; i < data.indexes.length; i++) {
							this.indexes.push(new AutocompleteIndex(data.indexes[i]));
						}
					}
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Indexes are the indexes managed by this service.
	indexes?: AutocompleteIndex[];

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// PutAutocompleteDocRequest is the input object for PutAutocompleteDoc.
export class PutAutocompleteDocRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
				
					this.doc = new AutocompleteDoc(data.doc);
				
			
		
		}
	}

	// IndexPath is the AutocompleteIndex to put a document to.
	indexPath: string = stringDefault;

	// Doc is the document to put.
	doc?: AutocompleteDoc;

}

// PutAutocompleteDocResponse is the output object for PutAutocompleteDoc.
export class PutAutocompleteDocResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// CheckIndexNameRequest is the input for CheckIndexPath.
export class CheckIndexNameRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexName = data.indexName;
			
		
		}
	}

	// IndexName is the name of the index to check.
	indexName: string = stringDefault;

}

// ValidationResult describes the result of a validation check.
export class ValidationResult {
	constructor(data?: any) {
		if (data) {
		
			
			this.valid = data.valid;
			
		
			
			this.message = data.message;
			
		
		}
	}

	// Valid indicates whether the validation was successful or not.
	valid: boolean = booleanDefault;

	// Message is a human readable objection, or empty if valid.
	message: string = stringDefault;

}

// CheckIndexNameResponse is the output for CheckIndexName.
export class CheckIndexNameResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.validationResult = new ValidationResult(data.validationResult);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// ValidationResult holds the result of the check.
	validationResult?: ValidationResult;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// CheckIndexPathRequest is the input object for CheckIndexPath.
export class CheckIndexPathRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
		}
	}

		indexPath: string = stringDefault;

}

// CheckIndexPathResponse is the output for CheckIndexPath.
export class CheckIndexPathResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.validationResult = new ValidationResult(data.validationResult);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// ValidationResult holds the result of the check.
	validationResult?: ValidationResult;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// GeoIndex describes a search index.
export class GeoIndex {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.name = data.name;
			
		
			
			this.language = data.language;
			
		
			
			this.keepStopWords = data.keepStopWords;
			
		
			
			this.caseSensitive = data.caseSensitive;
			
		
			
			this.noStem = data.noStem;
			
		
		}
	}

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	indexPath: string = stringDefault;

	// Name is an internal human readable name for this index. End users will never see
// this.
	name: string = stringDefault;

	// Language of the index.
	language: string = stringDefault;

	// KeepStopWords prevents stop words from being removed from this index.
	keepStopWords: boolean = booleanDefault;

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	caseSensitive: boolean = booleanDefault;

	// NoStem prevents words from being reduced. Only effective if a Language is
// specified.
	noStem: boolean = booleanDefault;

}

// Index describes a search index.
export class Index {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.name = data.name;
			
		
			
			this.language = data.language;
			
		
			
			this.keepStopWords = data.keepStopWords;
			
		
			
			this.caseSensitive = data.caseSensitive;
			
		
			
			this.noStem = data.noStem;
			
		
		}
	}

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	indexPath: string = stringDefault;

	// Name is an internal human readable name for this index. End users will never see
// this.
	name: string = stringDefault;

	// Language of the index.
	language: string = stringDefault;

	// KeepStopWords prevents stop words from being removed from this index.
	keepStopWords: boolean = booleanDefault;

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	caseSensitive: boolean = booleanDefault;

	// NoStem prevents words from being reduced. Only effective if a Language is
// specified.
	noStem: boolean = booleanDefault;

}

// CreateIndexRequest is the input object for CreateIndex.
export class CreateIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new Index(data.index);
				
			
		
		}
	}

	// Index is the Index to create.
	index?: Index;

}

// CreateIndexResponse is the output object for CreateIndex.
export class CreateIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new Index(data.index);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Index is the Index that was created.
	index?: Index;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// DeleteDocRequest is the input object for DeleteDoc.
export class DeleteDocRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.id = data.id;
			
		
		}
	}

	// IndexPath is the Index to delete from.
	indexPath: string = stringDefault;

	// ID is the identifier of the document to delete.
	id: string = stringDefault;

}

// DeleteDocResponse is the output object for DeleteDoc.
export class DeleteDocResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// DeleteIndexRequest is the input object for DeleteIndex.
export class DeleteIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
		}
	}

	// IndexPath is the collection path in Firestore that identifies an Index.
	indexPath: string = stringDefault;

}

// DeleteIndexResponse is the output object for DeleteIndex.
export class DeleteIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// SearchField is a text field that can be searched.
export class SearchField {
	constructor(data?: any) {
		if (data) {
		
			
			this.key = data.key;
			
		
			
			this.value = data.value;
			
		
			
			this.store = data.store;
			
		
		}
	}

	// Key is the name of the search field. Cannot begin with an underscore.
	key: string = stringDefault;

	// Value is the searchable text field.
	value: string = stringDefault;

	// Store tells Firesearch to store this value and return it in the search results.
// By default, although the field is searchable, the original value is not stored.
	store: boolean = booleanDefault;

}

// Doc describes a document that can be searched.
export class Doc {
	constructor(data?: any) {
		if (data) {
		
			
			this.id = data.id;
			
		
			
				
					if (data.searchFields) {
						this.searchFields = new Array<SearchField>()
						for (let i = 0; i < data.searchFields.length; i++) {
							this.searchFields.push(new SearchField(data.searchFields[i]));
						}
					}
				
			
		
			
				
					if (data.fields) {
						this.fields = new Array<Field>()
						for (let i = 0; i < data.fields.length; i++) {
							this.fields.push(new Field(data.fields[i]));
						}
					}
				
			
		
		}
	}

	// ID is the document identifier.
	id: string = stringDefault;

	// SearchFields are the searchable fields for this document.
	searchFields?: SearchField[];

	// Fields are the key/value pairs that make up this document. Fields can be
// returned in search results, and may be filtered.
	fields?: Field[];

}

// GeoDoc describes a document that can be searched.
export class GeoDoc {
	constructor(data?: any) {
		if (data) {
		
			
			this.id = data.id;
			
		
			
			this.lat = data.lat;
			
		
			
			this.lon = data.lon;
			
		
			
				
					if (data.searchFields) {
						this.searchFields = new Array<SearchField>()
						for (let i = 0; i < data.searchFields.length; i++) {
							this.searchFields.push(new SearchField(data.searchFields[i]));
						}
					}
				
			
		
			
				
					if (data.fields) {
						this.fields = new Array<Field>()
						for (let i = 0; i < data.fields.length; i++) {
							this.fields.push(new Field(data.fields[i]));
						}
					}
				
			
		
		}
	}

	// ID is the document identifier.
	id: string = stringDefault;

	// Lat is the latitude of the location.
	lat: number = numberDefault;

	// Lon is the longitude of the location.
	lon: number = numberDefault;

	// SearchFields are the searchable fields for this document.
	searchFields?: SearchField[];

	// Fields are the key/value pairs that make up this document. Fields can be
// returned in search results, and may be filtered.
	fields?: Field[];

}

// GeoSearchQuery describes a search query.
export class GeoSearchQuery {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.accessKey = data.accessKey;
			
		
			
			this.limit = data.limit;
			
		
			
			this.text = data.text;
			
		
			
			this.lat = data.lat;
			
		
			
			this.lon = data.lon;
			
		
			
			this.radius = data.radius;
			
		
			
				
					if (data.filters) {
						this.filters = new Array<Field>()
						for (let i = 0; i < data.filters.length; i++) {
							this.filters.push(new Field(data.filters[i]));
						}
					}
				
			
		
			
			this.select = data.select;
			
		
			
			this.searchFields = data.searchFields;
			
		
			
			this.cursor = data.cursor;
			
		
		}
	}

	// IndexPath is the path of the index to search.
	indexPath: string = stringDefault;

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	accessKey: string = stringDefault;

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	limit: number = numberDefault;

	// Text contains a phrase to search for.
	text: string = stringDefault;

	// Lat is the latitude of the location to search.
	lat: number = numberDefault;

	// Lon is the longitude of the location to search.
	lon: number = numberDefault;

	// Radius is the aproximate distance in kilometers from center described with Lat,
// Lon.
	radius: number = numberDefault;

	// Filters are a list of where filters to apply when performing the search.
	filters?: Field[];

	// Select lists the fields to get from the document. Filters are automatically
// included. To get search fields out, they must have been put with store set to
// true.
	select?: string[];

	// SearchFields is a list of fields to search. If empty, all fields will be
// searched.
	searchFields?: string[];

	// Cursor is a encoded string from a previous Query, that you can use to get more
// results.
	cursor: string = stringDefault;

}

// Highlight describes an area that specifically matches a search query.
export class Highlight {
	constructor(data?: any) {
		if (data) {
		
			
			this.field = data.field;
			
		
			
			this.text = data.text;
			
		
		}
	}

	// Field is the name of the field.
	field: string = stringDefault;

	// Text is the highlighted text.
	text: string = stringDefault;

}

// GeoSearchResult is a document that matches a search query.
export class GeoSearchResult {
	constructor(data?: any) {
		if (data) {
		
			
			this.id = data.id;
			
		
			
			this.lat = data.lat;
			
		
			
			this.lon = data.lon;
			
		
			
				
					if (data.fields) {
						this.fields = new Array<Field>()
						for (let i = 0; i < data.fields.length; i++) {
							this.fields.push(new Field(data.fields[i]));
						}
					}
				
			
		
			
				
					if (data.highlights) {
						this.highlights = new Array<Highlight>()
						for (let i = 0; i < data.highlights.length; i++) {
							this.highlights.push(new Highlight(data.highlights[i]));
						}
					}
				
			
		
			
			this.score = data.score;
			
		
		}
	}

	// ID is the document identifier.
	id: string = stringDefault;

	// Lat is the latitude of the location.
	lat: number = numberDefault;

	// Lon is the longitude of the location.
	lon: number = numberDefault;

	// Fields are the selected fields for this document.
	fields?: Field[];

	// Highlights describe areas within the text that specifically match the query.
	highlights?: Highlight[];

	// Score is a relative value for this query. Higher score is better.
	score: number = numberDefault;

}

// GetIndexRequest is the input object for GetIndex.
export class GetIndexRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
		}
	}

	// IndexPath is the collection path in Firestore that identifies an Index.
	indexPath: string = stringDefault;

}

// GetIndexResponse is the output object for GetIndex.
export class GetIndexResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.index = new Index(data.index);
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Index is the Index that was created.
	index?: Index;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// GetIndexesRequest is the input object for GetIndexes.
export class GetIndexesRequest {
	constructor(data?: any) {
		if (data) {
		
		}
	}

}

// GetIndexesResponse is the output object for GetIndexes.
export class GetIndexesResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					if (data.indexes) {
						this.indexes = new Array<Index>()
						for (let i = 0; i < data.indexes.length; i++) {
							this.indexes.push(new Index(data.indexes[i]));
						}
					}
				
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Indexes are the indexes managed by this service.
	indexes?: Index[];

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// PutDocRequest is the input object for PutDoc.
export class PutDocRequest {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
				
					this.doc = new Doc(data.doc);
				
			
		
		}
	}

	// IndexPath is the Index to put a document to.
	indexPath: string = stringDefault;

	// Doc is the document to put.
	doc?: Doc;

}

// PutDocResponse is the output object for PutDoc.
export class PutDocResponse {
	constructor(data?: any) {
		if (data) {
		
			
			this.error = data.error;
			
		
		}
	}

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}

// SearchQuery describes a search query.
export class SearchQuery {
	constructor(data?: any) {
		if (data) {
		
			
			this.indexPath = data.indexPath;
			
		
			
			this.accessKey = data.accessKey;
			
		
			
			this.limit = data.limit;
			
		
			
			this.text = data.text;
			
		
			
				
					if (data.filters) {
						this.filters = new Array<Field>()
						for (let i = 0; i < data.filters.length; i++) {
							this.filters.push(new Field(data.filters[i]));
						}
					}
				
			
		
			
			this.select = data.select;
			
		
			
			this.searchFields = data.searchFields;
			
		
			
			this.cursor = data.cursor;
			
		
		}
	}

	// IndexPath is the path of the index to search.
	indexPath: string = stringDefault;

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	accessKey: string = stringDefault;

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	limit: number = numberDefault;

	// Text contains a phrase to search for.
	text: string = stringDefault;

	// Filters are a list of where filters to apply when performing the search.
	filters?: Field[];

	// Select lists the fields to get from the document. Filters are automatically
// included. To get search fields out, they must have been put with store set to
// true.
	select?: string[];

	// SearchFields is a list of fields to search. If empty, all fields will be
// searched.
	searchFields?: string[];

	// Cursor is a encoded string from a previous Query, that you can use to get more
// results.
	cursor: string = stringDefault;

}

// SearchRequest is the input object for Search.
export class SearchRequest {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.query = new SearchQuery(data.query);
				
			
		
		}
	}

	// Query is the SearchQuery to perform.
	query?: SearchQuery;

}

// SearchResult is a document that matches a search query.
export class SearchResult {
	constructor(data?: any) {
		if (data) {
		
			
			this.id = data.id;
			
		
			
				
					if (data.fields) {
						this.fields = new Array<Field>()
						for (let i = 0; i < data.fields.length; i++) {
							this.fields.push(new Field(data.fields[i]));
						}
					}
				
			
		
			
				
					if (data.highlights) {
						this.highlights = new Array<Highlight>()
						for (let i = 0; i < data.highlights.length; i++) {
							this.highlights.push(new Highlight(data.highlights[i]));
						}
					}
				
			
		
			
			this.score = data.score;
			
		
		}
	}

	// ID is the document identifier.
	id: string = stringDefault;

	// Fields are the selected fields for this document.
	fields?: Field[];

	// Highlights describe areas within the text that specifically match the query.
	highlights?: Highlight[];

	// Score is a relative value for this query. Higher score is better.
	score: number = numberDefault;

}

// SearchResponse is the output object for Search.
export class SearchResponse {
	constructor(data?: any) {
		if (data) {
		
			
				
					this.query = new SearchQuery(data.query);
				
			
		
			
				
					if (data.hits) {
						this.hits = new Array<SearchResult>()
						for (let i = 0; i < data.hits.length; i++) {
							this.hits.push(new SearchResult(data.hits[i]));
						}
					}
				
			
		
			
			this.duration = data.duration;
			
		
			
			this.cursor = data.cursor;
			
		
			
			this.more = data.more;
			
		
			
			this.error = data.error;
			
		
		}
	}

	// Query is the SearchQuery that generated these results.
	query?: SearchQuery;

	// Hits are the search results.
	hits?: SearchResult[];

	// Duration is the milliseconds that the search took to execute in the server side
	duration: number = numberDefault;

	// Cursor is a encoded string that you can pass to a new Query to get more results.
	cursor: string = stringDefault;

	// More indicates that there may be more search results. If true, make the same
// Search request passing this Cursor. For performance reasons, Firesearch doesn't
// always know with certainty so it's possible the subsequent request will return
// no results.
	more: boolean = booleanDefault;

	// Error is string explaining what went wrong. Empty if everything was fine.
	error: string = stringDefault;

}


// these defaults make the template easier to write.
const stringDefault = ''
const numberDefault = 0
const booleanDefault = false 
const anyDefault = null
