//  Code generated by oto; DO NOT EDIT.

import Foundation

class Client {
	var host: String
	init(withHost url: String) {
		self.host = url
	}
}


// AccessKeyService provides keys needed to perform searches.
class AccessKeyService {
	var client: Client
	init(withClient client: Client) {
		self.client = client
	}

	// GenerateKey generates a key for an index path prefix to enable searches. The key
// expires after 24 hours.
	func generateKey(withRequest generateKeyRequest: GenerateKeyRequest, completion: @escaping (_ response: GenerateKeyResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AccessKeyService.GenerateKey"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(generateKeyRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var generateKeyResponse: GenerateKeyResponse
			do {
				generateKeyResponse = try JSONDecoder().decode(GenerateKeyResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if generateKeyResponse.error != nil {
				let err = OtoError("\(url): \(generateKeyResponse.error!)")
				completion(nil, err)
				return
			}
			completion(generateKeyResponse, nil)
		}
		task.resume()
	}

}

// AutocompleteService provides the ability to create and manage autocomplete
// indexes, as well as populate them with data, and perform lookups.
class AutocompleteService {
	var client: Client
	init(withClient client: Client) {
		self.client = client
	}

	// Complete performs a search on an AutocompleteIndex.
	func complete(withRequest completeRequest: CompleteRequest, completion: @escaping (_ response: CompleteResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.Complete"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(completeRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var completeResponse: CompleteResponse
			do {
				completeResponse = try JSONDecoder().decode(CompleteResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if completeResponse.error != nil {
				let err = OtoError("\(url): \(completeResponse.error!)")
				completion(nil, err)
				return
			}
			completion(completeResponse, nil)
		}
		task.resume()
	}

	// CreateIndex creates a new index.
	func createIndex(withRequest createAutocompleteIndexRequest: CreateAutocompleteIndexRequest, completion: @escaping (_ response: CreateAutocompleteIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.CreateIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(createAutocompleteIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var createAutocompleteIndexResponse: CreateAutocompleteIndexResponse
			do {
				createAutocompleteIndexResponse = try JSONDecoder().decode(CreateAutocompleteIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if createAutocompleteIndexResponse.error != nil {
				let err = OtoError("\(url): \(createAutocompleteIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(createAutocompleteIndexResponse, nil)
		}
		task.resume()
	}

	// DeleteDoc removes a document from an AutocompleteIndex. Once deleted, it will
// stop appearing in search results.
	func deleteDoc(withRequest deleteAutocompleteDocRequest: DeleteAutocompleteDocRequest, completion: @escaping (_ response: DeleteAutocompleteDocResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.DeleteDoc"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(deleteAutocompleteDocRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var deleteAutocompleteDocResponse: DeleteAutocompleteDocResponse
			do {
				deleteAutocompleteDocResponse = try JSONDecoder().decode(DeleteAutocompleteDocResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if deleteAutocompleteDocResponse.error != nil {
				let err = OtoError("\(url): \(deleteAutocompleteDocResponse.error!)")
				completion(nil, err)
				return
			}
			completion(deleteAutocompleteDocResponse, nil)
		}
		task.resume()
	}

	// DeleteIndex deletes the AutocompleteIndex. All index data, as well as any
// metadata about this AutocompleteIndex will be completely deleted.
	func deleteIndex(withRequest deleteAutocompleteIndexRequest: DeleteAutocompleteIndexRequest, completion: @escaping (_ response: DeleteAutocompleteIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.DeleteIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(deleteAutocompleteIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var deleteAutocompleteIndexResponse: DeleteAutocompleteIndexResponse
			do {
				deleteAutocompleteIndexResponse = try JSONDecoder().decode(DeleteAutocompleteIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if deleteAutocompleteIndexResponse.error != nil {
				let err = OtoError("\(url): \(deleteAutocompleteIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(deleteAutocompleteIndexResponse, nil)
		}
		task.resume()
	}

	// GetIndex gets an AutocompleteIndex.
	func getIndex(withRequest getAutocompleteIndexRequest: GetAutocompleteIndexRequest, completion: @escaping (_ response: GetAutocompleteIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.GetIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(getAutocompleteIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var getAutocompleteIndexResponse: GetAutocompleteIndexResponse
			do {
				getAutocompleteIndexResponse = try JSONDecoder().decode(GetAutocompleteIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if getAutocompleteIndexResponse.error != nil {
				let err = OtoError("\(url): \(getAutocompleteIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(getAutocompleteIndexResponse, nil)
		}
		task.resume()
	}

	// GetIndexes gets a list of AutocompleteIndexes.
	func getIndexes(withRequest getAutocompleteIndexesRequest: GetAutocompleteIndexesRequest, completion: @escaping (_ response: GetAutocompleteIndexesResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.GetIndexes"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(getAutocompleteIndexesRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var getAutocompleteIndexesResponse: GetAutocompleteIndexesResponse
			do {
				getAutocompleteIndexesResponse = try JSONDecoder().decode(GetAutocompleteIndexesResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if getAutocompleteIndexesResponse.error != nil {
				let err = OtoError("\(url): \(getAutocompleteIndexesResponse.error!)")
				completion(nil, err)
				return
			}
			completion(getAutocompleteIndexesResponse, nil)
		}
		task.resume()
	}

	// PutDoc puts a document into an AutocompleteIndex.
	func putDoc(withRequest putAutocompleteDocRequest: PutAutocompleteDocRequest, completion: @escaping (_ response: PutAutocompleteDocResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/AutocompleteService.PutDoc"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(putAutocompleteDocRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var putAutocompleteDocResponse: PutAutocompleteDocResponse
			do {
				putAutocompleteDocResponse = try JSONDecoder().decode(PutAutocompleteDocResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if putAutocompleteDocResponse.error != nil {
				let err = OtoError("\(url): \(putAutocompleteDocResponse.error!)")
				completion(nil, err)
				return
			}
			completion(putAutocompleteDocResponse, nil)
		}
		task.resume()
	}

}

// IndexService provides the ability to create and manage full-text indexes, as
// well as populate them with data, and perform searches.
class IndexService {
	var client: Client
	init(withClient client: Client) {
		self.client = client
	}

	// CreateIndex creates a new index.
	func createIndex(withRequest createIndexRequest: CreateIndexRequest, completion: @escaping (_ response: CreateIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.CreateIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(createIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var createIndexResponse: CreateIndexResponse
			do {
				createIndexResponse = try JSONDecoder().decode(CreateIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if createIndexResponse.error != nil {
				let err = OtoError("\(url): \(createIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(createIndexResponse, nil)
		}
		task.resume()
	}

	// DeleteDoc removes a document from an Index. Once deleted, it will stop appearing
// in search results.
	func deleteDoc(withRequest deleteDocRequest: DeleteDocRequest, completion: @escaping (_ response: DeleteDocResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.DeleteDoc"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(deleteDocRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var deleteDocResponse: DeleteDocResponse
			do {
				deleteDocResponse = try JSONDecoder().decode(DeleteDocResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if deleteDocResponse.error != nil {
				let err = OtoError("\(url): \(deleteDocResponse.error!)")
				completion(nil, err)
				return
			}
			completion(deleteDocResponse, nil)
		}
		task.resume()
	}

	// DeleteIndex deletes the Index. All index data, as well as any metadata about
// this Index will be completely deleted.
	func deleteIndex(withRequest deleteIndexRequest: DeleteIndexRequest, completion: @escaping (_ response: DeleteIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.DeleteIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(deleteIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var deleteIndexResponse: DeleteIndexResponse
			do {
				deleteIndexResponse = try JSONDecoder().decode(DeleteIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if deleteIndexResponse.error != nil {
				let err = OtoError("\(url): \(deleteIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(deleteIndexResponse, nil)
		}
		task.resume()
	}

	// GetIndex gets an Index.
	func getIndex(withRequest getIndexRequest: GetIndexRequest, completion: @escaping (_ response: GetIndexResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.GetIndex"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(getIndexRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var getIndexResponse: GetIndexResponse
			do {
				getIndexResponse = try JSONDecoder().decode(GetIndexResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if getIndexResponse.error != nil {
				let err = OtoError("\(url): \(getIndexResponse.error!)")
				completion(nil, err)
				return
			}
			completion(getIndexResponse, nil)
		}
		task.resume()
	}

	// GetIndexes gets a list of Indexes.
	func getIndexes(withRequest getIndexesRequest: GetIndexesRequest, completion: @escaping (_ response: GetIndexesResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.GetIndexes"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(getIndexesRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var getIndexesResponse: GetIndexesResponse
			do {
				getIndexesResponse = try JSONDecoder().decode(GetIndexesResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if getIndexesResponse.error != nil {
				let err = OtoError("\(url): \(getIndexesResponse.error!)")
				completion(nil, err)
				return
			}
			completion(getIndexesResponse, nil)
		}
		task.resume()
	}

	// PutDoc puts a document into an Index.
	func putDoc(withRequest putDocRequest: PutDocRequest, completion: @escaping (_ response: PutDocResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.PutDoc"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(putDocRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var putDocResponse: PutDocResponse
			do {
				putDocResponse = try JSONDecoder().decode(PutDocResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if putDocResponse.error != nil {
				let err = OtoError("\(url): \(putDocResponse.error!)")
				completion(nil, err)
				return
			}
			completion(putDocResponse, nil)
		}
		task.resume()
	}

	// Search performs a search on an Index.
	func search(withRequest searchRequest: SearchRequest, completion: @escaping (_ response: SearchResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/IndexService.Search"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(searchRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var searchResponse: SearchResponse
			do {
				searchResponse = try JSONDecoder().decode(SearchResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if searchResponse.error != nil {
				let err = OtoError("\(url): \(searchResponse.error!)")
				completion(nil, err)
				return
			}
			completion(searchResponse, nil)
		}
		task.resume()
	}

}

// MetaService provides convenience methods to check or validate indexes. Most
// people will not need to use this service.
class MetaService {
	var client: Client
	init(withClient client: Client) {
		self.client = client
	}

	// CheckIndexName checks to see if an index name is available or not.
	func checkIndexName(withRequest checkIndexNameRequest: CheckIndexNameRequest, completion: @escaping (_ response: CheckIndexNameResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/MetaService.CheckIndexName"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(checkIndexNameRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var checkIndexNameResponse: CheckIndexNameResponse
			do {
				checkIndexNameResponse = try JSONDecoder().decode(CheckIndexNameResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if checkIndexNameResponse.error != nil {
				let err = OtoError("\(url): \(checkIndexNameResponse.error!)")
				completion(nil, err)
				return
			}
			completion(checkIndexNameResponse, nil)
		}
		task.resume()
	}

	// CheckIndexPath checks to see if an IndexPath is valid for creating an index.
	func checkIndexPath(withRequest checkIndexPathRequest: CheckIndexPathRequest, completion: @escaping (_ response: CheckIndexPathResponse?, _ error: Error?) -> ()) {
		let url = "\(self.client.host)/api/MetaService.CheckIndexPath"
		var request = URLRequest(url: URL(string: url)!)
		request.httpMethod = "POST"
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Content-Type")
		request.addValue("application/json; charset=utf-8", forHTTPHeaderField: "Accept")
		var jsonData: Data
		do {
			jsonData = try JSONEncoder().encode(checkIndexPathRequest)
		} catch let err {
			completion(nil, err)
			return
		}
		request.httpBody = jsonData
		let session = URLSession(configuration: URLSessionConfiguration.default)
		let task = session.dataTask(with: request) { (data, response, error) in
			if let err = error {
				completion(nil, err)
				return
			}
			if let httpResponse = response as? HTTPURLResponse {
				if (httpResponse.statusCode != 200) {
					let err = OtoError("\(url): \(httpResponse.statusCode) status code")
					completion(nil, err)
					return
				}
			}
			var checkIndexPathResponse: CheckIndexPathResponse
			do {
				checkIndexPathResponse = try JSONDecoder().decode(CheckIndexPathResponse.self, from: data!)
			} catch let err {
				completion(nil, err)
				return
			}
			if checkIndexPathResponse.error != nil {
				let err = OtoError("\(url): \(checkIndexPathResponse.error!)")
				completion(nil, err)
				return
			}
			completion(checkIndexPathResponse, nil)
		}
		task.resume()
	}

}



// GenerateKeyRequest is the input object for GenerateKey.
struct GenerateKeyRequest: Codable {

	// IndexPathPrefix is the collection path prefix in Firestore to provide access
// for. For example, if you put the prefix "firesearch/orgs/my-org" you will be
// able to perform searches on both "firesearch/orgs/my-org/cards" and
// "firesearch/orgs/my-org/messages" indexes.
	var indexPathPrefix:  String?

}

// GenerateKeyResponse is the output object for GenerateKey.
struct GenerateKeyResponse: Codable {

	// AccessKey is the string that gets passed to `Search` and `Complete` methods to
// perform searches. Access keys are valid for 24 hours.
	var accessKey:  String?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// Field is a non-searchable key/value pair that can be filtered at query time.
struct Field: Codable {

	// Key is the name of the field. Cannot begin with an underscore.
	var key:  String?

	// Value is the filterable value of this Field.
	var value:  AnyCodable?

}

// AutocompleteDoc describes a document that can be searched.
struct AutocompleteDoc: Codable {

	// ID is the document identifier.
	var id:  String?

	// Text is a string that can be completed via a call to Complete.
	var text:  String?

	// Fields are the filterable fields for this document.
	var fields: [Field]?

}

// AutocompleteIndex describes a search index.
struct AutocompleteIndex: Codable {

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	var indexPath:  String?

	// Name is an internal human readable name for this index. End users will never see
// this.
	var name:  String?

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	var caseSensitive:  Bool?

}

// CompleteQuery describes a search query.
struct CompleteQuery: Codable {

	// IndexPath is the path of the index to search.
	var indexPath:  String?

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	var accessKey:  String?

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	var limit:  Double?

	// Text contains a phrase to autocomplete.
	var text:  String?

}

// CompleteRequest is the input object for Search.
struct CompleteRequest: Codable {

	// Query is the CompleteQuery to perform.
	var query: CompleteQuery?

}

// CompleteResponse is the output object for Search.
struct CompleteResponse: Codable {

	// Query is the CompleteQuery that generated these results.
	var query: CompleteQuery?

	// Hits are the search results.
	var hits: [AutocompleteDoc]?

	// Duration is the milliseconds that the search took to execute in the server side
	var duration:  Double?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// CreateAutocompleteIndexRequest is the input object for CreateAutocompleteIndex.
struct CreateAutocompleteIndexRequest: Codable {

	// Index is the AutocompleteIndex to create.
	var index: AutocompleteIndex?

}

// CreateAutocompleteIndexResponse is the output object for
// CreateAutocompleteIndex.
struct CreateAutocompleteIndexResponse: Codable {

	// Index is the AutocompleteIndex that was created.
	var index: AutocompleteIndex?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// DeleteAutocompleteDocRequest is the input object for DeleteAutocompleteDoc.
struct DeleteAutocompleteDocRequest: Codable {

	// IndexPath is the AutocompleteIndex to delete from.
	var indexPath:  String?

	// ID is the identifier of the document to delete.
	var id:  String?

}

// DeleteAutocompleteDocResponse is the output object for DeleteAutocompleteDoc.
struct DeleteAutocompleteDocResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// DeleteAutocompleteIndexRequest is the input object for DeleteAutocompleteIndex.
struct DeleteAutocompleteIndexRequest: Codable {

	// IndexPath is the collection path in Firestore that identifies an
// AutocompleteIndex.
	var indexPath:  String?

}

// DeleteAutocompleteIndexResponse is the output object for
// DeleteAutocompleteIndex.
struct DeleteAutocompleteIndexResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// GetAutocompleteIndexRequest is the input object for GetAutocompleteIndex.
struct GetAutocompleteIndexRequest: Codable {

	// IndexPath is the collection path in Firestore that identifies an
// AutocompleteIndex.
	var indexPath:  String?

}

// GetAutocompleteIndexResponse is the output object for GetAutocompleteIndex.
struct GetAutocompleteIndexResponse: Codable {

	// Index is the AutocompleteIndex that was created.
	var index: AutocompleteIndex?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// GetAutocompleteIndexesRequest is the input object for GetAutocompleteIndexes.
struct GetAutocompleteIndexesRequest: Codable {

}

// GetAutocompleteIndexesResponse is the output object for GetAutocompleteIndexes.
struct GetAutocompleteIndexesResponse: Codable {

	// Indexes are the indexes managed by this service.
	var indexes: [AutocompleteIndex]?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// PutAutocompleteDocRequest is the input object for PutAutocompleteDoc.
struct PutAutocompleteDocRequest: Codable {

	// IndexPath is the AutocompleteIndex to put a document to.
	var indexPath:  String?

	// Doc is the document to put.
	var doc: AutocompleteDoc?

}

// PutAutocompleteDocResponse is the output object for PutAutocompleteDoc.
struct PutAutocompleteDocResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// CheckIndexNameRequest is the input for CheckIndexPath.
struct CheckIndexNameRequest: Codable {

	// IndexName is the name of the index to check.
	var indexName:  String?

}

// ValidationResult describes the result of a validation check.
struct ValidationResult: Codable {

	// Valid indicates whether the validation was successful or not.
	var valid:  Bool?

	// Message is a human readable objection, or empty if valid.
	var message:  String?

}

// CheckIndexNameResponse is the output for CheckIndexName.
struct CheckIndexNameResponse: Codable {

	// ValidationResult holds the result of the check.
	var validationResult: ValidationResult?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// CheckIndexPathRequest is the input object for CheckIndexPath.
struct CheckIndexPathRequest: Codable {

		var indexPath:  String?

}

// CheckIndexPathResponse is the output for CheckIndexPath.
struct CheckIndexPathResponse: Codable {

	// ValidationResult holds the result of the check.
	var validationResult: ValidationResult?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// GeoIndex describes a search index.
struct GeoIndex: Codable {

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	var indexPath:  String?

	// Name is an internal human readable name for this index. End users will never see
// this.
	var name:  String?

	// Language of the index.
	var language:  String?

	// KeepStopWords prevents stop words from being removed from this index.
	var keepStopWords:  Bool?

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	var caseSensitive:  Bool?

	// NoStem prevents words from being reduced. Only effective if a Language is
// specified.
	var noStem:  Bool?

}

// Index describes a search index.
struct Index: Codable {

	// IndexPath is the collection path in Firestore for this index. Each index must
// use a unique path.
	var indexPath:  String?

	// Name is an internal human readable name for this index. End users will never see
// this.
	var name:  String?

	// Language of the index.
	var language:  String?

	// KeepStopWords prevents stop words from being removed from this index.
	var keepStopWords:  Bool?

	// CaseSensitive preserves case across this index. By default, all entries and
// queries are lowercased.
	var caseSensitive:  Bool?

	// NoStem prevents words from being reduced. Only effective if a Language is
// specified.
	var noStem:  Bool?

}

// CreateIndexRequest is the input object for CreateIndex.
struct CreateIndexRequest: Codable {

	// Index is the Index to create.
	var index: Index?

}

// CreateIndexResponse is the output object for CreateIndex.
struct CreateIndexResponse: Codable {

	// Index is the Index that was created.
	var index: Index?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// DeleteDocRequest is the input object for DeleteDoc.
struct DeleteDocRequest: Codable {

	// IndexPath is the Index to delete from.
	var indexPath:  String?

	// ID is the identifier of the document to delete.
	var id:  String?

}

// DeleteDocResponse is the output object for DeleteDoc.
struct DeleteDocResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// DeleteIndexRequest is the input object for DeleteIndex.
struct DeleteIndexRequest: Codable {

	// IndexPath is the collection path in Firestore that identifies an Index.
	var indexPath:  String?

}

// DeleteIndexResponse is the output object for DeleteIndex.
struct DeleteIndexResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// SearchField is a text field that can be searched.
struct SearchField: Codable {

	// Key is the name of the search field. Cannot begin with an underscore.
	var key:  String?

	// Value is the searchable text field.
	var value:  String?

	// Store tells Firesearch to store this value and return it in the search results.
// By default, although the field is searchable, the original value is not stored.
	var store:  Bool?

}

// Doc describes a document that can be searched.
struct Doc: Codable {

	// ID is the document identifier.
	var id:  String?

	// SearchFields are the searchable fields for this document.
	var searchFields: [SearchField]?

	// Fields are the key/value pairs that make up this document. Fields can be
// returned in search results, and may be filtered.
	var fields: [Field]?

}

// GeoDoc describes a document that can be searched.
struct GeoDoc: Codable {

	// ID is the document identifier.
	var id:  String?

	// Lat is the latitude of the location.
	var lat:  Double?

	// Lon is the longitude of the location.
	var lon:  Double?

	// SearchFields are the searchable fields for this document.
	var searchFields: [SearchField]?

	// Fields are the key/value pairs that make up this document. Fields can be
// returned in search results, and may be filtered.
	var fields: [Field]?

}

// GeoSearchQuery describes a search query.
struct GeoSearchQuery: Codable {

	// IndexPath is the path of the index to search.
	var indexPath:  String?

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	var accessKey:  String?

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	var limit:  Double?

	// Text contains a phrase to search for.
	var text:  String?

	// Lat is the latitude of the location to search.
	var lat:  Double?

	// Lon is the longitude of the location to search.
	var lon:  Double?

	// Radius is the aproximate distance in kilometers from center described with Lat,
// Lon.
	var radius:  Double?

	// Filters are a list of where filters to apply when performing the search.
	var filters: [Field]?

	// Select lists the fields to get from the document. Filters are automatically
// included. To get search fields out, they must have been put with store set to
// true.
	var select: [ String]?

	// SearchFields is a list of fields to search. If empty, all fields will be
// searched.
	var searchFields: [ String]?

	// Cursor is a encoded string from a previous Query, that you can use to get more
// results.
	var cursor:  String?

}

// Highlight describes an area that specifically matches a search query.
struct Highlight: Codable {

	// Field is the name of the field.
	var field:  String?

	// Text is the highlighted text.
	var text:  String?

}

// GeoSearchResult is a document that matches a search query.
struct GeoSearchResult: Codable {

	// ID is the document identifier.
	var id:  String?

	// Lat is the latitude of the location.
	var lat:  Double?

	// Lon is the longitude of the location.
	var lon:  Double?

	// Fields are the selected fields for this document.
	var fields: [Field]?

	// Highlights describe areas within the text that specifically match the query.
	var highlights: [Highlight]?

	// Score is a relative value for this query. Higher score is better.
	var score:  Double?

}

// GetIndexRequest is the input object for GetIndex.
struct GetIndexRequest: Codable {

	// IndexPath is the collection path in Firestore that identifies an Index.
	var indexPath:  String?

}

// GetIndexResponse is the output object for GetIndex.
struct GetIndexResponse: Codable {

	// Index is the Index that was created.
	var index: Index?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// GetIndexesRequest is the input object for GetIndexes.
struct GetIndexesRequest: Codable {

}

// GetIndexesResponse is the output object for GetIndexes.
struct GetIndexesResponse: Codable {

	// Indexes are the indexes managed by this service.
	var indexes: [Index]?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// PutDocRequest is the input object for PutDoc.
struct PutDocRequest: Codable {

	// IndexPath is the Index to put a document to.
	var indexPath:  String?

	// Doc is the document to put.
	var doc: Doc?

}

// PutDocResponse is the output object for PutDoc.
struct PutDocResponse: Codable {

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}

// SearchQuery describes a search query.
struct SearchQuery: Codable {

	// IndexPath is the path of the index to search.
	var indexPath:  String?

	// AccessKey authenticates the request. Get an AccessKey from the
// AccessKeyService.GenerateKey method.
	var accessKey:  String?

	// Limit is the maximum number of search results to return. Smaller limits are
// faster.
	var limit:  Double?

	// Text contains a phrase to search for.
	var text:  String?

	// Filters are a list of where filters to apply when performing the search.
	var filters: [Field]?

	// Select lists the fields to get from the document. Filters are automatically
// included. To get search fields out, they must have been put with store set to
// true.
	var select: [ String]?

	// SearchFields is a list of fields to search. If empty, all fields will be
// searched.
	var searchFields: [ String]?

	// Cursor is a encoded string from a previous Query, that you can use to get more
// results.
	var cursor:  String?

}

// SearchRequest is the input object for Search.
struct SearchRequest: Codable {

	// Query is the SearchQuery to perform.
	var query: SearchQuery?

}

// SearchResult is a document that matches a search query.
struct SearchResult: Codable {

	// ID is the document identifier.
	var id:  String?

	// Fields are the selected fields for this document.
	var fields: [Field]?

	// Highlights describe areas within the text that specifically match the query.
	var highlights: [Highlight]?

	// Score is a relative value for this query. Higher score is better.
	var score:  Double?

}

// SearchResponse is the output object for Search.
struct SearchResponse: Codable {

	// Query is the SearchQuery that generated these results.
	var query: SearchQuery?

	// Hits are the search results.
	var hits: [SearchResult]?

	// Duration is the milliseconds that the search took to execute in the server side
	var duration:  Double?

	// Cursor is a encoded string that you can pass to a new Query to get more results.
	var cursor:  String?

	// More indicates that there may be more search results. If true, make the same
// Search request passing this Cursor. For performance reasons, Firesearch doesn't
// always know with certainty so it's possible the subsequent request will return
// no results.
	var more:  Bool?

	// Error is string explaining what went wrong. Empty if everything was fine.
	var error:  String?

}


struct OtoError: LocalizedError
{
	var errorDescription: String? { return message }
	var failureReason: String? { return message }
	var recoverySuggestion: String? { return "" }
	var helpAnchor: String? { return "" }

	private var message : String

	init(_ description: String) {
		message = description
	}
}

struct AnyCodable: Decodable {
  var value: Any

  struct CodingKeys: CodingKey {
    var stringValue: String
    var intValue: Int?
    init?(intValue: Int) {
      self.stringValue = "\(intValue)"
      self.intValue = intValue
    }
    init?(stringValue: String) { self.stringValue = stringValue }
  }

  init(value: Any) {
    self.value = value
  }

  init(from decoder: Decoder) throws {
    if let container = try? decoder.container(keyedBy: CodingKeys.self) {
      var result = [String: Any]()
      try container.allKeys.forEach { (key) throws in
        result[key.stringValue] = try container.decode(AnyCodable.self, forKey: key).value
      }
      value = result
    } else if var container = try? decoder.unkeyedContainer() {
      var result = [Any]()
      while !container.isAtEnd {
        result.append(try container.decode(AnyCodable.self).value)
      }
      value = result
    } else if let container = try? decoder.singleValueContainer() {
      if let intVal = try? container.decode(Int.self) {
        value = intVal
      } else if let doubleVal = try? container.decode(Double.self) {
        value = doubleVal
      } else if let boolVal = try? container.decode(Bool.self) {
        value = boolVal
      } else if let stringVal = try? container.decode(String.self) {
        value = stringVal
      } else {
        throw DecodingError.dataCorruptedError(in: container, debugDescription: "the container contains nothing serialisable")
      }
    } else {
      throw DecodingError.dataCorrupted(DecodingError.Context(codingPath: decoder.codingPath, debugDescription: "Could not serialise"))
    }
  }
}

extension AnyCodable: Encodable {
  func encode(to encoder: Encoder) throws {
    if let array = value as? [Any] {
      var container = encoder.unkeyedContainer()
      for value in array {
        let decodable = AnyCodable(value: value)
        try container.encode(decodable)
      }
    } else if let dictionary = value as? [String: Any] {
      var container = encoder.container(keyedBy: CodingKeys.self)
      for (key, value) in dictionary {
        let codingKey = CodingKeys(stringValue: key)!
        let decodable = AnyCodable(value: value)
        try container.encode(decodable, forKey: codingKey)
      }
    } else {
      var container = encoder.singleValueContainer()
      if let intVal = value as? Int {
        try container.encode(intVal)
      } else if let doubleVal = value as? Double {
        try container.encode(doubleVal)
      } else if let boolVal = value as? Bool {
        try container.encode(boolVal)
      } else if let stringVal = value as? String {
        try container.encode(stringVal)
      } else {
        throw EncodingError.invalidValue(value, EncodingError.Context.init(codingPath: [], debugDescription: "The value is not encodable"))
      }

    }
  }
}

extension SearchResult {
	func valueField(key: String) -> (Any?) {
        let field = self.fields?.first(where: { (field: Field) -> Bool in
            return field.key == key
        })
		if field == nil {
			return nil
		}
		if field!.value == nil {
			return nil
		}
		return field!.value!.value
	}
}
