# Code generated by oto; DO NOT EDIT.

import requests
import json

class Client:
	"""Client provides access to the Firesearch API."""

	def __init__(self, host="http://localhost:8888", apiKey=""):
		self.host = host
		self.apiKey = apiKey
		if self.host == "":
			raise OtoError('host is missing')

class AccessKeyService:
	"""AccessKeyService provides keys needed to perform searches."""

	def __init__(self, client):
		self.client = client
	
	def generateKey(self, generateKeyRequest):
		"""GenerateKey generates a key for an index path prefix to enable searches. The key expires after 24 hours."""
		url = "{}/api/AccessKeyService.GenerateKey".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=generateKeyRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
class AutocompleteService:
	"""AutocompleteService provides the ability to create and manage autocomplete indexes, as well as populate them with data, and perform lookups."""

	def __init__(self, client):
		self.client = client
	
	def complete(self, completeRequest):
		"""Complete performs a search on an AutocompleteIndex."""
		url = "{}/api/AutocompleteService.Complete".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=completeRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def createIndex(self, createAutocompleteIndexRequest):
		"""CreateIndex creates a new index."""
		url = "{}/api/AutocompleteService.CreateIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=createAutocompleteIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def deleteDoc(self, deleteAutocompleteDocRequest):
		"""DeleteDoc removes a document from an AutocompleteIndex. Once deleted, it will stop appearing in search results."""
		url = "{}/api/AutocompleteService.DeleteDoc".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=deleteAutocompleteDocRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def deleteIndex(self, deleteAutocompleteIndexRequest):
		"""DeleteIndex deletes the AutocompleteIndex. All index data, as well as any metadata about this AutocompleteIndex will be completely deleted."""
		url = "{}/api/AutocompleteService.DeleteIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=deleteAutocompleteIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def getIndex(self, getAutocompleteIndexRequest):
		"""GetIndex gets an AutocompleteIndex."""
		url = "{}/api/AutocompleteService.GetIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=getAutocompleteIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def getIndexes(self, getAutocompleteIndexesRequest):
		"""GetIndexes gets a list of AutocompleteIndexes."""
		url = "{}/api/AutocompleteService.GetIndexes".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=getAutocompleteIndexesRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def putDoc(self, putAutocompleteDocRequest):
		"""PutDoc puts a document into an AutocompleteIndex."""
		url = "{}/api/AutocompleteService.PutDoc".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=putAutocompleteDocRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
class IndexService:
	"""IndexService provides the ability to create and manage full-text indexes, as well as populate them with data, and perform searches."""

	def __init__(self, client):
		self.client = client
	
	def createIndex(self, createIndexRequest):
		"""CreateIndex creates a new index."""
		url = "{}/api/IndexService.CreateIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=createIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def deleteDoc(self, deleteDocRequest):
		"""DeleteDoc removes a document from an Index. Once deleted, it will stop appearing in search results."""
		url = "{}/api/IndexService.DeleteDoc".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=deleteDocRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def deleteIndex(self, deleteIndexRequest):
		"""DeleteIndex deletes the Index. All index data, as well as any metadata about this Index will be completely deleted."""
		url = "{}/api/IndexService.DeleteIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=deleteIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def getIndex(self, getIndexRequest):
		"""GetIndex gets an Index."""
		url = "{}/api/IndexService.GetIndex".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=getIndexRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def getIndexes(self, getIndexesRequest):
		"""GetIndexes gets a list of Indexes."""
		url = "{}/api/IndexService.GetIndexes".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=getIndexesRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def putDoc(self, putDocRequest):
		"""PutDoc puts a document into an Index."""
		url = "{}/api/IndexService.PutDoc".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=putDocRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def search(self, searchRequest):
		"""Search performs a search on an Index."""
		url = "{}/api/IndexService.Search".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=searchRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
class MetaService:
	"""MetaService provides convenience methods to check or validate indexes. Most people will not need to use this service."""

	def __init__(self, client):
		self.client = client
	
	def checkIndexName(self, checkIndexNameRequest):
		"""CheckIndexName checks to see if an index name is available or not."""
		url = "{}/api/MetaService.CheckIndexName".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=checkIndexNameRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	
	def checkIndexPath(self, checkIndexPathRequest):
		"""CheckIndexPath checks to see if an IndexPath is valid for creating an index."""
		url = "{}/api/MetaService.CheckIndexPath".format(self.client.host)
		headers = {
			'Accept': 'application/json; charset=utf8',
			'Content-Type': 'application/json; charset=utf8',
			'X-API-Key': self.client.apiKey,
		}
		r = requests.post(url, json=checkIndexPathRequest, headers=headers)
		if r.status_code != 200:
			raise OtoError("status code: {}".format(r.status_code))
		j = r.json()
		if 'error' in j:
			err = j.get('error')
			if err != '':
				raise OtoError(err)
		return j
	



class OtoError(Exception):
	"""Base class for exceptions in this module."""
	pass

