// Code generated by oto; DO NOT EDIT.

'use strict';

const firesearch = {}
firesearch.Client = function(host) {
	this.host = host || ''
	this.getHeaders = function() {
		return {}
	}
	this.fetch = null
}


// AccessKeyService provides keys needed to perform searches.
firesearch.AccessKeyService = function(client) {
	this.client = client
}


firesearch.AccessKeyService.prototype.generateKey = async function(generateKeyRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AccessKeyService.GenerateKey: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AccessKeyService.GenerateKey', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(generateKeyRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AccessKeyService.GenerateKey: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}


// AutocompleteService provides the ability to create and manage autocomplete
// indexes, as well as populate them with data, and perform lookups.
firesearch.AutocompleteService = function(client) {
	this.client = client
}


firesearch.AutocompleteService.prototype.complete = async function(completeRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.Complete: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.Complete', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(completeRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.Complete: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.createIndex = async function(createAutocompleteIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.CreateIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.CreateIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(createAutocompleteIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.CreateIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.deleteDoc = async function(deleteAutocompleteDocRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.DeleteDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.DeleteDoc', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(deleteAutocompleteDocRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.DeleteDoc: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.deleteIndex = async function(deleteAutocompleteIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.DeleteIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.DeleteIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(deleteAutocompleteIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.DeleteIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.getIndex = async function(getAutocompleteIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.GetIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.GetIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(getAutocompleteIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.GetIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.getIndexes = async function(getAutocompleteIndexesRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.GetIndexes: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.GetIndexes', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(getAutocompleteIndexesRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.GetIndexes: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.AutocompleteService.prototype.putDoc = async function(putAutocompleteDocRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: AutocompleteService.PutDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/AutocompleteService.PutDoc', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(putAutocompleteDocRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: AutocompleteService.PutDoc: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}


// IndexService provides the ability to create and manage full-text indexes, as
// well as populate them with data, and perform searches.
firesearch.IndexService = function(client) {
	this.client = client
}


firesearch.IndexService.prototype.createIndex = async function(createIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.CreateIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.CreateIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(createIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.CreateIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.deleteDoc = async function(deleteDocRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.DeleteDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.DeleteDoc', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(deleteDocRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.DeleteDoc: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.deleteIndex = async function(deleteIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.DeleteIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.DeleteIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(deleteIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.DeleteIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.getIndex = async function(getIndexRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.GetIndex: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.GetIndex', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(getIndexRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.GetIndex: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.getIndexes = async function(getIndexesRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.GetIndexes: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.GetIndexes', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(getIndexesRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.GetIndexes: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.putDoc = async function(putDocRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.PutDoc: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.PutDoc', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(putDocRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.PutDoc: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.IndexService.prototype.search = async function(searchRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: IndexService.Search: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/IndexService.Search', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(searchRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: IndexService.Search: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}


// MetaService provides convenience methods to check or validate indexes. Most
// people will not need to use this service.
firesearch.MetaService = function(client) {
	this.client = client
}


firesearch.MetaService.prototype.checkIndexName = async function(checkIndexNameRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: MetaService.CheckIndexName: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/MetaService.CheckIndexName', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(checkIndexNameRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: MetaService.CheckIndexName: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}

firesearch.MetaService.prototype.checkIndexPath = async function(checkIndexPathRequest) {
	let headers = this.client.getHeaders();
	headers['Accept'] = 'application/json';
	headers['Content-Type'] = 'application/json';
	if (!this.client.fetch) {
		throw new Error(`firesearch: MetaService.CheckIndexPath: no fetch (try client.fetch = window.fetch.bind(window))`)
	}
	const response = await this.client.fetch(this.client.host + '/api/MetaService.CheckIndexPath', {
		method: 'POST',
		headers: headers,
		body: JSON.stringify(checkIndexPathRequest),
	})
	if (response.status !== 200) {
		throw new Error(`firesearch: MetaService.CheckIndexPath: ${response.status} ${response.statusText}`);
	}
	return response.json().then(json => {
		if (json.error) {
			throw new Error('firesearch: ' + json.error);
		}
		return json;
	})	
}


