// Code generated by oto; DO NOT EDIT.

package firesearch

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"strings"
	"time"

	"github.com/pkg/errors"
)

// Client is used to access Pace services.
type Client struct {
	// Host is the URL of the remote server that this Client should
	// access.
	Host string
	// APIKey is the string that provides access to the service.
	APIKey string
	// HTTPClient is the http.Client to use when making HTTP requests.
	HTTPClient *http.Client
	// Debug writes a line of debug log output.
	Debug func(s string)
}

// NewClient makes a new Client.
func NewClient(host string, apiKey string) *Client {
	c := &Client{
		Host:       host,
		APIKey:     apiKey,
		Debug:      func(s string) {},
		HTTPClient: &http.Client{Timeout: 10 * time.Second},
	}
	return c
}

// AccessKeyService provides keys needed to perform searches.
type AccessKeyService struct {
	client *Client
}

// NewAccessKeyService makes a new client for accessing AccessKeyService services.
func NewAccessKeyService(client *Client) *AccessKeyService {
	return &AccessKeyService{
		client: client,
	}
}

// GenerateKey generates a key for an index path prefix to enable searches. The key
// expires after 24 hours.
func (s *AccessKeyService) GenerateKey(ctx context.Context, r GenerateKeyRequest) (*GenerateKeyResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AccessKeyService.GenerateKey: marshal GenerateKeyRequest")
	}
	url := s.client.Host + "/api/AccessKeyService.GenerateKey"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AccessKeyService.GenerateKey: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AccessKeyService.GenerateKey")
	}
	defer resp.Body.Close()
	var response struct {
		GenerateKeyResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AccessKeyService.GenerateKey: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AccessKeyService.GenerateKey: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AccessKeyService.GenerateKey: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.GenerateKeyResponse, nil
}

// AutocompleteService provides the ability to create and manage autocomplete
// indexes, as well as populate them with data, and perform lookups.
type AutocompleteService struct {
	client *Client
}

// NewAutocompleteService makes a new client for accessing AutocompleteService services.
func NewAutocompleteService(client *Client) *AutocompleteService {
	return &AutocompleteService{
		client: client,
	}
}

// Complete performs a search on an AutocompleteIndex.
func (s *AutocompleteService) Complete(ctx context.Context, r CompleteRequest) (*CompleteResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.Complete: marshal CompleteRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.Complete"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.Complete: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.Complete")
	}
	defer resp.Body.Close()
	var response struct {
		CompleteResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.Complete: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.Complete: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.Complete: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.CompleteResponse, nil
}

// CreateIndex creates a new index.
func (s *AutocompleteService) CreateIndex(ctx context.Context, r CreateAutocompleteIndexRequest) (*CreateAutocompleteIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.CreateIndex: marshal CreateAutocompleteIndexRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.CreateIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.CreateIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.CreateIndex")
	}
	defer resp.Body.Close()
	var response struct {
		CreateAutocompleteIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.CreateIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.CreateIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.CreateIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.CreateAutocompleteIndexResponse, nil
}

// DeleteDoc removes a document from an AutocompleteIndex. Once deleted, it will
// stop appearing in search results.
func (s *AutocompleteService) DeleteDoc(ctx context.Context, r DeleteAutocompleteDocRequest) (*DeleteAutocompleteDocResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteDoc: marshal DeleteAutocompleteDocRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.DeleteDoc"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteDoc: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteDoc")
	}
	defer resp.Body.Close()
	var response struct {
		DeleteAutocompleteDocResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.DeleteDoc: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteDoc: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.DeleteDoc: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.DeleteAutocompleteDocResponse, nil
}

// DeleteIndex deletes the AutocompleteIndex. All index data, as well as any
// metadata about this AutocompleteIndex will be completely deleted.
func (s *AutocompleteService) DeleteIndex(ctx context.Context, r DeleteAutocompleteIndexRequest) (*DeleteAutocompleteIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteIndex: marshal DeleteAutocompleteIndexRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.DeleteIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteIndex")
	}
	defer resp.Body.Close()
	var response struct {
		DeleteAutocompleteIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.DeleteIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.DeleteIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.DeleteIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.DeleteAutocompleteIndexResponse, nil
}

// GetIndex gets an AutocompleteIndex.
func (s *AutocompleteService) GetIndex(ctx context.Context, r GetAutocompleteIndexRequest) (*GetAutocompleteIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndex: marshal GetAutocompleteIndexRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.GetIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndex")
	}
	defer resp.Body.Close()
	var response struct {
		GetAutocompleteIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.GetIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.GetIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.GetAutocompleteIndexResponse, nil
}

// GetIndexes gets a list of AutocompleteIndexes.
func (s *AutocompleteService) GetIndexes(ctx context.Context, r GetAutocompleteIndexesRequest) (*GetAutocompleteIndexesResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndexes: marshal GetAutocompleteIndexesRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.GetIndexes"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndexes: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndexes")
	}
	defer resp.Body.Close()
	var response struct {
		GetAutocompleteIndexesResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.GetIndexes: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.GetIndexes: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.GetIndexes: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.GetAutocompleteIndexesResponse, nil
}

// PutDoc puts a document into an AutocompleteIndex.
func (s *AutocompleteService) PutDoc(ctx context.Context, r PutAutocompleteDocRequest) (*PutAutocompleteDocResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.PutDoc: marshal PutAutocompleteDocRequest")
	}
	url := s.client.Host + "/api/AutocompleteService.PutDoc"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.PutDoc: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.PutDoc")
	}
	defer resp.Body.Close()
	var response struct {
		PutAutocompleteDocResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "AutocompleteService.PutDoc: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "AutocompleteService.PutDoc: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("AutocompleteService.PutDoc: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.PutAutocompleteDocResponse, nil
}

// IndexService provides the ability to create and manage full-text indexes, as
// well as populate them with data, and perform searches.
type IndexService struct {
	client *Client
}

// NewIndexService makes a new client for accessing IndexService services.
func NewIndexService(client *Client) *IndexService {
	return &IndexService{
		client: client,
	}
}

// CreateIndex creates a new index.
func (s *IndexService) CreateIndex(ctx context.Context, r CreateIndexRequest) (*CreateIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.CreateIndex: marshal CreateIndexRequest")
	}
	url := s.client.Host + "/api/IndexService.CreateIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.CreateIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.CreateIndex")
	}
	defer resp.Body.Close()
	var response struct {
		CreateIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.CreateIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.CreateIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.CreateIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.CreateIndexResponse, nil
}

// DeleteDoc removes a document from an Index. Once deleted, it will stop appearing
// in search results.
func (s *IndexService) DeleteDoc(ctx context.Context, r DeleteDocRequest) (*DeleteDocResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteDoc: marshal DeleteDocRequest")
	}
	url := s.client.Host + "/api/IndexService.DeleteDoc"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteDoc: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteDoc")
	}
	defer resp.Body.Close()
	var response struct {
		DeleteDocResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.DeleteDoc: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteDoc: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.DeleteDoc: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.DeleteDocResponse, nil
}

// DeleteIndex deletes the Index. All index data, as well as any metadata about
// this Index will be completely deleted.
func (s *IndexService) DeleteIndex(ctx context.Context, r DeleteIndexRequest) (*DeleteIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteIndex: marshal DeleteIndexRequest")
	}
	url := s.client.Host + "/api/IndexService.DeleteIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteIndex")
	}
	defer resp.Body.Close()
	var response struct {
		DeleteIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.DeleteIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.DeleteIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.DeleteIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.DeleteIndexResponse, nil
}

// GetIndex gets an Index.
func (s *IndexService) GetIndex(ctx context.Context, r GetIndexRequest) (*GetIndexResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndex: marshal GetIndexRequest")
	}
	url := s.client.Host + "/api/IndexService.GetIndex"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndex: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndex")
	}
	defer resp.Body.Close()
	var response struct {
		GetIndexResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.GetIndex: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndex: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.GetIndex: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.GetIndexResponse, nil
}

// GetIndexes gets a list of Indexes.
func (s *IndexService) GetIndexes(ctx context.Context, r GetIndexesRequest) (*GetIndexesResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndexes: marshal GetIndexesRequest")
	}
	url := s.client.Host + "/api/IndexService.GetIndexes"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndexes: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndexes")
	}
	defer resp.Body.Close()
	var response struct {
		GetIndexesResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.GetIndexes: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.GetIndexes: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.GetIndexes: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.GetIndexesResponse, nil
}

// PutDoc puts a document into an Index.
func (s *IndexService) PutDoc(ctx context.Context, r PutDocRequest) (*PutDocResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.PutDoc: marshal PutDocRequest")
	}
	url := s.client.Host + "/api/IndexService.PutDoc"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.PutDoc: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.PutDoc")
	}
	defer resp.Body.Close()
	var response struct {
		PutDocResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.PutDoc: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.PutDoc: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.PutDoc: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.PutDocResponse, nil
}

// Search performs a search on an Index.
func (s *IndexService) Search(ctx context.Context, r SearchRequest) (*SearchResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.Search: marshal SearchRequest")
	}
	url := s.client.Host + "/api/IndexService.Search"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.Search: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.Search")
	}
	defer resp.Body.Close()
	var response struct {
		SearchResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "IndexService.Search: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "IndexService.Search: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("IndexService.Search: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.SearchResponse, nil
}

// MetaService provides convenience methods to check or validate indexes. Most
// people will not need to use this service.
type MetaService struct {
	client *Client
}

// NewMetaService makes a new client for accessing MetaService services.
func NewMetaService(client *Client) *MetaService {
	return &MetaService{
		client: client,
	}
}

// CheckIndexName checks to see if an index name is available or not.
func (s *MetaService) CheckIndexName(ctx context.Context, r CheckIndexNameRequest) (*CheckIndexNameResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexName: marshal CheckIndexNameRequest")
	}
	url := s.client.Host + "/api/MetaService.CheckIndexName"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexName: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexName")
	}
	defer resp.Body.Close()
	var response struct {
		CheckIndexNameResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "MetaService.CheckIndexName: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexName: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("MetaService.CheckIndexName: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.CheckIndexNameResponse, nil
}

// CheckIndexPath checks to see if an IndexPath is valid for creating an index.
func (s *MetaService) CheckIndexPath(ctx context.Context, r CheckIndexPathRequest) (*CheckIndexPathResponse, error) {
	requestBodyBytes, err := json.Marshal(r)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexPath: marshal CheckIndexPathRequest")
	}
	url := s.client.Host + "/api/MetaService.CheckIndexPath"
	s.client.Debug(fmt.Sprintf("POST %s", url))
	s.client.Debug(fmt.Sprintf(">> %s", string(requestBodyBytes)))
	req, err := http.NewRequest(http.MethodPost, url, bytes.NewReader(requestBodyBytes))
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexPath: NewRequest")
	}
	req.Header.Set("Content-Type", "application/json")
	req.Header.Set("Accept-Encoding", "gzip")
	req.Header.Set("X-API-Key", s.client.APIKey)
	req = req.WithContext(ctx)
	resp, err := s.client.HTTPClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexPath")
	}
	defer resp.Body.Close()
	var response struct {
		CheckIndexPathResponse
		Error string
	}
	var bodyReader io.Reader = resp.Body
	if strings.Contains(resp.Header.Get("Content-Encoding"), "gzip") {
		decodedBody, err := gzip.NewReader(resp.Body)
		if err != nil {
			return nil, errors.Wrap(err, "MetaService.CheckIndexPath: new gzip reader")
		}
		defer decodedBody.Close()
		bodyReader = decodedBody
	}
	respBodyBytes, err := ioutil.ReadAll(bodyReader)
	if err != nil {
		return nil, errors.Wrap(err, "MetaService.CheckIndexPath: read response body")
	}
	if err := json.Unmarshal(respBodyBytes, &response); err != nil {
		if resp.StatusCode != http.StatusOK {
			return nil, errors.Errorf("MetaService.CheckIndexPath: (%d) %v", resp.StatusCode, string(respBodyBytes))
		}
		return nil, errors.Wrap(err, "decode json body")
	}
	if response.Error != "" {
		return nil, errors.New(response.Error)
	}
	return &response.CheckIndexPathResponse, nil
}

// GenerateKeyRequest is the input object for GenerateKey.
type GenerateKeyRequest struct {

	// IndexPathPrefix is the collection path prefix in Firestore to provide access
	// for. For example, if you put the prefix "firesearch/orgs/my-org" you will be
	// able to perform searches on both "firesearch/orgs/my-org/cards" and
	// "firesearch/orgs/my-org/messages" indexes.
	IndexPathPrefix string `json:"indexPathPrefix"`
}

// GenerateKeyResponse is the output object for GenerateKey.
type GenerateKeyResponse struct {

	// AccessKey is the string that gets passed to `Search` and `Complete` methods to
	// perform searches. Access keys are valid for 24 hours.
	AccessKey string `json:"accessKey"`
}

// Field is a non-searchable key/value pair that can be filtered at query time.
type Field struct {

	// Key is the name of the field. Cannot begin with an underscore.
	Key string `json:"key"`

	// Value is the filterable value of this Field.
	Value interface{} `json:"value"`
}

// AutocompleteDoc describes a document that can be searched.
type AutocompleteDoc struct {

	// ID is the document identifier.
	ID string `json:"id"`

	// Text is a string that can be completed via a call to Complete.
	Text string `json:"text"`

	// Fields are the filterable fields for this document.
	Fields []Field `json:"fields"`
}

// AutocompleteIndex describes a search index.
type AutocompleteIndex struct {

	// IndexPath is the collection path in Firestore for this index. Each index must
	// use a unique path.
	IndexPath string `json:"indexPath"`

	// Name is an internal human readable name for this index. End users will never see
	// this.
	Name string `json:"name"`

	// CaseSensitive preserves case across this index. By default, all entries and
	// queries are lowercased.
	CaseSensitive bool `json:"caseSensitive"`
}

// CompleteQuery describes a search query.
type CompleteQuery struct {

	// IndexPath is the path of the index to search.
	IndexPath string `json:"indexPath"`

	// AccessKey authenticates the request. Get an AccessKey from the
	// AccessKeyService.GenerateKey method.
	AccessKey string `json:"accessKey"`

	// Limit is the maximum number of search results to return. Smaller limits are
	// faster.
	Limit int `json:"limit"`

	// Text contains a phrase to autocomplete.
	Text string `json:"text"`
}

// CompleteRequest is the input object for Search.
type CompleteRequest struct {

	// Query is the CompleteQuery to perform.
	Query CompleteQuery `json:"query"`
}

// CompleteResponse is the output object for Search.
type CompleteResponse struct {

	// Query is the CompleteQuery that generated these results.
	Query CompleteQuery `json:"query"`

	// Hits are the search results.
	Hits []AutocompleteDoc `json:"hits"`

	// Duration is the milliseconds that the search took to execute in the server side
	Duration int `json:"duration"`
}

// CreateAutocompleteIndexRequest is the input object for CreateAutocompleteIndex.
type CreateAutocompleteIndexRequest struct {

	// Index is the AutocompleteIndex to create.
	Index AutocompleteIndex `json:"index"`
}

// CreateAutocompleteIndexResponse is the output object for
// CreateAutocompleteIndex.
type CreateAutocompleteIndexResponse struct {

	// Index is the AutocompleteIndex that was created.
	Index AutocompleteIndex `json:"index"`
}

// DeleteAutocompleteDocRequest is the input object for DeleteAutocompleteDoc.
type DeleteAutocompleteDocRequest struct {

	// IndexPath is the AutocompleteIndex to delete from.
	IndexPath string `json:"indexPath"`

	// ID is the identifier of the document to delete.
	ID string `json:"id"`
}

// DeleteAutocompleteDocResponse is the output object for DeleteAutocompleteDoc.
type DeleteAutocompleteDocResponse struct {
}

// DeleteAutocompleteIndexRequest is the input object for DeleteAutocompleteIndex.
type DeleteAutocompleteIndexRequest struct {

	// IndexPath is the collection path in Firestore that identifies an
	// AutocompleteIndex.
	IndexPath string `json:"indexPath"`
}

// DeleteAutocompleteIndexResponse is the output object for
// DeleteAutocompleteIndex.
type DeleteAutocompleteIndexResponse struct {
}

// GetAutocompleteIndexRequest is the input object for GetAutocompleteIndex.
type GetAutocompleteIndexRequest struct {

	// IndexPath is the collection path in Firestore that identifies an
	// AutocompleteIndex.
	IndexPath string `json:"indexPath"`
}

// GetAutocompleteIndexResponse is the output object for GetAutocompleteIndex.
type GetAutocompleteIndexResponse struct {

	// Index is the AutocompleteIndex that was created.
	Index AutocompleteIndex `json:"index"`
}

// GetAutocompleteIndexesRequest is the input object for GetAutocompleteIndexes.
type GetAutocompleteIndexesRequest struct {
}

// GetAutocompleteIndexesResponse is the output object for GetAutocompleteIndexes.
type GetAutocompleteIndexesResponse struct {

	// Indexes are the indexes managed by this service.
	Indexes []AutocompleteIndex `json:"indexes"`
}

// PutAutocompleteDocRequest is the input object for PutAutocompleteDoc.
type PutAutocompleteDocRequest struct {

	// IndexPath is the AutocompleteIndex to put a document to.
	IndexPath string `json:"indexPath"`

	// Doc is the document to put.
	Doc AutocompleteDoc `json:"doc"`
}

// PutAutocompleteDocResponse is the output object for PutAutocompleteDoc.
type PutAutocompleteDocResponse struct {
}

// CheckIndexNameRequest is the input for CheckIndexPath.
type CheckIndexNameRequest struct {

	// IndexName is the name of the index to check.
	IndexName string `json:"indexName"`
}

// ValidationResult describes the result of a validation check.
type ValidationResult struct {

	// Valid indicates whether the validation was successful or not.
	Valid bool `json:"valid"`

	// Message is a human readable objection, or empty if valid.
	Message string `json:"message"`
}

// CheckIndexNameResponse is the output for CheckIndexName.
type CheckIndexNameResponse struct {

	// ValidationResult holds the result of the check.
	ValidationResult ValidationResult `json:"validationResult"`
}

// CheckIndexPathRequest is the input object for CheckIndexPath.
type CheckIndexPathRequest struct {
	IndexPath string `json:"indexPath"`
}

// CheckIndexPathResponse is the output for CheckIndexPath.
type CheckIndexPathResponse struct {

	// ValidationResult holds the result of the check.
	ValidationResult ValidationResult `json:"validationResult"`
}

// GeoIndex describes a search index.
type GeoIndex struct {

	// IndexPath is the collection path in Firestore for this index. Each index must
	// use a unique path.
	IndexPath string `json:"indexPath"`

	// Name is an internal human readable name for this index. End users will never see
	// this.
	Name string `json:"name"`

	// Language of the index.
	Language string `json:"language"`

	// KeepStopWords prevents stop words from being removed from this index.
	KeepStopWords bool `json:"keepStopWords"`

	// CaseSensitive preserves case across this index. By default, all entries and
	// queries are lowercased.
	CaseSensitive bool `json:"caseSensitive"`

	// NoStem prevents words from being reduced. Only effective if a Language is
	// specified.
	NoStem bool `json:"noStem"`
}

// Index describes a search index.
type Index struct {

	// IndexPath is the collection path in Firestore for this index. Each index must
	// use a unique path.
	IndexPath string `json:"indexPath"`

	// Name is an internal human readable name for this index. End users will never see
	// this.
	Name string `json:"name"`

	// Language of the index.
	Language string `json:"language"`

	// KeepStopWords prevents stop words from being removed from this index.
	KeepStopWords bool `json:"keepStopWords"`

	// CaseSensitive preserves case across this index. By default, all entries and
	// queries are lowercased.
	CaseSensitive bool `json:"caseSensitive"`

	// NoStem prevents words from being reduced. Only effective if a Language is
	// specified.
	NoStem bool `json:"noStem"`
}

// CreateIndexRequest is the input object for CreateIndex.
type CreateIndexRequest struct {

	// Index is the Index to create.
	Index Index `json:"index"`
}

// CreateIndexResponse is the output object for CreateIndex.
type CreateIndexResponse struct {

	// Index is the Index that was created.
	Index Index `json:"index"`
}

// DeleteDocRequest is the input object for DeleteDoc.
type DeleteDocRequest struct {

	// IndexPath is the Index to delete from.
	IndexPath string `json:"indexPath"`

	// ID is the identifier of the document to delete.
	ID string `json:"id"`
}

// DeleteDocResponse is the output object for DeleteDoc.
type DeleteDocResponse struct {
}

// DeleteIndexRequest is the input object for DeleteIndex.
type DeleteIndexRequest struct {

	// IndexPath is the collection path in Firestore that identifies an Index.
	IndexPath string `json:"indexPath"`
}

// DeleteIndexResponse is the output object for DeleteIndex.
type DeleteIndexResponse struct {
}

// SearchField is a text field that can be searched.
type SearchField struct {

	// Key is the name of the search field. Cannot begin with an underscore.
	Key string `json:"key"`

	// Value is the searchable text field.
	Value string `json:"value"`

	// Store tells Firesearch to store this value and return it in the search results.
	// By default, although the field is searchable, the original value is not stored.
	Store bool `json:"store"`
}

// Doc describes a document that can be searched.
type Doc struct {

	// ID is the document identifier.
	ID string `json:"id"`

	// SearchFields are the searchable fields for this document.
	SearchFields []SearchField `json:"searchFields"`

	// Fields are the key/value pairs that make up this document. Fields can be
	// returned in search results, and may be filtered.
	Fields []Field `json:"fields"`
}

// GeoDoc describes a document that can be searched.
type GeoDoc struct {

	// ID is the document identifier.
	ID string `json:"id"`

	// Lat is the latitude of the location.
	Lat float64 `json:"lat"`

	// Lon is the longitude of the location.
	Lon float64 `json:"lon"`

	// SearchFields are the searchable fields for this document.
	SearchFields []SearchField `json:"searchFields"`

	// Fields are the key/value pairs that make up this document. Fields can be
	// returned in search results, and may be filtered.
	Fields []Field `json:"fields"`
}

// GeoSearchQuery describes a search query.
type GeoSearchQuery struct {

	// IndexPath is the path of the index to search.
	IndexPath string `json:"indexPath"`

	// AccessKey authenticates the request. Get an AccessKey from the
	// AccessKeyService.GenerateKey method.
	AccessKey string `json:"accessKey"`

	// Limit is the maximum number of search results to return. Smaller limits are
	// faster.
	Limit int `json:"limit"`

	// Text contains a phrase to search for.
	Text string `json:"text"`

	// Lat is the latitude of the location to search.
	Lat float64 `json:"lat"`

	// Lon is the longitude of the location to search.
	Lon float64 `json:"lon"`

	// Radius is the aproximate distance in kilometers from center described with Lat,
	// Lon.
	Radius float64 `json:"radius"`

	// Filters are a list of where filters to apply when performing the search.
	Filters []Field `json:"filters"`

	// Select lists the fields to get from the document. Filters are automatically
	// included. To get search fields out, they must have been put with store set to
	// true.
	Select []string `json:"select"`

	// SearchFields is a list of fields to search. If empty, all fields will be
	// searched.
	SearchFields []string `json:"searchFields"`

	// Cursor is a encoded string from a previous Query, that you can use to get more
	// results.
	Cursor string `json:"cursor"`
}

// Highlight describes an area that specifically matches a search query.
type Highlight struct {

	// Field is the name of the field.
	Field string `json:"field"`

	// Text is the highlighted text.
	Text string `json:"text"`
}

// GeoSearchResult is a document that matches a search query.
type GeoSearchResult struct {

	// ID is the document identifier.
	ID string `json:"id"`

	// Lat is the latitude of the location.
	Lat float64 `json:"lat"`

	// Lon is the longitude of the location.
	Lon float64 `json:"lon"`

	// Fields are the selected fields for this document.
	Fields []Field `json:"fields"`

	// Highlights describe areas within the text that specifically match the query.
	Highlights []Highlight `json:"highlights"`

	// Score is a relative value for this query. Higher score is better.
	Score float64 `json:"score"`
}

// GetIndexRequest is the input object for GetIndex.
type GetIndexRequest struct {

	// IndexPath is the collection path in Firestore that identifies an Index.
	IndexPath string `json:"indexPath"`
}

// GetIndexResponse is the output object for GetIndex.
type GetIndexResponse struct {

	// Index is the Index that was created.
	Index Index `json:"index"`
}

// GetIndexesRequest is the input object for GetIndexes.
type GetIndexesRequest struct {
}

// GetIndexesResponse is the output object for GetIndexes.
type GetIndexesResponse struct {

	// Indexes are the indexes managed by this service.
	Indexes []Index `json:"indexes"`
}

// PutDocRequest is the input object for PutDoc.
type PutDocRequest struct {

	// IndexPath is the Index to put a document to.
	IndexPath string `json:"indexPath"`

	// Doc is the document to put.
	Doc Doc `json:"doc"`
}

// PutDocResponse is the output object for PutDoc.
type PutDocResponse struct {
}

// SearchQuery describes a search query.
type SearchQuery struct {

	// IndexPath is the path of the index to search.
	IndexPath string `json:"indexPath"`

	// AccessKey authenticates the request. Get an AccessKey from the
	// AccessKeyService.GenerateKey method.
	AccessKey string `json:"accessKey"`

	// Limit is the maximum number of search results to return. Smaller limits are
	// faster.
	Limit int `json:"limit"`

	// Text contains a phrase to search for.
	Text string `json:"text"`

	// Filters are a list of where filters to apply when performing the search.
	Filters []Field `json:"filters"`

	// Select lists the fields to get from the document. Filters are automatically
	// included. To get search fields out, they must have been put with store set to
	// true.
	Select []string `json:"select"`

	// SearchFields is a list of fields to search. If empty, all fields will be
	// searched.
	SearchFields []string `json:"searchFields"`

	// Cursor is a encoded string from a previous Query, that you can use to get more
	// results.
	Cursor string `json:"cursor"`
}

// SearchRequest is the input object for Search.
type SearchRequest struct {

	// Query is the SearchQuery to perform.
	Query SearchQuery `json:"query"`
}

// SearchResult is a document that matches a search query.
type SearchResult struct {

	// ID is the document identifier.
	ID string `json:"id"`

	// Fields are the selected fields for this document.
	Fields []Field `json:"fields"`

	// Highlights describe areas within the text that specifically match the query.
	Highlights []Highlight `json:"highlights"`

	// Score is a relative value for this query. Higher score is better.
	Score float64 `json:"score"`
}

// SearchResponse is the output object for Search.
type SearchResponse struct {

	// Query is the SearchQuery that generated these results.
	Query SearchQuery `json:"query"`

	// Hits are the search results.
	Hits []SearchResult `json:"hits"`

	// Duration is the milliseconds that the search took to execute in the server side
	Duration int `json:"duration"`

	// Cursor is a encoded string that you can pass to a new Query to get more results.
	Cursor string `json:"cursor"`

	// More indicates that there may be more search results. If true, make the same
	// Search request passing this Cursor. For performance reasons, Firesearch doesn't
	// always know with certainty so it's possible the subsequent request will return
	// no results.
	More bool `json:"more"`
}

// FieldValue gets a value from the Fields by key.
func (s SearchResult) FieldValue(key string) (interface{}, bool) {
	for _, field := range s.Fields {
		if field.Key == key {
			return field.Value, true
		}
	}
	return nil, false
}
