# Contributing to DevProfiles

### 1. Forking the Repository
A fork is a local copy of the repository that is on your GitHub account, and you can make changes on that repository.

[**Click here to fork the repository.**](https://github.com/oyepriyansh/DevProfiles/fork)

### 2. Make changes 
Now go to the file in which you wanna make changes 
> Below is the example of adding a profile
<details open>
  <summary><h4>eg: Adding a Profile </h4></summary>


add following JSON code to `data.json` file

```json
  {
    "name": "YOUR_NAME",
    "image": "IMAGE_URL",
    "github": "YOUR GITHUB URL",
    "twitter": "YOUR X/TWITTER URL",
    "linkedin": "YOUR LINKEDIN URL",
    "skills": ["SKILL-1", "SKILL-2", "SKILL-3"]
  }
```

##### Fill Placeholder
Change/Replace the placeholders with your image and profiles urls
  - [YOUR_NAME] with your name
  - [IMAGE-URL] with your image URL
  - [SKILL-1], [SKILL-2], [SKILL-3] with your skills
  - [YOUR GITHUB URL], [YOUR X/TWITTER URL] & [YOUR LINKEDIN URL] with your Github, X/Twitter & LinkedIn profile URL repectively.
</details >

### 3. Pull Request 
- You can now commit changes to the your forked repository. Once you've made the changes you want, [create a pull request](https://github.com/oyepriyansh/DevProfiles/pulls). 
- Once you have submitted your pull request, it will be reviewed and merged as soon as possible.

> [!NOTE]
> **Make sure to add a good PR title**<br>
> example: `data: profile addition by John Doe`<br>
> PS: This one example is only for profile addition

> [!WARNING]
> Do not spam the repository with unnecessary PRs. Make sure to follow the project's [Code of Conduct](https://github.com/oyepriyansh/DevProfiles/blob/main/CODE_OF_CONDUCT.md).

> [!TIP]
> If you are new to open source contributions, you can refer to [this](https://opensource.guide/how-to-contribute/) guide by GitHub.