// Copyright 2023 owent

#pragma once

#include <libcopp/utils/config/libcopp_build_features.h>

LIBCOPP_COPP_NAMESPACE_BEGIN
/**
 * error code
 */
enum copp_error_code {
  COPP_EC_SUCCESS = 0,  //!< COPP_EC_SUCCESS

  COPP_EC_UNKNOWN = -101,                 //!< COPP_EC_UNKNOWN
  COPP_EC_EXTERNAL_INSERT_FAILED = -102,  //!< COPP_EC_EXTERNAL_INSERT_FAILED
  COPP_EC_EXTERNAL_ERASE_FAILED = -103,   //!< COPP_EC_EXTERNAL_ERASE_FAILED
  COPP_EC_IN_RESET = -104,                //!< COPP_EC_IN_RESET

  COPP_EC_ALLOC_STACK_FAILED = -201,  //!< COPP_EC_ALLOC_STACK_FAILED

  COPP_EC_NOT_INITED = -1001,              //!< COPP_EC_NOT_INITED
  COPP_EC_ALREADY_INITED = -1002,          //!< COPP_EC_ALREADY_INITED
  COPP_EC_ACCESS_VIOLATION = -1003,        //!< COPP_EC_ACCESS_VIOLATION
  COPP_EC_NOT_READY = -1004,               //!< COPP_EC_NOT_READY
  COPP_EC_NOT_RUNNING = -1005,             //!< COPP_EC_NOT_RUNNING
  COPP_EC_IS_RUNNING = -1006,              //!< COPP_EC_IS_RUNNING
  COPP_EC_ALREADY_FINISHED = -1007,        //!< COPP_EC_ALREADY_FINISHED
  COPP_EC_NOT_FOUND = -1008,               //!< COPP_EC_NOT_FOUND
  COPP_EC_ALREADY_EXIST = -1009,           //!< COPP_EC_ALREADY_EXIST
  COPP_EC_ARGS_ERROR = -1010,              //!< COPP_EC_ARGS_ERROR
  COPP_EC_CAST_FAILED = -1011,             //!< COPP_EC_CAST_FAILED
  COPP_EC_HAS_UNHANDLE_EXCEPTION = -1012,  //!< COPP_EC_CAST_FAILED

  COPP_EC_FCONTEXT_MAKE_FAILED = -2001,                  //!< COPP_EC_FCONTEXT_MAKE_FAILED
  COPP_EC_CAN_NOT_USE_CROSS_FCONTEXT_AND_FIBER = -2002,  //!< COPP_EC_CAN_NOT_USE_CROSS_FCONTEXT_AND_FIBER

  COPP_EC_TASK_CAN_NOT_WAIT_SELF = -3001,           //!< COPP_EC_TASK_CAN_NOT_WAIT_SELF
  COPP_EC_TASK_IS_EXITING = -3002,                  //!< COPP_EC_TASK_IS_EXITING
  COPP_EC_TASK_ADD_NEXT_FAILED = -3003,             //!< COPP_EC_TASK_ADD_NEXT_FAILED
  COPP_EC_TASK_NOT_IN_ACTION = -3004,               //!< COPP_EC_TASK_NOT_IN_ACTION
  COPP_EC_TASK_ALREADY_IN_ANOTHER_MANAGER = -3005,  //!< COPP_EC_TASK_ALREADY_IN_ANOTHER_MANAGER
  COPP_EC_TASK_IS_KILLED = -3006,                   //!< COPP_EC_TASK_IS_KILLED
};
LIBCOPP_COPP_NAMESPACE_END
