# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

# -- Project information -----------------------------------------------------
# import sphinx_readable_theme
import datetime
import codecs
import os
import re
import shutil

project = 'libcopp'
copyright = '{0}, libcopp'.format(datetime.datetime.now().year)
author = 'owent'

# The full version, including alpha/beta/rc tags
release = '1.0.0'

CMAKELISTS_FILE_CONTENT = codecs.open(os.path.join(os.path.dirname(__file__), '..', '..', 'CMakeLists.txt'), "r", "utf-8").read()

LIBCOPP_VERSION = re.search('VERSION\\s*"?(?P<VERSION>[\\d\\.]+)', CMAKELISTS_FILE_CONTENT)

if LIBCOPP_VERSION is not None:
    release = LIBCOPP_VERSION.group('VERSION')

# README_FILE_CONTENT = codecs.open(os.path.join(os.path.dirname(__file__), '..', '..', 'README.rst'), "r", "utf-8").read()
# README_FILE_STREAM = codecs.open(os.path.join(os.path.dirname(__file__), 'README.rst'), "w", "utf-8")
# README_FILE_STREAM.write(
#     # README_FILE_CONTENT
#     re.sub('docs[\\/\\\\]sphinx[\\/\\\\]', '', README_FILE_CONTENT)
# )
# README_FILE_STREAM.close()

for COPY_FILE_NAME in ['README.rst', 'CHANGELOG.md']:
    SRC_FILE_PATH = os.path.join(os.path.dirname(__file__), '..', '..', COPY_FILE_NAME)
    DST_FILE_PATH = os.path.join(os.path.dirname(__file__), COPY_FILE_NAME)
    if os.path.exists(DST_FILE_PATH):
        os.remove(DST_FILE_PATH)
    shutil.copy2(SRC_FILE_PATH, DST_FILE_PATH, follow_symlinks=True)


# -- General configuration ---------------------------------------------------
# see http://www.sphinx-doc.org/en/master/usage/configuration.html

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.imgmath',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'recommonmark',
    'breathe',
    'sphinx_rtd_theme',
]

breathe_default_project = "libcopp"

source_suffix = {
    '.rst': 'restructuredtext',
    '.txt': 'markdown',
    '.md': 'markdown',
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en_US'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------
pygments_style = 'default'

highlight_options = {
    'linenos': True,
    'tabsize': 4
}

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'readable'
# html_theme_path = [sphinx_readable_theme.get_html_theme_path()] # [csp.get_theme_dir()]
html_theme = 'sphinx_rtd_theme'
html_logo = '_static/icon.png'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = { 
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_css_files = ['css/highlight.css', 'css/custom.css']
html_js_files = ['js/setup_lineno.js']
html_static_path = ['_static']


# -- Extension configuration -------------------------------------------------

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# custom styles
def setup(app):
    app.add_config_value('recommonmark_config', {
        'enable_auto_toc_tree': True,
        'enable_math': True,
        'enable_inline_math': True
    }, True)

