Authentication
--------------

# Description

The authentication module allows to request login/password information before send data into a response.

## Features

The module may use several method for the request :

 1. Basic: the login/password are sent with Base64 encoding. This method allows to use all method of password storage, but the password is readable during the communication.
 2. Digest: the login/password are sent with encoding method. This method add more security during the communication but some password storage are disallowed.
 3. None: this is not a real method, there is not login/password exchange, but this method allows to set the host user of the server process after the client connection.
 4. Bearer: there isn't any login/password but it use a token as authorization. This token may be stored inside the *user-Agent* or generated by a *Authorization* server. Read the [*Bearer* authentication page](auth_bearer.md)
 5. oAuth2: the login system is allocated to a *oAuth2* server basicly an *OpenID* server like [github.com](https://github.com). Currently *Ouistiti* is not able to create a oAuth2 server

The module may store the password into several formats:

 1. configuration file: the ouistiti configuration file contains only one login/password.
 2. text file: a file contains a list of login/password. The format is :
    <user>:<password>:<group>:<home>
    The password may be readable or encrypted with md5, sha256 or sha512. See below the encryption format and the tools.
 3. sqlite database: the database may replace the file with some advantages about the users management. See below for more information
 4. unix password system: the module uses directly the login informations of the host's users.
 5. jwt token: if the JWT support is available on *Ouistiti*, and any other storage system is configurated, the user information are stored inside the JWT token.

The module allows some other features:

 * if the login is a user on the system and the server still change the process owner, the module will do it.
 * the user's informations like "group" and "home" may be sent to the client and may be use by other modules.
 * the module may sent user's informations into the Set-Cookie headers or into specific headers (cf. configuration of "mode").
 * the module may discard the authentication of some URI or check authentication only on some URI.

# Build options:

 - AUTH : build this module.

 - AUTHN_NONE : add support of "None" login method.
 - AUTHN_BASIC : add support of "Basic" login method.
 - AUTHN_DIGEST : add support of "Digest" login method.
 - AUTHN_BEARER : add support of "Bearer" login method.
 - AUTHN_OAUTH2 : add support of "oAuth2" and "OpenID" login methods.

 - AUTHZ_SIMPLE : add support of password storage into the configuration file.
 - AUTHZ_FILE :  add support of password storage into text file.
 - AUTHZ_SQLITE : add support of password storage into sqlite database.
 - AUTHZ_UNIX : add support of unix login system.
 - AUTHZ_JWT : add support of JWT token containing user information.

# Configuration:

## server configuration:

### "auth" :
The authentication object of the server. Each server may contain one and only one object of the type.

## authentication configuration:

### "type" :
the authentication method:

 * "None" : this is not a real login and just set the process owner after client connection.
 * "Basic" : this is described into [RFC 7617](https://tools.ietf.org/html/rfc7617).
 * "Digest" : this is described into [RFC 7616](https://tools.ietf.org/html/rfc7616).
 * "[Bearer](auth_bearer.md)" : this is described into [RFC 6750](https://tools.ietf.org/html/rfc6750).
 * "oAuth2" : this is described into [RFC 6749](https://tools.ietf.org/html/rfc6749).

Example:
```config
type="Digest";
```

### "realm", "algorithm", "opaque" :
The *algorithm* and *opaque* are used with *Digest* authentication. The  RFC requires the support of sha256, but the default value is "MD5".

The *realm* is the "domain" where the authorization is allowed. The *realm* is shared between
the *User-Agent* and the *Client* server. As the *Authorization* is encrypted with the hash,
the password stored inside the server must be computed with the *realm* before checking.

 * "MD5"
 * "SHA1"
 * "SHA-256"
 * "SHA-512"

Example:
```config
algorithm="SHA-256";
realm="welcome on my website";
```

### "protect", "unprotect" :
Two strings, each one contains a list of pathes to request a login page.

By default all data from server needs authentication.

The *unprotect* string removes the authentication on some URL to allow to send data for
login page.

The *protect* string refuses any authentication on the URL matching the regular expressions.

Example:
```config
protect="^/logout$";
unprotect="^public/*,^js/*";
```

### "file" :
The path to the login/password storage file or unix login system.

Examples:
```config
file="/etc/ouistiti/passwd";
```

```config
file="shadow";
```

### "user", "passwd", "group", "home", "status" :
This is the simplest way to create an authentication. The configuration
may contains all information of the authentication. The *user* is always
mandatory, *passwd* is too mandatory excepting in *none* authentication.
The others information are optionals and dedicated on some features.
The *group* allows to use different *REST* API.
The *home* allows to store data specificly to an user, and translate the
URL "^~/*" to "$HOME/*" instead "$DOCROOT/*".
The *status* allows to change the use of the authentication. The normal
*status* is "activated", any other *status* force the authentication to
reject the user.

Example:
```config
user="nobody";
passwd="0u1sTi#i";
group="www-data";
home="/home/www-data";
```

The *passwd* may store the hash of the password instead the password in clear.
But the *Digest* authentication may know how to checking the password.

To use the *Digest* authentication, the hash must be associated with the
*realm* and the *algorithm* used for the encoding. In this case the password
storage needs the same information.
 * The first field of the password defines the *algorithm* of the encryption
	 * *a1* for *MD5*
	 * *a2* for *SHA1*
	 * *a5* for *SHA-256*
	 * *a6* for *SHA-512*
 * The second field is the *realm* used during the encryption. As this filed may be used
 to store the encryption *salt* too, the *realm* is frefixed with "realm=".
 * The third field is the *user*, *password* and *realm* encrypted.

```config
passwd="$a1$realm=ouistiti$k551eO2ePFGKRSrO52O86Q==";
```

**Note**: The *passwd* storage format is close to the *shadow* storage.
This one is compatible with *Ouistiti* but it hasn't to allow to use *Digest* authentication.

### "dbname" :
The path to the sqlite database file.

Example:
```config
dbname="/etc/ouistiti/passwd.db";
```

The database format is specific to *Ouistiti*. If the database doesn't exist, *Ouistiti* will generate one with two default user:
 * **root** with *passwd* **test**
 * **foo** with *passwd* **bar**

The database accepts the same storage as described in the previous section.

To manage the database a JsonRPC server is available with *Ouistiti*.
See below for more information.

### "options" :
A string with a list of options to set some features:

 * "home" : force the path on the directory of the user. All URL has to contains :
     *https://www.example.net/\<home\>/...*
 or the server send redirection on this URL.
 * "token" : generate token when the credentials are granted. This token is send inside a *X-Auth-token" *header* or *cookie*. This token may be used in preference of the credential for the following requests, and it may contain the user's setting for the server.
 * "cookie" : set cookie with user's setting:
    * USER=\<user>
    * GROUP=\<group>
    * HOME=\<home>
 * "header" : set header entries with the user's setting:
    * X-Remote-User: \<user>
    * X-Remote-Group: \<group>
    * X-Remote-Home: \<home>

Example:
```config
options="cookie,header";
```
### "signin" :
A path to a file for the login page. **This page is unprotected on the server**. When the *Authorization" is not granted, the server returns the *WWW-Authenticate* header and it returns the **302** redirection code with *Location* on this page, instead the **401** error code.

Example:
```config
signin="trust/login.html";
```

### "secret", "expire":
The *secret* string containing the key to encode the tokens.

The *expire* integer for the time in seconds, during the *token* is accepted before a new regenaration requirement.

Example:
```config
options:"token,cookie";
secret="ffacaa18-593b-4842-ad0d-04a6e6886be1";
expire=3600;
```

### "token_ep":
An URL to the token generator of the *Authorization* server.

*Bearer* amd *oAuth2* authentication redirect the *User-Agent* to this URL, when the *Authorization* is not granted.

**Note**: Read ["Bearer" authentication](auth_bearer.md) or ["oAuth2" authentication](auth_oauth2.md) for more information.

Example:
```config
type="oAuth2";
token_ep="https://auth.ouistiti.net/token_ep";
```

### "auth_ep":
An URL to the authentication checking of the *Authorization* server.

*oAuth2* authentication uses this URL to check the token from the *User-Agent* on the "Authorization* server.

**Note**: Read ["oAuth2" authentication](auth_oauth2.md) for more information.

Example:
```config
type="oAuth2";
auth_ep="https://auth.ouistiti.net/auth_ep";
```

## Examples
1. Simple *Basic* authentification, the web-browser opens a pop-up to enter "name" and "password":
```config
auth = {
	type="Basic";
        realm="ouistiti";
        user="agent";
        passwd="granted_password";
};
```

2. A *Digest* authentication with a login page and a token generator in cookie. The "login.html" page and it's dependencies are stored inside the $DOCROOT/trust directory:
```config
auth = {
	type="Digest";
	algorithm="SHA-256";
        realm="ouistiti";
        signin="/trust/login.html";
	unprotect="^trust/*";
	dbname="/etc/ouistiti/passwd.db";
	options="token,cookie";
        expire=3600;
        secret="ffacaa18-593b-4842-ad0d-04a6e6886be1";
};
```
3. A "Bearer" authentication with redirection to a token end point:
```config
auth = {
        realm = "ouistiti";
        type = "Bearer";
        options="token,cookie";
        token_ep = "https://auth.ouistiti.local:8443/redirect";
        secret="ffacaa18-593b-4842-ad0d-04a6e6886be1";
};
```

# Tools and usages:

## "ouipasswd"
This is a tool distributed with Ouistiti to generate line for password file storage.

### Build
HOST_UTILS=y must be set during the build.

```bash
$ make DEBUG=y HOST_UTILS=y
make[1] : ...
  HOSTCC ouipasswd
  HOSTLD ouipasswd
make[2] : ...
$ |
```

### Usage

```bash
$ ./host/utils/ouipasswd -R ouistiti -T Digest -A MD5 -u johndoe -p foobar -g users -H jdoe
johndoe:$a1$realm=ouistiti$rSBEWOmexQZg3BE/rPxOfw==:users:jdoe
$ ./host/utils/ouipasswd -R ouistiti -T Digest -A MD5 -u johndoe -p foobar -g users -H jdoe > /etc/ouistiti/passwd
$ |
```

## JsonRPC server
The JsonRPC server is a websocket server, dedicated to run with *Ouistiti*.
After to start *Ouistiti* and the websocket server, a web page allow to manage
the users inside a database.

The JsonRPC are managed with the authrpc.so module to load with *websocket_jsonrpc* tool.

### Build

WEBSOCKET=y must be set during the build.

```bash
$ make WEBSOCKET=y AUTH=y HOST_UTILS=y
```

### Configuration
*Ouistiti* must be configurated to allow the websocket and webauth.html file access:

```config
server = ({
		hostname = "www.ouistiti.local";
		port = 443;
		keepalivetimeout = 5;
		version="HTTP11";
		auth = {
			realm = "ouistiti";
			dbname = "/tmp/openid.db";
			type = "Digest";
			unprotect="^trust/*";
		};
		websocket = {
			docroot = "/var/run/ouistiti";
			allow = "*";
		};
		document = {
			docroot = "/srv/wwwS/htdocs/";
		};
		tls = {
			...
		};
	});
```

### Usage

```bash
$ ./utils/websocket_jsonrpc -R /var/run/ouistiti/ -n auth -u apache -L ./utils/authrpc.so -C /tmp/ouistiti.db
...
$ |
```

See websocket_rpc for more information on the usage.

### Websocket API:

#### RPC: auth
Authentication:
This command allows to authenticate the connection with the server. Some other commands require to be authenticated before using.
```json
{
	"jsonrpc":"2.0",
	"method":"auth",
	"params": {
		"user":"foo",
		"passwd":"bar"
	},
	"id":3740816340
}
```

#### RPC: passwd
Change password:
This command allows to change the password. The command requires the current password before to change it, or to be authenticated as "root".

```json
{
	"jsonrpc":"2.0",
	"method":"passwd",
	"params": {
		"user":"foo",
		"old":"bar",
		"new":"bar2",
		"confirm":"bar2"
	},
	"id":3740816340
}
```

#### RPC: adduser
Create new user:
This command allow to create a new user in the database.

```json
{
	"jsonrpc":"2.0",
	"method":"adduser",
	"params": {
		"user":"johndoe",
		"passwd":"foobar",
		"group":"users",
		"home":"jdoe"
	},
	"id":3740816340
}
```

#### RPC: rmuser
Remove an user:
This command allows to delete the entry of an user. The command require the current password of the user or to be authenticate as "root".

```json
{
	"jsonrpc":"2.0",
	"method":"rmuser",
	"params": {
		"user":"johndoe",
		"passwd":"foobar",
	},
	"id":3740816340
}
```

## Webservice REST API:
This feature is available with **mode_authmngt** module.

The Webservice URI is fixed with */auth/mngt* and supports the methods:
 * **GET** to retrieve on or more users information.
 * **PUT** to create a new user.
 * **POST** to modify an user.
 * **DELETE** to remove an user.

### GET:
Only the users from "root" group are allowed to **GET** all users, and may send a request on
*/auth/mngt*. Other user may send a request only on */auth/mngt/**username***.

The response is a JSON string with user's information.

### PUT:
Any body may create a user (but with the authentication, only authenticated people may create
an user). This user is member of *users* group, and his status is *approving*.

An account may not be created twice.

### POST:
Only the users from "root" group may modify the group and the status of the other users.
As new user has the "approving" status, this user must wait the acceptation form a "root" user.
This one has to change the *status* to "accepted".

### DELETE:
Only the user or the users from "root" group is allowed to remove a user.
