<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreRoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|min:3|unique:roles'
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'A name is required .',
            'name.min' => 'A name must be at least 3 characters .'
        ];
    }

    public function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json(
            $validator->errors()
            , 422));
    }

    public function attributes(): array
    {
        return [
            'name' => 'Role Name'
        ];
    }

    public function roles(): array
    {
        return [
            'name' => 'required|min:3'
        ];
    }
}
