"""Initial migration.

Revision ID: b62b013d2df2
Revises: 
Create Date: 2023-11-22 22:45:37.002433

"""
import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision = "b62b013d2df2"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "member",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=128), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "transaction",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("sender_id", sa.Integer(), nullable=True),
        sa.Column("receiver_id", sa.Integer(), nullable=True),
        sa.Column("amount", sa.Float(), nullable=True),
        sa.Column("algod_txid", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["receiver_id"],
            ["member.id"],
        ),
        sa.ForeignKeyConstraint(
            ["sender_id"],
            ["member.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("transaction")
    op.drop_table("member")
    # ### end Alembic commands ###
