# Related Projects of Open Source FPGA Foundation

## Hardware Infrastructure

### The OpenFPGA project
An award-winning open-source FPGA IP generator which supports highly-customizable homogeneous FPGA architectures.

Github repository: https://github.com/lnis-uofu/OpenFPGA

### 1st CLaaS
A framework for hardware acceleration of web and cloud applications using cloud FPGAs.

Github repository: https://github.com/stevehoover/1st-CLaaS

### Virtual FPGA Lab
Constructed within the [Makerchip IDE](https://makerchip.com), this [Virtual FPGA Lab](https://github.com/os-fpga/Virtual-FPGA-Lab) is a great onboarding environment for FPGA newcomers.

## Tooling

### The Verilog-to-Routing (VTR) project
The Verilog-to-Routing (VTR) project is a world-wide collaborative effort to provide a open-source framework for conducting FPGA architecture and CAD research and development. The VTR design flow takes as input a Verilog description of a digital circuit, and a description of the target FPGA architecture.

Github repository: https://github.com/verilog-to-routing/vtr-verilog-to-routing

License: MIT

### Symbiflow
SymbiFlow is a fully open source toolchain for the development of FPGAs of multiple vendors. Currently, it targets the Xilinx 7-Series, Lattice iCE40, Lattice ECP5 FPGAs, QuickLogic EOS S3 and is gradually being expanded to provide a comprehensive end-to-end FPGA synthesis flow.

Homepage: https://symbiflow.github.io/

License: MIT

### Yosys
Yosys is a framework for Verilog RTL synthesis. It currently has extensive Verilog-2005 support and provides a basic set of synthesis algorithms for various application domains.

Homepage: https://yosyshq.net/yosys/  
Github repository: https://github.com/YosysHQ/yosys  

License: ISC

### LSOracle
The Logic Synthesis oracle is a framework developed on the top of EPFL logic synthesis libraries to unlock efficient logic manipulation by using different logic optimizers.

Github repository: https://github.com/lnis-uofu/LSOracle

License: MIT

### The EPFL Logic Synthesis Libraries
The EPFL logic synthesis libraries are a collection of modular open source C++ libraries for the development of logic synthesis applications. All libraries are well documented and well tested. Being header-only, the libraries can be readily used as core components in complex logic synthesis frameworks.

Github repository: https://github.com/lsils/lstools-showcase

License: MIT

### Edalize
Edalize is a Python Library for interacting with EDA tools. It can create project files for supported tools and run them in batch or GUI mode (where supported).

Github repository: https://github.com/olofk/edalize

License: BSD-2-Clause

### GHDL
Analyzer, compiler, simulator and (experimental) synthesizer for VHDL. It currently has full support for the 1987, 1993, 2002, and partial for the 2008 revision of VHDL. Partial support of PSL. Can be used for synthesis & formal verification together with [ghdl-yosys-plugin](https://github.com/ghdl/ghdl-yosys-plugin) and (Symbi)Yosys.

Homepage: https://ghdl.github.io/ghdl

Github repository: https://github.com/ghdl/ghdl

License: GPL-2.0

### OSVVM
OSVVM is a VHDL verification framework, verification utility library, verification component library, and a simulator independent scripting flow.  OSVVM provides VHDL with buzz word verification capabilites including Transaction Level Modeling, Constrained Random, Functional Coverage, and Scoreboards that are simple to use and feel like built-in language features.  Our reporting capabilities includes HTML outputs for human readability and JUnit based XML for CI/CD tools.

Homepage: https://osvvm.github.io/

Github repository: https://github.com/OSVVM/OsvvmLibraries#readme

License: APACHE-2.0

### VUnit
VUnit is an open source testing framework for VHDL/SystemVerilog. It features verification support libraries and the functionality needed to realize continuous and automated testing of your HDL code.

Homepage: https://vunit.github.io

GitHub repository: https://github.com/VUnit/vunit

License: [MPL 2.0](https://www.mozilla.org/en-US/MPL/2.0)

### VerilogCreator
VerilogCreator is a QtCreator plugin. It turns QtCreator into a Verilog 2005 IDE.

Homepage: https://github.com/rochus-keller/verilogcreator/

Github repository:https://github.com/rochus-keller/verilogcreator/

License: GPL-2.0

## IP Ecosystem

### FuseSoC
FuseSoC is an award-winning package manager for IP cores. It is used by most prominent open source silicon projects and has a large ecosystem of available IP cores

Github repository: https://github.com/olofk/fusesoc

License: BSD-2-Clause

### The Skywater Open-source FPGAs
SOFA (**S**kywater **O**pensource **F**PG**A**s) are a series of open-source FPGA IPs using the open-source [Skywater 130nm PDK](https://github.com/google/skywater-pdk) and [OpenFPGA](https://github.com/lnis-uofu/OpenFPGA) framework

Github repository: https://github.com/lnis-uofu/SOFA

License: MIT

### openFPGALoader
Universal utility for programming FPGA

Github repository: https://github.com/trabucayre/openFPGALoader

License: AGPL-3.0

### LiteDRAM
LiteDRAM provides a small footprint and configurable DRAM core. LiteDRAM is part of LiteX libraries whose aims are to lower entry level of complex FPGA cores by providing simple, elegant and efficient implementations of components used in today's SoC such as Ethernet, SATA, PCIe, SDRAM Controller...

Github repository: https://github.com/enjoy-digital/litedram

License: BSD-2-Clause
