# Introduction
Followng these tutorials: https://www.youtube.com/watch?v=M576WGiDBdQ

# Chainlink
Chainlink is a decentralized oracle. centralized oracles would be single point of failure for decentralized networks.
- brings data to blockchain or executes some kind of computation
- provides an interface with real world data

# Hybrid contracts
contracts that talk to the outside world are called hybrid contracts.

Dapp = Smart contract = Decentralized app

# DAO - Decentralized Autonomous Organization
- live in contracts
- perform governance onchain - accept voting decisions on what to do


# Faucet
- application that gives us free test tokens like ETH on ropsten network

# Gas
- measure of computation use

- gas price: how much it costs per unit of gas
- gas limit: max amount of gas in a transaction
- transaction fee: Gas used * gas price

21000 gas @ 1 GWEI per gas = 21000 GWEI


# keys & account id
private public key pair is generated on ETH with ECDSA algorithm
- (private is random and public is derived)

account id is generated by using ETH's keccak256 hashing algorithm on top of your public key
that is used for signing transactions

private key generates > public key generates > address

# Consesus 
- how to agree on the same state in decentralized system

## 1. Chain selection
How do we know which blockchain is the real/true blockchain?
- on eth & bitcoin we use longest chain rule 
  - the longest blockchain is the real one.

block confirmations - how many blocks were added on top after your transaction 

PoW + longest chain rule together create the Nakamoto Consesus
- used by ETH 1 & Blockchain

## 2. Sybil Resistance
- system for blockchains to prevent malicious users from creating a large number of fake identities / nodes
- proof of work / stake

### PoW
- mining
no matter how many fake users you create, you still need to provide PoW for each of them. 
So you can't really easily fake your nodes

- costs electricity -> environmental impact

### PoS
PoS nodes put collateral in the blockchain
- that they're going to behave honestly
if they missbehave, they're going to be slashed/removed from the network 
and their staked funds will be taken away from them

validators are randomly chosen which one is going to propose a valid block
- and other nodes validate
blockchains are deterministic, so we can't truly use random validators
- ETH 2 uses "randout", this is a DAO that collectively chooses a random validator

-> considered slightly less decentralized network due to staking cost 
that's needed for participation

# Attacks
## Sybil attack
- user creates a tonne of psuedo accounts to influence a network

difficult on PoW blockchains because user would need to do a lot of mining

## 51% attack
if you contain the longest chain & you have 51% of the network nodes you can
create a fork of the network and bring the network on your longest chain

# Scalability
Gas prices fluctuate. The bigger the demand (the more transactions are requested at the same time),
the bigger gas prices become. 
This is not scalable, because more people are wanting to get inside the same block 
and they're pushing each other out while raising the gas price.
There's a ceiling to how many people can use the system,
because as gas prices keep rising, people won't be able to afford to perform transactions on the blockchain.

# Sharding

Blockchain of blockchains. There's a mainchain which coordinates all these other smaller blockchains. 
This increses the amount of effective block space that there is,
so more people can trade at lower cost/waiting times.

# Layers
layer 1
any base layer blockchain implementation
- BTC, ETH, Avalanche

layer 2
any applicaiton build on top of layer 1 
- chainlink, arbitrum, optimism
    - arbitrum & optimism are rollups - they rollup their transaction into layer 1 ETH


# Contracts

## visibility modifiers:
public, private, internal, external:
- external - cannot be called within the same contract
- internal - can only be called with other function inside the same contract
- private - only visible within the same contract and not from derived contracts
    - like external + forbidden access from derived contracts

default visibility is internal

making fields public, make them visible, but they're still readonly,
(fields can only be changed within functions?)

State changing functions are transactions

## functions that do not require transactions
keywords - view & pure
view - reads some state but does not change it
    - public variables are also "view functions"
pure - purely do some type of math (no reading of state)
    - eg "squareNumber(x) -> x * x"

## storage
function parameters can have 2 kinds of storage: memory & storage
memory - only stored during execution of the contract
storage - data will, persist even after function executes

strings are byte arrays, if you want a string in memory passed to a function,
you have to specifically tell that it's a memory variable

## Datastructures
Arrays:
- can be dynamic in size:
People[] public people;

- or static:
People[3] public people;

Mapping: (dictionary)
mapping(string => uint256) public nameToFavoriteNumber;
- cannot be looped through, for that you'd have to declare an additional array

tuple:
- can be constructed like so
(
    uint80 roundId,
    int256 answer,
    uint256 startedAt,
    uint256 updatedAt,
    uint80 answeredInRound
) = priceFeed.latestRoundData();

## payable functions
use payable keyword to define a function which can be used to pay for things.

payable functions can receive (g)wei/eth
- whenever you make a transaction to a payable function you can always append some value to it
- non payable functions cannot receive any value
- this value is not a part of function parameters, it lives outside of it
- once the function is called with given amount of wei, the ownership of that money is transfered
to the contract

msg.sender - the address which sent the value
msg.value - the amount of wei sent

## Chainlink nodes
- chainlink does not have nodes on simulated VMs, 
so in order to interact with it, you need to deploy it to some test net

## Importing
imports specify a path to solidity contracts inside npm packages. When solidity file compiles,
it copies the contents of the specified files to where the import statement is.
import "@chainlink/contracts/src/v0.6/interfaces/AggregatorV3Interface.sol";

most of the imported contracts are in fact interfaces. They're just like contracts,
but they're missing function implementations.

## Interfaces / ABI
Interfaces compile down to ABIs
ABI - Application Binary Interface
- just tells solidity how it can interact with other contracts

## using keyword
using A for B;
can be used to attach library functions from library A to any type B in the context of the contract.

## Libraries
- similar to contracts but they're deployed only once and their code is reused

## require
require statement stops execution & reverts the transaction if the condition is invalid
on blockchain you'll see "Gas estimation failed error", along with a custom error message.

## constructor
Is exucuted when contract is deployed, before anything else
- That's where you should define the owner 

## modifiers
- used to change behaviour of a function in declarative way.
```
modifier onlyOwner {
    require(msg.sender == owner, "you're not the owner");
     // wherever the _; statement is, this is where the rest of the code will be injected;
    _;
}

function withdraw() payable onlyOwner public {
    ...
} 
```

## Ganache
Is a simulated / fake blockchain used for local development of smart contracts 
- for even before putting it on the testnet

## Deploying contracts
To deploy contracts, you need to compile the solidity code
and then build a transaction. To build a transaction we need to specify:
- the chainId,
- from address (address that will be responsible for creating this transaciton)
- nonce (count of transactions on the account that is doing this transaction)
Then we need to sign the transaction with account's private key
and then send it on the blockchain
And lastly, we can wait for confirmation that the contract was deploye / transaction was confirmed
- we receive the so called transaction receipt

## using deployed contracts
using web3 .call() methods will only simulate executing the transactions
in order to actuall send a transaction to the blockchain we need to build one (with a new nonce),
sign it, then send it to the block chain & then wait for its receit

## Infura
used for blockchain development - easily connect to testnet with provided url
